/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.machine.v1.AlibabaCloudMachineProviderStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AlibabaCloudMachineProviderStatusFluent<A extends AlibabaCloudMachineProviderStatusFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String instanceId;
    private String instanceState;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Map<String, Object> additionalProperties;

    public AlibabaCloudMachineProviderStatusFluent() {
    }

    public AlibabaCloudMachineProviderStatusFluent(AlibabaCloudMachineProviderStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlibabaCloudMachineProviderStatus instance) {
        AlibabaCloudMachineProviderStatus alibabaCloudMachineProviderStatus = instance = instance != null ? instance : new AlibabaCloudMachineProviderStatus();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withConditions(instance.getConditions());
            this.withInstanceId(instance.getInstanceId());
            this.withInstanceState(instance.getInstanceState());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public A withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return (A)((Object)this);
    }

    public boolean hasInstanceId() {
        return this.instanceId != null;
    }

    public String getInstanceState() {
        return this.instanceState;
    }

    public A withInstanceState(String instanceState) {
        this.instanceState = instanceState;
        return (A)((Object)this);
    }

    public boolean hasInstanceState() {
        return this.instanceState != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlibabaCloudMachineProviderStatusFluent that = (AlibabaCloudMachineProviderStatusFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.instanceId, that.instanceId)) {
            return false;
        }
        if (!Objects.equals(this.instanceState, that.instanceState)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.conditions, this.instanceId, this.instanceState, this.kind, this.metadata, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.instanceId != null) {
            sb.append("instanceId:");
            sb.append(this.instanceId + ",");
        }
        if (this.instanceState != null) {
            sb.append("instanceState:");
            sb.append(this.instanceState + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)AlibabaCloudMachineProviderStatusFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

