/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.output.XMLOutputter;

final class MavenJDOMWriter {
    private final DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private final String lineSeparator;
    private final String indentation;

    public MavenJDOMWriter(String indentation) {
        this.lineSeparator = "\n";
        this.indentation = indentation;
    }

    public void write(Model project, Document document, Writer writer, XMLOutputter xmlOutputter) throws IOException {
        this.updateModel(project, Counter.initialCounter(), document.getRootElement());
        xmlOutputter.output(document, writer);
    }

    private void findAndReplaceProperties(Counter counter, Element parent, String name, Properties props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Iterator<Object> it = props.keySet().iterator();
            Counter innerCounter = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (element.getChild(key, parent.getNamespace()) == null) {
                    Element newProperty = this.factory.element(key, parent.getNamespace()).setText(props.getProperty(key));
                    innerCounter.setCurrentIndex(element.getContentSize());
                    this.insertAtPreferredLocation(element, newProperty, innerCounter);
                    continue;
                }
                this.findAndReplaceSimpleElement(innerCounter, element, key, props.getProperty(key), null, false);
            }
            Iterator itElem = element.getChildren().iterator();
            while (itElem.hasNext()) {
                Element elem = (Element)itElem.next();
                String key = elem.getName();
                if (props.containsKey(key)) continue;
                itElem.remove();
            }
        }
    }

    private void findAndReplaceSimpleElement(Counter counter, Element parent, String name, String text, String defaultValue, boolean preserveEmpty) {
        if (defaultValue != null && defaultValue.equals(text)) {
            Element element = parent.getChild(name, parent.getNamespace());
            if (element != null && !defaultValue.equals(element.getText())) {
                parent.removeContent((Content)element);
                this.removeExtraIndents(parent.getContent());
            }
            return;
        }
        boolean shouldExist = text != null && (preserveEmpty || !text.trim().isEmpty());
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            element.setText(text);
        }
    }

    private void findAndReplaceSimpleLists(Counter counter, Element parent, Collection<String> list, String parentName, String childName) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, parentName, shouldExist);
        if (shouldExist) {
            Iterator<String> it = list.iterator();
            Iterator elIt = element.getChildren(childName, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                String value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childName, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                el.setText(value);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void findAndReplaceXpp3DOM(Counter counter, Element parent, String name, Xpp3Dom dom) {
        boolean shouldExist = dom != null && (dom.getChildCount() > 0 || dom.getValue() != null);
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            this.replaceXpp3DOM(element, dom, counter.newNextDepthLevelCounter());
        }
    }

    private void insertAtPreferredLocation(Element parent, Element child, Counter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator it = parent.getContent().iterator();
        int offset = 0;
        while (it.hasNext() && elementCounter < counter.getCurrentIndex()) {
            Object next = it.next();
            ++offset;
            if (!(next instanceof Element)) continue;
            ++elementCounter;
            contentIndex += offset;
            offset = 0;
        }
        Text lastText = this.factory.text(this.lineSeparator + this.indentation.repeat(counter.getDepth()));
        if (parent.getContentSize() == 0) {
            Text finalText = lastText.clone();
            finalText.setText(finalText.getText().substring(0, finalText.getText().length() - this.indentation.length()));
            parent.addContent(contentIndex, (Content)finalText);
        }
        parent.addContent(contentIndex, (Content)child);
        parent.addContent(contentIndex, (Content)lastText);
    }

    private void iterateContributor(Counter counter, Element parent, Collection<Contributor> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "contributors", shouldExist);
        if (shouldExist) {
            Iterator<Contributor> it = list.iterator();
            Iterator elIt = element.getChildren("contributor", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Contributor value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("contributor", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateContributor(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateDependency(Counter counter, Element parent, Collection<Dependency> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "dependencies", shouldExist);
        if (shouldExist) {
            Iterator<Dependency> it = list.iterator();
            Iterator elIt = element.getChildren("dependency", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Dependency value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("dependency", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDependency(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void removeExtraIndents(List<Content> content) {
        Content current;
        for (int i = content.size() - 2; i > 0 && (current = content.get(i)) instanceof Text; --i) {
            content.remove(i);
        }
    }

    private void iterateDeveloper(Counter counter, Element parent, Collection<Developer> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "developers", shouldExist);
        if (shouldExist) {
            Iterator<Developer> it = list.iterator();
            Iterator elIt = element.getChildren("developer", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Developer value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("developer", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDeveloper(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateExclusion(Counter counter, Element parent, Collection<Exclusion> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "exclusions", shouldExist);
        if (shouldExist) {
            Iterator<Exclusion> it = list.iterator();
            Iterator elIt = element.getChildren("exclusion", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Exclusion value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("exclusion", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExclusion(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateExtension(Counter counter, Element parent, Collection<Extension> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "extensions", shouldExist);
        if (shouldExist) {
            Iterator<Extension> it = list.iterator();
            Iterator elIt = element.getChildren("extension", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Extension value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("extension", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExtension(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateLicense(Counter counter, Element parent, Collection<License> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "licenses", shouldExist);
        if (shouldExist) {
            Iterator<License> it = list.iterator();
            Iterator elIt = element.getChildren("license", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                License value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("license", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateLicense(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateMailingList(Counter counter, Element parent, Collection<MailingList> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "mailingLists", shouldExist);
        if (shouldExist) {
            Iterator<MailingList> it = list.iterator();
            Iterator elIt = element.getChildren("mailingList", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                MailingList value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("mailingList", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateMailingList(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateNotifier(Counter counter, Element parent, Collection<Notifier> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "notifiers", shouldExist);
        if (shouldExist) {
            Iterator<Notifier> it = list.iterator();
            Iterator elIt = element.getChildren("notifier", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Notifier value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("notifier", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateNotifier(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iteratePlugin(Counter counter, Element parent, Collection<Plugin> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "plugins", shouldExist);
        if (shouldExist) {
            Iterator<Plugin> it = list.iterator();
            Iterator elIt = element.getChildren("plugin", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Plugin value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("plugin", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePlugin(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iteratePluginExecution(Counter counter, Element parent, Collection<PluginExecution> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "executions", shouldExist);
        if (shouldExist) {
            Iterator<PluginExecution> it = list.iterator();
            Iterator elIt = element.getChildren("execution", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                PluginExecution value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("execution", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePluginExecution(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateProfile(Counter counter, Element parent, Collection<Profile> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "profiles", shouldExist);
        if (shouldExist) {
            Iterator<Profile> it = list.iterator();
            Iterator elIt = element.getChildren("profile", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Profile value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("profile", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateReportPlugin(Counter counter, Element parent, Collection<ReportPlugin> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "plugins", shouldExist);
        if (shouldExist) {
            Iterator<ReportPlugin> it = list.iterator();
            Iterator elIt = element.getChildren("plugin", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                ReportPlugin value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("plugin", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportPlugin(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateReportSet(Counter counter, Element parent, Collection<ReportSet> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "reportSets", shouldExist);
        if (shouldExist) {
            Iterator<ReportSet> it = list.iterator();
            Iterator elIt = element.getChildren("reportSet", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                ReportSet value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("reportSet", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportSet(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateRepository(Counter counter, Element parent, Collection<Repository> list, String parentTag, String childTag) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator<Repository> it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Repository value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void iterateResource(Counter counter, Element parent, Collection<Resource> list, String parentTag, String childTag) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator<Resource> it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = counter.newNextDepthLevelCounter();
            while (it.hasNext()) {
                Element el;
                Resource value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateResource(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
                this.removeExtraIndents(element.getContent());
            }
        }
    }

    private void replaceXpp3DOM(Element parent, Xpp3Dom parentDom, Counter counter) {
        if (parentDom.getChildCount() > 0) {
            Xpp3Dom[] children = parentDom.getChildren();
            ArrayList<Xpp3Dom> domChildren = new ArrayList<Xpp3Dom>(Arrays.asList(children));
            ListIterator it = parent.getChildren().listIterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                Iterator it2 = domChildren.iterator();
                Xpp3Dom corrDom = null;
                while (it2.hasNext()) {
                    Xpp3Dom dm = (Xpp3Dom)it2.next();
                    if (!dm.getName().equals(elem.getName())) continue;
                    corrDom = dm;
                    break;
                }
                if (corrDom != null) {
                    domChildren.remove(corrDom);
                    this.replaceXpp3DOM(elem, corrDom, counter.newNextDepthLevelCounter());
                    counter.increaseCount();
                    continue;
                }
                it.remove();
            }
            for (Xpp3Dom dm : domChildren) {
                Element elem = this.factory.element(dm.getName(), parent.getNamespace());
                for (String attName : dm.getAttributeNames()) {
                    elem.setAttribute(attName, dm.getAttribute(attName));
                }
                this.insertAtPreferredLocation(parent, elem, counter);
                counter.increaseCount();
                this.replaceXpp3DOM(elem, dm, counter.newNextDepthLevelCounter());
            }
        } else if (parentDom.getValue() != null) {
            parent.setText(parentDom.getValue());
        }
    }

    private void updateActivation(Activation value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "activation", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "activeByDefault", !value.isActiveByDefault() ? null : String.valueOf(value.isActiveByDefault()), "false", false);
            this.findAndReplaceSimpleElement(innerCount, root, "jdk", value.getJdk(), null, false);
            this.updateActivationOS(value.getOs(), innerCount, root);
            this.updateActivationProperty(value.getProperty(), innerCount, root);
            this.updateActivationFile(value.getFile(), innerCount, root);
        }
    }

    private void updateActivationFile(ActivationFile value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "file", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "missing", value.getMissing(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "exists", value.getExists(), null, false);
        }
    }

    private void updateActivationOS(ActivationOS value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "os", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "family", value.getFamily(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "arch", value.getArch(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
        }
    }

    private void updateActivationProperty(ActivationProperty value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "property", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "value", value.getValue(), null, false);
        }
    }

    private void updateBuild(Build value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "build", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "sourceDirectory", value.getSourceDirectory(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "scriptSourceDirectory", value.getScriptSourceDirectory(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "testSourceDirectory", value.getTestSourceDirectory(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", value.getOutputDirectory(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "testOutputDirectory", value.getTestOutputDirectory(), null, false);
            this.iterateExtension(innerCount, root, value.getExtensions());
            this.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", value.getDefaultGoal(), null, false);
            this.iterateResource(innerCount, root, value.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, value.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "finalName", value.getFinalName(), null, false);
            this.findAndReplaceSimpleLists(innerCount, root, value.getFilters(), "filters", "filter");
            this.updatePluginManagement(value.getPluginManagement(), innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    private void updateBuildBase(BuildBase value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "build", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", value.getDefaultGoal(), null, false);
            this.iterateResource(innerCount, root, value.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, value.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "finalName", value.getFinalName(), null, false);
            this.findAndReplaceSimpleLists(innerCount, root, value.getFilters(), "filters", "filter");
            this.updatePluginManagement(value.getPluginManagement(), innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    private void updateCiManagement(CiManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "ciManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "system", value.getSystem(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
            this.iterateNotifier(innerCount, root, value.getNotifiers());
        }
    }

    private void updateContributor(Contributor value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "email", value.getEmail(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "organization", value.getOrganization(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", value.getOrganizationUrl(), null, false);
        this.findAndReplaceSimpleLists(innerCount, root, value.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(innerCount, root, "timezone", value.getTimezone(), null, false);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    private void updateDependency(Dependency value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "type", value.getType(), "jar", false);
        this.findAndReplaceSimpleElement(innerCount, root, "classifier", value.getClassifier(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "scope", value.getScope(), "compile", false);
        this.findAndReplaceSimpleElement(innerCount, root, "systemPath", value.getSystemPath(), null, false);
        this.iterateExclusion(innerCount, root, value.getExclusions());
        this.findAndReplaceSimpleElement(innerCount, root, "optional", !value.isOptional() ? null : String.valueOf(value.isOptional()), "false", false);
    }

    private void updateDependencyManagement(DependencyManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "dependencyManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.iterateDependency(innerCount, root, value.getDependencies());
        }
    }

    private void updateDeploymentRepository(DeploymentRepository value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.updateRepositoryPolicy(value.getReleases(), "releases", innerCount, root);
            this.updateRepositoryPolicy(value.getSnapshots(), "snapshots", innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "uniqueVersion", value.isUniqueVersion() ? null : String.valueOf(value.isUniqueVersion()), "true", false);
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default", false);
        }
    }

    private void updateDeveloper(Developer value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "email", value.getEmail(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "organization", value.getOrganization(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", value.getOrganizationUrl(), null, false);
        this.findAndReplaceSimpleLists(innerCount, root, value.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(innerCount, root, "timezone", value.getTimezone(), null, false);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    private void updateDistributionManagement(DistributionManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "distributionManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.updateDeploymentRepository(value.getRepository(), "repository", innerCount, root);
            this.updateDeploymentRepository(value.getSnapshotRepository(), "snapshotRepository", innerCount, root);
            this.updateSite(value.getSite(), innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "downloadUrl", value.getDownloadUrl(), null, false);
            this.updateRelocation(value.getRelocation(), innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "status", value.getStatus(), null, false);
        }
    }

    private Element updateElement(Counter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name, parent.getNamespace());
        if (element != null && shouldExist) {
            counter.increaseCount();
        }
        if (element == null && shouldExist) {
            element = this.factory.element(name, parent.getNamespace());
            this.insertAtPreferredLocation(parent, element, counter);
            counter.increaseCount();
        }
        if (!shouldExist && element != null) {
            Text txt;
            Content previous;
            int index = parent.indexOf((Content)element);
            if (index > 0 && (previous = parent.getContent(index - 1)) instanceof Text && (txt = (Text)previous).getTextTrim().isEmpty()) {
                parent.removeContent((Content)txt);
            }
            parent.removeContent((Content)element);
        }
        return element;
    }

    private void updateExclusion(Exclusion value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
    }

    private void updateExtension(Extension value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
    }

    private void updateIssueManagement(IssueManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "issueManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "system", value.getSystem(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        }
    }

    private void updateLicense(License value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "distribution", value.getDistribution(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "comments", value.getComments(), null, false);
    }

    private void updateMailingList(MailingList value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "subscribe", value.getSubscribe(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "unsubscribe", value.getUnsubscribe(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "post", value.getPost(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "archive", value.getArchive(), null, false);
        this.findAndReplaceSimpleLists(innerCount, root, value.getOtherArchives(), "otherArchives", "otherArchive");
    }

    private void updateModel(Model value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceAttribute(root, "child.project.url.inherit.append.path", value.getChildProjectUrlInheritAppendPath(), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "modelVersion", value.getModelVersion(), null, false);
        this.updateParent(value.getParent(), innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "packaging", value.getPackaging(), "jar", false);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "description", value.getDescription(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "inceptionYear", value.getInceptionYear(), null, false);
        this.updateOrganization(value.getOrganization(), innerCount, root);
        this.iterateLicense(innerCount, root, value.getLicenses());
        this.iterateDeveloper(innerCount, root, value.getDevelopers());
        this.iterateContributor(innerCount, root, value.getContributors());
        this.iterateMailingList(innerCount, root, value.getMailingLists());
        this.updatePrerequisites(value.getPrerequisites(), innerCount, root);
        this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
        this.updateScm(value.getScm(), innerCount, root);
        this.updateIssueManagement(value.getIssueManagement(), innerCount, root);
        this.updateCiManagement(value.getCiManagement(), innerCount, root);
        this.updateDistributionManagement(value.getDistributionManagement(), innerCount, root);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        this.updateDependencyManagement(value.getDependencyManagement(), innerCount, root);
        this.iterateDependency(innerCount, root, value.getDependencies());
        this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.updateBuild(value.getBuild(), innerCount, root);
        this.updateReporting(value.getReporting(), innerCount, root);
        this.iterateProfile(innerCount, root, value.getProfiles());
    }

    private void updateNotifier(Notifier value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "type", value.getType(), "mail", false);
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnError", value.isSendOnError() ? null : String.valueOf(value.isSendOnError()), "true", false);
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnFailure", value.isSendOnFailure() ? null : String.valueOf(value.isSendOnFailure()), "true", false);
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnSuccess", value.isSendOnSuccess() ? null : String.valueOf(value.isSendOnSuccess()), "true", false);
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnWarning", value.isSendOnWarning() ? null : String.valueOf(value.isSendOnWarning()), "true", false);
        this.findAndReplaceSimpleElement(innerCount, root, "address", value.getAddress(), null, false);
        this.findAndReplaceProperties(innerCount, root, "configuration", value.getConfiguration());
    }

    private void updateOrganization(Organization value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "organization", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        }
    }

    private void updateParent(Parent value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "parent", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "relativePath", value.getRelativePath(), "../pom.xml", true);
        }
    }

    private void updatePlugin(Plugin value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), "org.apache.maven.plugins", false);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "extensions", !value.isExtensions() ? null : String.valueOf(value.isExtensions()), "false", false);
        this.iteratePluginExecution(innerCount, root, value.getExecutions());
        this.iterateDependency(innerCount, root, value.getDependencies());
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null, false);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    private void updatePluginExecution(PluginExecution value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), "default", false);
        this.findAndReplaceSimpleElement(innerCount, root, "phase", value.getPhase(), null, false);
        this.findAndReplaceSimpleLists(innerCount, root, value.getGoals(), "goals", "goal");
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null, false);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    private void updatePluginManagement(PluginManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "pluginManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    private void updatePrerequisites(Prerequisites value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "prerequisites", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "maven", value.getMaven(), "2.0", false);
        }
    }

    private void updateProfile(Profile value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null, false);
        this.updateActivation(value.getActivation(), innerCount, root);
        this.updateBuildBase(value.getBuild(), innerCount, root);
        this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
        this.updateDistributionManagement(value.getDistributionManagement(), innerCount, root);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        this.updateDependencyManagement(value.getDependencyManagement(), innerCount, root);
        this.iterateDependency(innerCount, root, value.getDependencies());
        this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.updateReporting(value.getReporting(), innerCount, root);
    }

    private void updateRelocation(Relocation value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "relocation", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "message", value.getMessage(), null, false);
        }
    }

    private void updateReporting(Reporting value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "reporting", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "excludeDefaults", !value.isExcludeDefaults() ? null : String.valueOf(value.isExcludeDefaults()), "false", false);
            this.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", value.getOutputDirectory(), null, false);
            this.iterateReportPlugin(innerCount, root, value.getPlugins());
        }
    }

    private void updateReportPlugin(ReportPlugin value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), "org.apache.maven.plugins", false);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null, false);
        this.iterateReportSet(innerCount, root, value.getReportSets());
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null, false);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    private void updateReportSet(ReportSet value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), "default", false);
        this.findAndReplaceSimpleLists(innerCount, root, value.getReports(), "reports", "report");
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null, false);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    private void updateRepository(Repository value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.updateRepositoryPolicy(value.getReleases(), "releases", innerCount, root);
        this.updateRepositoryPolicy(value.getSnapshots(), "snapshots", innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default", false);
    }

    private void updateRepositoryPolicy(RepositoryPolicy value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "enabled", value.isEnabled() ? null : String.valueOf(value.isEnabled()), "true", false);
            this.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", value.getUpdatePolicy(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", value.getChecksumPolicy(), null, false);
        }
    }

    private void updateResource(Resource value, Counter counter, Element root) {
        Counter innerCount = counter.newNextDepthLevelCounter();
        this.findAndReplaceSimpleElement(innerCount, root, "targetPath", value.getTargetPath(), null, false);
        this.findAndReplaceSimpleElement(innerCount, root, "filtering", !value.isFiltering() ? null : String.valueOf(value.isFiltering()), "false", false);
        this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null, false);
        this.findAndReplaceSimpleLists(innerCount, root, value.getIncludes(), "includes", "include");
        this.findAndReplaceSimpleLists(innerCount, root, value.getExcludes(), "excludes", "exclude");
    }

    private void updateScm(Scm value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "scm", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceSimpleElement(innerCount, root, "connection", value.getConnection(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "developerConnection", value.getDeveloperConnection(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "tag", value.getTag(), "HEAD", false);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
            this.findAndReplaceAttribute(root, "child.scm.connection.inherit.append.path", value.getChildScmConnectionInheritAppendPath(), "true");
            this.findAndReplaceAttribute(root, "child.scm.developerConnection.inherit.append.path", value.getChildScmUrlInheritAppendPath(), "true");
            this.findAndReplaceAttribute(root, "child.scm.url.inherit.append.path", value.getChildScmDeveloperConnectionInheritAppendPath(), "true");
        }
    }

    private void findAndReplaceAttribute(Element root, String name, String value, String defaultValue) {
        if (value == null || value.equals(defaultValue)) {
            root.removeAttribute(name);
        } else {
            root.setAttribute(name, value);
        }
    }

    private void updateSite(Site value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "site", shouldExist);
        if (shouldExist) {
            Counter innerCount = counter.newNextDepthLevelCounter();
            this.findAndReplaceAttribute(root, "child.site.url.inherit.append.path", value.getChildSiteUrlInheritAppendPath(), "true");
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null, false);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null, false);
        }
    }

    private static final class Counter {
        private int currentIndex;
        private final int level;

        private Counter(int depthLevel) {
            this.level = depthLevel;
        }

        public static Counter initialCounter() {
            return new Counter(0);
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        public int getDepth() {
            return this.level;
        }

        public void increaseCount() {
            ++this.currentIndex;
        }

        public Counter newNextDepthLevelCounter() {
            return new Counter(this.getDepth() + 1);
        }
    }
}

