/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.SourceReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ParameterType {
    private final String name;
    private final List<String> regularExpressions;
    private final Boolean preferForRegularExpressionMatch;
    private final Boolean useForSnippets;
    private final String id;
    private final SourceReference sourceReference;

    public ParameterType(String name, List<String> regularExpressions, Boolean preferForRegularExpressionMatch, Boolean useForSnippets, String id, SourceReference sourceReference) {
        this.name = Objects.requireNonNull(name, "ParameterType.name cannot be null");
        this.regularExpressions = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(regularExpressions, "ParameterType.regularExpressions cannot be null")));
        this.preferForRegularExpressionMatch = Objects.requireNonNull(preferForRegularExpressionMatch, "ParameterType.preferForRegularExpressionMatch cannot be null");
        this.useForSnippets = Objects.requireNonNull(useForSnippets, "ParameterType.useForSnippets cannot be null");
        this.id = Objects.requireNonNull(id, "ParameterType.id cannot be null");
        this.sourceReference = sourceReference;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRegularExpressions() {
        return this.regularExpressions;
    }

    public Boolean getPreferForRegularExpressionMatch() {
        return this.preferForRegularExpressionMatch;
    }

    public Boolean getUseForSnippets() {
        return this.useForSnippets;
    }

    public String getId() {
        return this.id;
    }

    public Optional<SourceReference> getSourceReference() {
        return Optional.ofNullable(this.sourceReference);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterType that = (ParameterType)o;
        return this.name.equals(that.name) && this.regularExpressions.equals(that.regularExpressions) && this.preferForRegularExpressionMatch.equals(that.preferForRegularExpressionMatch) && this.useForSnippets.equals(that.useForSnippets) && this.id.equals(that.id) && Objects.equals(this.sourceReference, that.sourceReference);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.regularExpressions, this.preferForRegularExpressionMatch, this.useForSnippets, this.id, this.sourceReference);
    }

    public String toString() {
        return "ParameterType{name=" + this.name + ", regularExpressions=" + this.regularExpressions + ", preferForRegularExpressionMatch=" + this.preferForRegularExpressionMatch + ", useForSnippets=" + this.useForSnippets + ", id=" + this.id + ", sourceReference=" + this.sourceReference + '}';
    }
}

