/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.services.UserService;
import fr.ird.t3.web.validators.T3BaseFieldValidatorSupport;

public class LoginValidator
extends T3BaseFieldValidatorSupport {
    public void validateWhenNotSkip(Object object) throws ValidationException {
        UserService userService = (UserService)this.getFieldValue("userService", object);
        String login = (String)this.getFieldValue("login", object);
        String password = (String)this.getFieldValue("password", object);
        if (this.log.isInfoEnabled()) {
            this.log.info("try to log for user " + login, new String[0]);
        }
        try {
            T3User user = userService.getUserByLogin(login);
            if (user == null) {
                this.addFieldError("login", this._("t3.error.login.unknown", new Object[0]));
                return;
            }
            boolean passwordOk = userService.checkPassword(user, password);
            if (!passwordOk) {
                this.addFieldError("password", this._("t3.error.bad.password", new Object[0]));
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not validate login", (Throwable)e, new String[0]);
            }
            throw new ValidationException("Could not validate login : " + e.getMessage());
        }
    }

    public String getValidatorType() {
        return "login";
    }
}

