/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.io.input;

import fr.ird.t3.actions.T3Action;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.actions.io.input.AnalyzeInputSourceAction;
import fr.ird.t3.actions.io.input.AnalyzeInputSourceConfiguration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.io.input.T3InputProvider;
import fr.ird.t3.web.actions.AbstractRunAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class AnalyzeImportDataAction
extends AbstractRunAction<AnalyzeInputSourceConfiguration, AnalyzeInputSourceAction> {
    private static final long serialVersionUID = 1L;
    protected int nbUnsafeTrips;
    protected int nbSafeTrips;
    protected int nbTripsToReplace;
    protected boolean needReplace;
    protected boolean valid;
    private List<T3InputProvider> inputProviders;

    public AnalyzeImportDataAction() {
        super(AnalyzeInputSourceAction.class);
    }

    public void prepare() throws Exception {
        this.getT3Session().removeTripListModel();
        super.prepare();
        this.inputProviders = Arrays.asList(((AnalyzeInputSourceConfiguration)this.getConfiguration()).getInputProvider());
    }

    public final List<T3InputProvider> getInputProviders() {
        return this.inputProviders;
    }

    public String prepareResult() throws Exception {
        boolean canImport;
        T3ActionContext context = this.getT3ActionContext();
        Set safeTrips = context.getResultAsSet("safeTrips", Trip.class);
        this.nbSafeTrips = safeTrips.size();
        Set unsafeTrips = context.getResultAsSet("unsafeTrips", Trip.class);
        this.nbUnsafeTrips = unsafeTrips.size();
        this.valid = canImport = CollectionUtils.isEmpty((Collection)unsafeTrips) && CollectionUtils.isNotEmpty((Collection)safeTrips);
        Map tripsToReplace = canImport ? context.getResultAsMap("tripsToReplace") : Collections.emptyMap();
        this.nbTripsToReplace = tripsToReplace.size();
        this.needReplace = MapUtils.isNotEmpty((Map)tripsToReplace);
        return "input";
    }

    public int getNbUnsafeTrips() {
        return this.nbUnsafeTrips;
    }

    public int getNbSafeTrips() {
        return this.nbSafeTrips;
    }

    public int getNbTripsToReplace() {
        return this.nbTripsToReplace;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isNeedReplace() {
        return this.needReplace;
    }

    protected Map<String, Object> prepareResumeParameters(AnalyzeInputSourceAction action, Exception error, Date startDate, Date endDate) {
        Map map = super.prepareResumeParameters((T3Action)action, error, startDate, endDate);
        T3ActionContext actionContext = this.getT3ActionContext();
        Set safeTrips = actionContext.getResultAsSet("safeTrips", Trip.class);
        map.put("safeTrips", safeTrips);
        Set unsafeTrips = actionContext.getResultAsSet("unsafeTrips", Trip.class);
        map.put("unsafeTrips", unsafeTrips);
        Map tripsToReplace = actionContext.getResultAsMap("tripsToReplace");
        map.put("tripsToReplace", tripsToReplace);
        map.put("tripDecorator", this.getDecorator(Trip.class));
        map.put("tripDecorator2", this.getDecorator(Trip.class, "withId"));
        return map;
    }
}

