/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.io.output;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ird.t3.actions.T3Action;
import fr.ird.t3.actions.io.output.ExportAction;
import fr.ird.t3.actions.io.output.ExportConfiguration;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.io.output.T3OutputOperation;
import fr.ird.t3.io.output.T3OutputProvider;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractRunAction;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ExportRunAction
extends AbstractRunAction<ExportConfiguration, ExportAction> {
    private static final long serialVersionUID = 1L;
    protected List<T3OutputProvider<?, ?>> outputProviders;
    protected Map<String, String> operations;
    @InjectDecoratedBeans(beanType=Country.class, filterById=true, filterBySingleId=true)
    protected Map<String, String> fleets;
    @InjectDecoratedBeans(beanType=Ocean.class, filterById=true, filterBySingleId=true)
    protected Map<String, String> oceans;

    public ExportRunAction() {
        super(ExportAction.class);
    }

    public void prepare() throws Exception {
        super.prepare();
        ExportConfiguration configuration = (ExportConfiguration)this.getConfiguration();
        this.outputProviders = Lists.newArrayList();
        T3OutputProvider outputProvider = configuration.getOutputProvider();
        this.outputProviders.add(outputProvider);
        this.operations = Maps.newLinkedHashMap();
        for (String operationId : configuration.getOperationIds()) {
            T3OutputOperation operation = outputProvider.getOperation(operationId);
            this.operations.put(operation.getId(), operation.getLibelle(this.getLocale()));
        }
    }

    public final List<T3OutputProvider<?, ?>> getOutputProviders() {
        return this.outputProviders;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Map<String, String> getOperations() {
        return this.operations;
    }

    protected Map<String, Object> prepareResumeParameters(ExportAction action, Exception error, Date startDate, Date endDate) {
        Map map = super.prepareResumeParameters((T3Action)action, error, startDate, endDate);
        map.put("oceans", this.oceans);
        map.put("fleets", this.fleets);
        return map;
    }
}

