/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions;

import com.opensymphony.xwork2.Preparable;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.web.actions.T3ActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;

public abstract class AbstractConfigureAction<C extends T3ActionConfiguration>
extends T3ActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractConfigureAction.class);
    protected transient T3ActionContext<C> t3ActionContext;
    protected transient C configuration;
    protected boolean confirm;
    protected final Class<C> configurationType;

    public AbstractConfigureAction(Class<C> configurationType) {
        this.configurationType = configurationType;
    }

    public final T3ActionContext<C> getT3ActionContext() {
        return this.t3ActionContext;
    }

    public final C getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.getConfigurationFromSession();
            if (this.configuration == null) {
                this.configuration = (T3ActionConfiguration)ObjectUtil.newInstance((Class)this.configurationType, (String[])new String[0]);
            }
        }
        return (C)this.configuration;
    }

    public final boolean isConfigurationInSession() {
        boolean b = this.getConfigurationFromSession() != null;
        return b;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    protected final T3ActionContext<C> prepareActionContext() {
        this.t3ActionContext = this.getServiceFactory().newT3ActionContext(this.getConfiguration(), this.getServiceContext());
        if (log.isInfoEnabled()) {
            log.info((Object)("Created action context " + this.t3ActionContext));
        }
        this.getT3Session().setActionContext(this.t3ActionContext);
        return this.t3ActionContext;
    }

    protected final C getConfigurationFromSession() {
        return (C)((T3ActionConfiguration)this.getActionConfiguration(this.configurationType));
    }

    protected final boolean isConfigurationValid() {
        return this.configuration != null && !this.hasFieldErrors();
    }

    protected final void storeActionConfiguration(C configuration) {
        this.getT3Session().setActionConfiguration(configuration);
    }

    protected final void removeConfigurationFromSession() {
        this.getT3Session().removeActionConfiguration(this.configurationType);
    }

    protected final void removeActionContextFromSession() {
        this.getT3Session().removeActionContext();
    }

    protected void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

