/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import fr.ird.converter.FloatConverter;
import fr.ird.t3.T3Configuration;
import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.T3TopiaRootContextFactory;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.entities.user.T3UserImpl;
import fr.ird.t3.services.DefaultT3ServiceContext;
import fr.ird.t3.services.T3ServiceContext;
import fr.ird.t3.services.T3ServiceFactory;
import fr.ird.t3.services.UserService;
import fr.ird.t3.web.T3ApplicationContext;
import fr.ird.t3.web.T3Session;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.util.converter.ConverterUtil;

public class T3ApplicationListener
implements ServletContextListener {
    protected static final Log log;

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        T3Configuration configuration = new T3Configuration();
        configuration.init();
        T3ApplicationContext applicationContext = new T3ApplicationContext();
        T3ApplicationContext.setT3ApplicationContext((ServletContext)sce.getServletContext(), (T3ApplicationContext)applicationContext);
        applicationContext.setConfiguration(configuration);
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("t3-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        Converter converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        DefaultT3ServiceContext serviceContext = DefaultT3ServiceContext.newContext((Locale)Locale.getDefault(), null, null, (T3Configuration)configuration, (T3ServiceFactory)new T3ServiceFactory());
        this.initInternalDatabase(applicationContext, (T3ServiceContext)serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        ServletContext servletContext = sce.getServletContext();
        T3ApplicationContext applicationContext = T3ApplicationContext.getT3ApplicationContext((ServletContext)servletContext);
        T3ApplicationContext.remove3ApplicationContext((ServletContext)servletContext);
        try {
            TopiaContext rootContext = applicationContext.getInternalRootContext();
            T3EntityHelper.releaseRootContext((TopiaContext)rootContext);
        }
        finally {
            Set t3Sessions = applicationContext.getT3Sessions();
            if (CollectionUtils.isNotEmpty((Collection)t3Sessions)) {
                for (T3Session t3Session : t3Sessions) {
                    applicationContext.destroyT3Session(t3Session);
                }
            }
        }
    }

    protected void initInternalDatabase(T3ApplicationContext applicationContext, T3ServiceContext serviceContext) {
        try {
            boolean schemaNeedUpdate;
            T3Configuration configuration = serviceContext.getApplicationConfiguration();
            T3TopiaRootContextFactory factory = new T3TopiaRootContextFactory();
            TopiaContext internalRootContext = factory.newInternalDb(configuration);
            applicationContext.setInternalRootContext(internalRootContext);
            boolean bl = schemaNeedUpdate = !this.isInternalSchemaCreated(internalRootContext) || configuration.isUpdateSchema();
            if (schemaNeedUpdate) {
                internalRootContext.updateSchema();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("could not start db", e);
        }
        try {
            this.createAdminUser(serviceContext, applicationContext.getInternalRootContext());
        }
        catch (Exception e) {
            throw new IllegalStateException("could not create default admin user", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAdminUser(T3ServiceContext serviceContext, TopiaContext rootContext) throws Exception {
        TopiaContext tx = rootContext.beginTransaction();
        try {
            serviceContext.setInternalTransaction(tx);
            UserService service = (UserService)serviceContext.newService(UserService.class);
            List users = service.getUsers();
            if (CollectionUtils.isEmpty((Collection)users)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No user in database, will create default admin user (password admin).");
                }
                T3UserImpl u = new T3UserImpl();
                u.setLogin("admin");
                u.setPassword("admin");
                u.setAdmin(true);
                service.createUser((T3User)u);
            }
        }
        finally {
            serviceContext.setInternalTransaction(null);
            T3EntityHelper.releaseContext((TopiaContext)tx);
        }
    }

    protected boolean isInternalSchemaCreated(TopiaContext rootContext) throws TopiaException {
        boolean schemaFound = ((TopiaContextImplementor)rootContext).isSchemaExist(T3UserImpl.class);
        return schemaFound;
    }

    static {
        block5: {
            block4: {
                log = LogFactory.getLog(T3ApplicationListener.class);
                try {
                    Class.forName("org.postgresql.Driver");
                }
                catch (ClassNotFoundException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not find pg driver", (Throwable)e);
                }
            }
            try {
                Class.forName("org.h2.Driver");
            }
            catch (ClassNotFoundException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Could not find h2 driver", (Throwable)e);
            }
        }
    }
}

