/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.web.T3Session;
import java.util.Collections;
import java.util.Set;

public class CleanT3SessionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private boolean removeConfiguration = true;
    private Set<String> parameters = Collections.emptySet();

    public void setParameters(String parameters) {
        this.parameters = TextParseUtil.commaDelimitedStringToSet((String)parameters);
    }

    public void setRemoveConfiguration(boolean removeConfiguration) {
        this.removeConfiguration = removeConfiguration;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        T3Session t3Session = T3Session.getT3Session();
        if (t3Session != null) {
            for (String paramName : this.parameters) {
                Object value = t3Session.remove(paramName);
                if (!this.removeConfiguration || !"actionContext".equals(paramName) || !(value instanceof T3ActionContext)) continue;
                T3ActionContext context = (T3ActionContext)value;
                T3ActionConfiguration configuration = context.getConfiguration();
                t3Session.removeActionConfiguration(configuration.getClass());
            }
        }
        return invocation.invoke();
    }
}

