/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.io.output;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ird.t3.actions.io.output.ExportConfiguration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.OceanDAO;
import fr.ird.t3.entities.reference.Vessel;
import fr.ird.t3.entities.reference.VesselDAO;
import fr.ird.t3.entities.type.T3Date;
import fr.ird.t3.entities.user.JdbcConfiguration;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.io.output.T3OutputOperation;
import fr.ird.t3.io.output.T3OutputProvider;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class ExportConfigureAction
extends AbstractConfigureAction<ExportConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExportConfigureAction.class);
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    @InjectDAO(entityType=Vessel.class)
    protected transient VesselDAO vesselDAO;
    @InjectDAO(entityType=Ocean.class)
    protected transient OceanDAO oceanDAO;
    @InjectDAO(entityType=Country.class)
    protected transient CountryDAO countryDAO;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> fleets;
    @InjectDecoratedBeans(beanType=Ocean.class)
    protected Map<String, String> oceans;
    protected List<T3OutputProvider<?, ?>> outputProviders;
    protected Map<String, String> operations;
    protected String databaseId;
    protected Map<String, String> databases;

    public ExportConfigureAction() {
        super(ExportConfiguration.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        TopiaContext internalTx = this.getDatabaseService().beginInternalTransaction();
        try {
            T3User user = this.getT3Session().getT3User();
            user = this.getUserService(internalTx).getUserById(user.getTopiaId());
            Collection dbs = user.getUserOutputDatabase();
            if (CollectionUtils.isEmpty((Collection)dbs)) {
                this.addActionMessage(this._("t3.message.no.output.database.registred", new Object[0]));
                this.databases = Maps.newHashMap();
            } else {
                this.databases = this.sortAndDecorate(dbs);
            }
        }
        finally {
            internalTx.closeContext();
        }
        this.outputProviders = Arrays.asList(this.getT3OutputService().getProviders());
        this.getConfiguration();
        this.operations = Maps.newLinkedHashMap();
        for (T3OutputOperation operation : this.getT3OutputService().getOperations(((ExportConfiguration)this.configuration).getOutputProviderId())) {
            this.operations.put(operation.getId(), operation.getLibelle(this.getLocale()));
        }
        this.injectExcept(new Class[]{InjectDecoratedBeans.class});
        boolean configurationInSession = this.isConfigurationInSession();
        ExportConfiguration conf = (ExportConfiguration)this.getConfiguration();
        if (!configurationInSession) {
            T3Date beginDate = this.tripDAO.getFirstLandingDate();
            conf.setBeginDate(beginDate);
            T3Date endDate = this.tripDAO.getLastLandingDate();
            conf.setEndDate(endDate);
            conf.setFleets(this.sortToList((Collection)this.countryDAO.findAllFleetUsedInTrip()));
            conf.setOceans(this.sortToList((Collection)this.oceanDAO.findAllUsedInActivity()));
        }
        if (CollectionUtils.isEmpty((Collection)conf.getFleets())) {
            this.addFieldError("configuration.fleetId", this._("t3.error.no.fleet", new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)conf.getOceans())) {
            this.addFieldError("configuration.oceanId", this._("t3.error.no.ocean", new Object[0]));
        }
        if (!configurationInSession && !this.hasFieldErrors()) {
            this.getT3Session().setActionConfiguration((Object)conf);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected oceans     : " + conf.getOceanId()));
            log.info((Object)("Selected fleet      : " + conf.getFleetId()));
            log.info((Object)("Selected begin date : " + conf.getBeginDate()));
            log.info((Object)("Selected end date   : " + conf.getEndDate()));
            log.info((Object)("Selected pilot      : " + conf.getOutputProviderId()));
            log.info((Object)("Selected operations : " + conf.getOperationIds()));
        }
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public Map<String, String> getDatabases() {
        return this.databases;
    }

    public List<String> getOperationIds() {
        List operationIds = ((ExportConfiguration)this.getConfiguration()).getOperationIds();
        if (operationIds == null) {
            operationIds = Lists.newArrayList();
            this.setOperationIds(operationIds);
        }
        return operationIds;
    }

    public void setOperationIds(List<String> operationIds) {
        ((ExportConfiguration)this.getConfiguration()).setOperationIds(operationIds);
    }

    public void validate() {
        T3Date endDate;
        T3Date beginDate;
        if (log.isInfoEnabled()) {
            log.info((Object)"Will validate...");
        }
        ExportConfiguration conf = (ExportConfiguration)this.getConfiguration();
        boolean jdbcError = false;
        if (StringUtils.isEmpty((CharSequence)conf.getOutputProviderId())) {
            this.addFieldError("configuration.outputProviderId", this._("t3.error.no.output.pilot.selected", new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)conf.getOperationIds())) {
            this.addFieldError("operationIds", this._("t3.error.no.operation.selected", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)conf.getOceanId())) {
            this.addFieldError("configuration.oceanId", this._("t3.error.no.ocean.selected", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)conf.getFleetId())) {
            this.addFieldError("configuration.fleetId", this._("t3.error.no.fleet.selected", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)conf.getUrl())) {
            this.addFieldError("configuration.url", this._("t3.error.required.url", new Object[0]));
            jdbcError = true;
        }
        if (StringUtils.isEmpty((CharSequence)conf.getLogin())) {
            this.addFieldError("configuration.login", this._("t3.error.required.login", new Object[0]));
            jdbcError = true;
        }
        if (StringUtils.isEmpty((CharSequence)conf.getPassword())) {
            this.addFieldError("configuration.password", this._("t3.error.required.password", new Object[0]));
            jdbcError = true;
        }
        if ((beginDate = conf.getBeginDate()) == null) {
            this.addFieldError("configuration.beginDate", this._("t3.error.no.beginDate.selected", new Object[0]));
        }
        if ((endDate = conf.getEndDate()) == null) {
            this.addFieldError("configuration.endDate", this._("t3.error.no.endDate.selected", new Object[0]));
        }
        if (beginDate != null && endDate != null && (beginDate.equals((Object)endDate) || beginDate.after(endDate))) {
            this.addFieldError("configuration.beginDate", this._("t3.error.beginDate.equals.or.after.endDate", new Object[0]));
        }
        if (!jdbcError) {
            try {
                this.getDatabaseService().checkJDBCConnection((JdbcConfiguration)conf.getOutputConfiguration());
            }
            catch (Exception e) {
                this.addFieldError("configuration.url", this._("t3.error.invalid.jdbc.connexion", new Object[]{e.getMessage()}));
            }
        }
    }

    public final String execute() throws Exception {
        String id = ((ExportConfiguration)this.getConfiguration()).getOutputProviderId();
        T3OutputProvider t3OutputProvider = this.getT3OutputService().getProvider(id);
        ((ExportConfiguration)this.getConfiguration()).setOutputProvider(t3OutputProvider);
        this.prepareActionContext();
        return "success";
    }

    public List<T3OutputProvider<?, ?>> getOutputProviders() {
        return this.outputProviders;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Map<String, String> getOperations() {
        return this.operations;
    }
}

