/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.data.level2;

import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.data.level2.Level2Configuration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.OceanDAO;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.entities.reference.SpeciesDAO;
import fr.ird.t3.entities.reference.zone.ZoneStratumAwareMeta;
import fr.ird.t3.entities.reference.zone.ZoneVersion;
import fr.ird.t3.entities.type.T3Date;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigureLevel2Step1Action
extends AbstractConfigureAction<Level2Configuration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureLevel2Step1Action.class);
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    @InjectDAO(entityType=Species.class)
    protected transient SpeciesDAO specieDAO;
    @InjectDAO(entityType=Ocean.class)
    protected transient OceanDAO oceanDAO;
    @InjectDAO(entityType=Country.class)
    protected transient CountryDAO countryDAO;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> catchFleets;
    @InjectDecoratedBeans(beanType=ZoneStratumAwareMeta.class)
    protected Map<String, String> zoneTypes;
    @InjectDecoratedBeans(beanType=ZoneVersion.class)
    protected Map<String, String> zoneVersions;
    @InjectDecoratedBeans(beanType=Species.class)
    protected Map<String, String> species;
    @InjectDecoratedBeans(beanType=Ocean.class)
    protected Map<String, String> oceans;
    protected final Map<String, String> timeSteps = this.createTimeSteps();
    protected boolean validating;
    protected boolean missingDatas;

    public ConfigureLevel2Step1Action() {
        super(Level2Configuration.class);
    }

    public void prepare() throws Exception {
        boolean configurationInSession = this.isConfigurationInSession();
        Level2Configuration conf = (Level2Configuration)this.getConfiguration();
        this.injectExcept(new Class[]{InjectDecoratedBeans.class});
        this.missingDatas = false;
        conf.setValidStep1(false);
        conf.setValidStep2(false);
        if (!configurationInSession) {
            conf.setCatchFleets(this.sortToList((Collection)this.countryDAO.findAllFleetUsedInCatch()));
            conf.setOceans(this.sortToList((Collection)this.oceanDAO.findAllUsedInActivity()));
            conf.setSpecies(this.sortToList((Collection)this.specieDAO.findAllSpeciesUsedInCatch()));
            conf.setZoneTypes(this.sortToList((Collection)this.getZoneStratumService().getZoneStratumAwareMetas()));
        }
        if (StringUtils.isNotEmpty((CharSequence)conf.getZoneTypeId())) {
            ZoneStratumAwareMeta zoneType = this.getZoneStratumService().getZoneMetaById(conf.getZoneTypeId());
            conf.setZoneVersions(this.sortToList((Collection)zoneType.getAllZoneVersions(this.getTransaction())));
            if (CollectionUtils.isEmpty((Collection)conf.getZoneVersions())) {
                this.addFieldError("configuration.zoneVersionId", this._("t3.error.no.zoneVersion.found", new Object[0]));
                this.missingDatas = true;
            }
        }
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
        if (CollectionUtils.isEmpty((Collection)conf.getCatchFleets())) {
            this.addFieldError("configuration.catchFleetId", this._("t3.error.no.catch.fleet.found", new Object[0]));
            this.missingDatas = true;
        }
        if (CollectionUtils.isEmpty((Collection)conf.getOceans())) {
            this.addFieldError("configuration.oceanId", this._("t3.error.no.ocean.found", new Object[0]));
            this.missingDatas = true;
        }
        if (CollectionUtils.isEmpty((Collection)conf.getSpecies())) {
            this.addFieldError("configuration.speciesIds", this._("t3.error.no.species.found", new Object[0]));
            this.missingDatas = true;
        }
        if (CollectionUtils.isEmpty((Collection)conf.getZoneTypes())) {
            this.addFieldError("configuration.zoneTypeId", this._("t3.error.no.zoneType.found", new Object[0]));
            this.missingDatas = true;
        }
        if (!this.isValidating() && !configurationInSession) {
            for (Species aSpecies : conf.getSpecies()) {
                int specieCode = aSpecies.getCode();
                if (specieCode <= 0 || specieCode >= 4) continue;
                conf.getSpeciesIds().add(aSpecies.getTopiaId());
            }
            conf.setTimeStep(3);
            T3Date firstLandingDate = this.tripDAO.getFirstLandingDate();
            T3Date lastLandingDate = this.tripDAO.getLastLandingDate();
            conf.setMinDate(firstLandingDate);
            conf.setBeginDate(firstLandingDate);
            conf.setMaxDate(lastLandingDate);
            conf.setEndDate(lastLandingDate);
            this.getT3Session().setActionConfiguration((Object)conf);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected species              : " + conf.getSpeciesIds()));
            log.info((Object)("Selected catch fleet country  : " + conf.getCatchFleetId()));
            log.info((Object)("Selected ocean                : " + conf.getOceanId()));
            log.info((Object)("Selected begin date           : " + conf.getBeginDate()));
            log.info((Object)("Selected end date             : " + conf.getEndDate()));
            log.info((Object)("Selected time step            : " + conf.getTimeStep()));
            log.info((Object)("Selected zone type            : " + conf.getZoneTypeId()));
            log.info((Object)("Selected zone version         : " + conf.getZoneVersionId()));
        }
    }

    public void validate() {
        T3Date endDate;
        T3Date beginDate;
        Level2Configuration config = (Level2Configuration)this.getConfiguration();
        if (StringUtils.isEmpty((CharSequence)config.getOceanId())) {
            this.addFieldError("configuration.oceanId", this._("t3.error.no.ocean.selected", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)config.getZoneTypeId())) {
            this.addFieldError("configuration.zoneTypeId", this._("t3.error.no.zoneType.selected", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)config.getZoneVersionId())) {
            this.addFieldError("zoneVersionId", this._("t3.error.no.zoneVersion.selected", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)config.getCatchFleetId())) {
            this.addFieldError("configuration.catchFleetId", this._("t3.error.no.catch.fleet.selected", new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)config.getSpeciesIds())) {
            this.addFieldError("configuration.specieId", this._("t3.error.no.species.selected", new Object[0]));
        }
        if ((beginDate = config.getBeginDate()) == null) {
            this.addFieldError("configuration.beginDate", this._("t3.error.no.beginDate.selected", new Object[0]));
        }
        if ((endDate = config.getEndDate()) == null) {
            this.addFieldError("configuration.endDate", this._("t3.error.no.endDate.selected", new Object[0]));
        }
        if (beginDate != null && endDate != null) {
            if (beginDate.equals((Object)endDate) || beginDate.after(endDate)) {
                this.addFieldError("configuration.beginDate", this._("t3.error.beginDate.equals.or.after.endDate", new Object[0]));
            } else {
                int timeStep = config.getTimeStep();
                if (!beginDate.isModuloMonths(endDate, timeStep)) {
                    this.addFieldError("configuration.endDate", this._("t3.error.endDate.no.modulo.timestep", new Object[0]));
                }
            }
        }
    }

    public String execute() throws Exception {
        Level2Configuration config = (Level2Configuration)this.getConfiguration();
        config.setValidStep1(true);
        this.storeActionConfiguration((T3ActionConfiguration)config);
        return "success";
    }

    public String getZoneVersionId() {
        return ((Level2Configuration)this.getConfiguration()).getZoneVersionId();
    }

    public void setZoneVersionId(String zoneVersionId) {
        ((Level2Configuration)this.getConfiguration()).setZoneVersionId(zoneVersionId);
    }

    public Map<String, String> getCatchFleets() {
        return this.catchFleets;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Map<String, String> getZoneTypes() {
        return this.zoneTypes;
    }

    public Map<String, String> getZoneVersions() {
        return this.zoneVersions;
    }

    public Map<String, String> getSpecies() {
        return this.species;
    }

    public Map<String, String> getTimeSteps() {
        return this.timeSteps;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isMissingDatas() {
        return this.missingDatas;
    }

    public void setMissingDatas(boolean missingDatas) {
        this.missingDatas = missingDatas;
    }
}

