/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.reference;

import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.entities.reference.SpeciesLengthStep;
import fr.ird.t3.entities.reference.SpeciesLengthStepDAO;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.tools.db.reference.AbstractReferenceImporter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class SpeciesLengthStepImporter
extends AbstractReferenceImporter<SpeciesLengthStep> {
    private static final Log log = LogFactory.getLog(SpeciesLengthStepImporter.class);
    @InjectDAO(entityType=SpeciesLengthStep.class)
    protected SpeciesLengthStepDAO dao;
    @InjectFromDAO(entityType=Ocean.class)
    protected List<Ocean> oceans;
    @InjectFromDAO(entityType=Species.class)
    protected List<Species> species;
    protected Map<Integer, Ocean> oceanByCode;
    protected Map<Integer, Species> specieByCode;

    @Override
    protected void before() throws TopiaException {
        if (CollectionUtils.isEmpty(this.oceans)) {
            throw new IllegalStateException("No ocean found in db.");
        }
        if (CollectionUtils.isEmpty(this.species)) {
            throw new IllegalStateException("No species found in db.");
        }
        long nb = this.dao.count();
        if (nb > 0L) {
            throw new IllegalStateException("Some SpeciesLengthStep found in db.");
        }
        this.oceanByCode = T3EntityHelper.splitBycode(this.oceans);
        this.specieByCode = T3EntityHelper.splitBycode(this.species);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SpeciesLengthStep> loadFile(File inputFile) throws TopiaException, IOException {
        ArrayList<SpeciesLengthStep> result = new ArrayList<SpeciesLengthStep>();
        try (LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] cells;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Incoming line : " + line));
                }
                if (line.startsWith(",,") || line.startsWith("OCEAN")) continue;
                int lineNumber = reader.getLineNumber();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("At Line [" + lineNumber + "] Data line to treat : " + line));
                }
                if ((cells = line.split(",")).length != 103) {
                    throw new IllegalStateException("At line [" + lineNumber + "], data line must have 103 cells but had here " + cells.length);
                }
                this.loadLine(result, lineNumber, cells);
            }
        }
        return result;
    }

    protected void loadLine(List<SpeciesLengthStep> result, int lineNumber, String[] cells) throws TopiaException {
        int oceanCode = this.convertToInt(cells, lineNumber, 0);
        Ocean ocean = this.getOcean(this.oceanByCode, oceanCode, lineNumber);
        int specieCode = this.convertToInt(cells, lineNumber, 1);
        Species species = this.getSpecie(this.specieByCode, specieCode, lineNumber);
        int ld1Class = this.convertToInt(cells, lineNumber, 2);
        int totalRatio = 0;
        int j = cells.length;
        for (int i = 3; i < j; ++i) {
            int ratio = this.convertToIntTenTimes(cells, lineNumber, i);
            if (ratio <= 0) continue;
            int lfClass = 20 + 2 * (i - 3);
            totalRatio += ratio;
            SpeciesLengthStep speciesLengthStep = (SpeciesLengthStep)this.dao.create(new Object[]{"ocean", ocean, "species", species, "ld1Class", ld1Class, "lfClass", lfClass, "ratio", Float.valueOf((float)ratio / 10.0f)});
            result.add(speciesLengthStep);
        }
        if (totalRatio == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("At line [" + lineNumber + "], [species " + species.getLibelle() + "], distribution of ld1 class " + ld1Class + " is null."));
            }
        } else if (totalRatio != 1000 && log.isWarnEnabled()) {
            log.warn((Object)("At line [" + lineNumber + "], [species " + species.getLibelle() + "], distribution of ld1 class " + ld1Class + " sum not to 1000 but to " + totalRatio));
        }
    }
}

