/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.reference;

import fr.ird.t3.T3ServiceFactory;
import fr.ird.t3.entities.ReferenceEntityMap;
import fr.ird.t3.entities.T3DAOHelper;
import fr.ird.t3.entities.T3EntityEnum;
import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.T3ScriptHelper;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.OceanDAO;
import fr.ird.t3.entities.reference.SchoolType;
import fr.ird.t3.entities.reference.SchoolTypeDAO;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.entities.reference.SpeciesDAO;
import fr.ird.t3.entities.reference.T3ReferenceEntity;
import fr.ird.t3.entities.reference.VesselSimpleType;
import fr.ird.t3.entities.reference.VesselSimpleTypeDAO;
import fr.ird.t3.entities.reference.VesselSimpleTypeImpl;
import fr.ird.t3.entities.reference.VesselType;
import fr.ird.t3.entities.reference.VesselTypeDAO;
import fr.ird.t3.entities.reference.WeightCategoryTreatmentDAO;
import fr.ird.t3.io.input.access.RemoveProxyEntityVisitor;
import fr.ird.t3.io.input.access.T3AccessDataSource;
import fr.ird.t3.io.input.access.T3AccessHitModel;
import fr.ird.t3.io.input.access.T3MSAccessHelper;
import fr.ird.t3.io.input.access.T3ReferentielEntityVisitor;
import fr.ird.t3.io.input.avdth.v33.T3AccessEntityMetaProviderAvdth33;
import fr.ird.t3.tools.db.reference.LengthWeightConversionImporter;
import fr.ird.t3.tools.db.reference.RF1SpecieForFleetImporter;
import fr.ird.t3.tools.db.reference.SetDurationImporter;
import fr.ird.t3.tools.db.reference.SpeciesLengthStepImporter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class T3ReferenceImporter {
    private static final Log log = LogFactory.getLog(T3ReferenceImporter.class);
    protected static final List<T3EntityEnum> referencesTypes = Arrays.asList(T3EntityEnum.VesselActivity, T3EntityEnum.VesselSizeCategory, T3EntityEnum.VesselType, T3EntityEnum.Country, T3EntityEnum.Vessel, T3EntityEnum.Species, T3EntityEnum.WeightCategoryLanding, T3EntityEnum.SchoolType, T3EntityEnum.FishingContext, T3EntityEnum.Ocean, T3EntityEnum.Harbour, T3EntityEnum.SampleQuality, T3EntityEnum.SampleType, T3EntityEnum.WeightCategoryLogBook, T3EntityEnum.WellDestiny, T3EntityEnum.WeightCategoryWellPlan);

    public void execute(T3ServiceFactory serviceFactory, File inputFile, File lengthWeightConversionfile, File specieLengthStepFile, File setDurationpFile, File rF1SpecieForFleetFile, File outputFile, TopiaContext tx) throws Exception {
        ReferenceEntityMap universe = new ReferenceEntityMap();
        this.loadInputDatabase(inputFile, universe);
        T3ReferenceImporter.injectVesselSimpleTypes(universe);
        this.saveDatabase(tx, universe);
        this.attachNewReferences(tx);
        new LengthWeightConversionImporter().execute(serviceFactory, lengthWeightConversionfile, tx);
        new SpeciesLengthStepImporter().execute(serviceFactory, specieLengthStepFile, tx);
        new SetDurationImporter().execute(serviceFactory, setDurationpFile, tx);
        new RF1SpecieForFleetImporter().execute(serviceFactory, rF1SpecieForFleetFile, tx);
        T3ScriptHelper.exportDatabase((TopiaContext)tx, (File)outputFile);
    }

    public static void injectVesselSimpleTypes(ReferenceEntityMap universe) {
        VesselSimpleTypeImpl type = new VesselSimpleTypeImpl();
        type.setCode(1);
        type.setLibelle("Senneur");
        universe.addEntity((TopiaEntity)type);
        type = new VesselSimpleTypeImpl();
        type.setCode(2);
        type.setLibelle("Canneur");
        universe.addEntity((TopiaEntity)type);
        type = new VesselSimpleTypeImpl();
        type.setCode(3);
        type.setLibelle("Palangrier");
        universe.addEntity((TopiaEntity)type);
        type = new VesselSimpleTypeImpl();
        type.setCode(4);
        type.setLibelle("Autre");
        universe.addEntity((TopiaEntity)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferenceEntityMap loadInputDatabase(File inputFile, ReferenceEntityMap result) throws Exception {
        T3AccessDataSource inputSource = new T3AccessDataSource(inputFile, T3AccessEntityMetaProviderAvdth33.class);
        final HashSet<String> t3DataTypes = new HashSet<String>();
        for (Class t3DataType : T3EntityHelper.getT3ImportableDataTypes()) {
            t3DataTypes.add(t3DataType.getSimpleName());
        }
        T3AccessHitModel hitModel = new T3AccessHitModel();
        hitModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (log.isInfoEnabled()) {
                    if (t3DataTypes.contains(propertyName)) {
                        log.info((Object)("Detected data entity " + propertyName + " with " + evt.getNewValue() + " entries"));
                    } else {
                        log.info((Object)("Detected ref  entity " + propertyName + " with " + evt.getNewValue() + " entries"));
                    }
                }
            }
        });
        boolean safe = inputSource.analyzeDb(hitModel);
        if (!safe) {
            throw new IllegalStateException("Input database [" + inputFile + "] is not valid");
        }
        T3ReferentielEntityVisitor visitor = new T3ReferentielEntityVisitor(inputSource, result);
        try {
            for (T3EntityEnum type : referencesTypes) {
                T3MSAccessHelper.loadReferentiel((T3ReferentielEntityVisitor)visitor, (T3AccessDataSource)inputSource, (ReferenceEntityMap)result, (T3EntityEnum)type, (boolean)true);
            }
        }
        finally {
            visitor.clear();
        }
        RemoveProxyEntityVisitor removeVisitor = new RemoveProxyEntityVisitor();
        try {
            for (T3EntityEnum type : referencesTypes) {
                List entities = (List)result.get((Object)type);
                entities = T3MSAccessHelper.removeProxies((RemoveProxyEntityVisitor)removeVisitor, (List)entities);
                result.put((Object)type, (Object)entities);
            }
        }
        finally {
            removeVisitor.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDatabase(TopiaContext rootTx, ReferenceEntityMap universe) throws TopiaException {
        TopiaContext tx = rootTx.beginTransaction();
        try {
            for (T3EntityEnum type : referencesTypes) {
                List list = (List)universe.get((Object)type);
                this.saveEntities(type, tx, list);
            }
            tx.commitTransaction();
        }
        catch (TopiaException e) {
            tx.rollbackTransaction();
        }
        finally {
            tx.closeContext();
        }
    }

    protected static void attachVesselSimpleType(Map<Integer, VesselSimpleType> vesselSimpleTypes, Map<Integer, VesselType> vesselTypes, int vesselSimpleTypeCode, Collection<Integer> vesselTypeCodes) {
        VesselSimpleType vesselSimpleType = vesselSimpleTypes.get(vesselSimpleTypeCode);
        for (int code : vesselTypeCodes) {
            VesselType vesselType = vesselTypes.get(code);
            vesselType.setVesselSimpleType(vesselSimpleType);
            vesselTypes.remove(code);
        }
        vesselSimpleTypes.remove(vesselSimpleTypeCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachNewReferences(TopiaContext rootTx) throws TopiaException {
        TopiaContext tx = rootTx.beginTransaction();
        try {
            T3ReferenceImporter.attachVesselSimpleTypes(tx);
            this.fillWeightCategoryTreatment(tx);
            this.addSpecieMeasuredRatio(tx);
            tx.commitTransaction();
        }
        catch (TopiaException e) {
            tx.rollbackTransaction();
        }
        finally {
            tx.closeContext();
        }
    }

    public static void attachVesselSimpleTypes(TopiaContext tx) throws TopiaException {
        VesselSimpleTypeDAO vesselSimpleTypeDAO = T3DAOHelper.getVesselSimpleTypeDAO((TopiaContext)tx);
        VesselTypeDAO vesselTypeDAO = T3DAOHelper.getVesselTypeDAO((TopiaContext)tx);
        Map vesselSimpleTypesByCode = T3EntityHelper.splitBycode((Collection)vesselSimpleTypeDAO.findAll());
        Map vesselTypesByCode = T3EntityHelper.splitBycode((Collection)vesselTypeDAO.findAll());
        T3ReferenceImporter.attachVesselSimpleType(vesselSimpleTypesByCode, vesselTypesByCode, 1, Arrays.asList(3, 4, 5, 6));
        T3ReferenceImporter.attachVesselSimpleType(vesselSimpleTypesByCode, vesselTypesByCode, 2, Arrays.asList(1, 2));
        T3ReferenceImporter.attachVesselSimpleType(vesselSimpleTypesByCode, vesselTypesByCode, 3, Arrays.asList(7));
        T3ReferenceImporter.attachVesselSimpleType(vesselSimpleTypesByCode, vesselTypesByCode, 4, new ArrayList<Integer>(vesselTypesByCode.keySet()));
    }

    protected void addSpecieMeasuredRatio(TopiaContext tx) throws TopiaException {
        SpeciesDAO specieDAO = T3DAOHelper.getSpeciesDAO((TopiaContext)tx);
        List species = specieDAO.findAll();
        for (Species specy : species) {
            float measuredRatio;
            int code = specy.getCode();
            switch (code) {
                case 2: 
                case 5: 
                case 6: {
                    measuredRatio = 0.1f;
                    break;
                }
                default: {
                    measuredRatio = 1.0f;
                }
            }
            specy.setMeasuredRatio(Float.valueOf(measuredRatio));
            specieDAO.update((TopiaEntity)specy);
        }
    }

    protected void fillWeightCategoryTreatment(TopiaContext tx) throws TopiaException {
        OceanDAO oceanDAO = T3DAOHelper.getOceanDAO((TopiaContext)tx);
        SchoolTypeDAO schoolTypeDAO = T3DAOHelper.getSchoolTypeDAO((TopiaContext)tx);
        SchoolType schoolTypeBO = schoolTypeDAO.findByCode(1);
        SchoolType schoolTypeBL = schoolTypeDAO.findByCode(2);
        Ocean oceanOA = oceanDAO.findByCode(1);
        Ocean oceanOI = oceanDAO.findByCode(2);
        WeightCategoryTreatmentDAO weightCategoryTreatmentDAO = T3DAOHelper.getWeightCategoryTreatmentDAO((TopiaContext)tx);
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOA, "schoolType", schoolTypeBO, "min", 0, "max", 10, "libelle", "-10 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOA, "schoolType", schoolTypeBO, "min", 10, "max", null, "libelle", "+10 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOA, "schoolType", schoolTypeBO, "min", null, "max", null, "libelle", "Ind\u00e9fini"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOA, "schoolType", schoolTypeBL, "min", 0, "max", 10, "libelle", "-10 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOA, "schoolType", schoolTypeBL, "min", 10, "max", 30, "libelle", "10-30 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOA, "schoolType", schoolTypeBL, "min", 30, "max", null, "libelle", "+30 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOA, "schoolType", schoolTypeBL, "min", null, "max", null, "libelle", "Ind\u00e9fini"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOI, "schoolType", schoolTypeBO, "min", 0, "max", 10, "libelle", "-10 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOI, "schoolType", schoolTypeBO, "min", 10, "max", null, "libelle", "+10 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOI, "schoolType", schoolTypeBO, "min", null, "max", null, "libelle", "Ind\u00e9fini"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOI, "schoolType", schoolTypeBL, "min", 0, "max", 10, "libelle", "-10 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOI, "schoolType", schoolTypeBL, "min", 10, "max", null, "libelle", "+10 kg"});
        weightCategoryTreatmentDAO.create(new Object[]{"ocean", oceanOI, "schoolType", schoolTypeBL, "min", null, "max", null, "libelle", "Ind\u00e9fini"});
    }

    protected <E extends T3ReferenceEntity> void saveEntities(T3EntityEnum constant, TopiaContext tx, List<E> entities) throws TopiaException {
        Class contract = constant.getContract();
        TopiaDAO dao = T3DAOHelper.getDAO((TopiaContext)tx, (Class)contract);
        for (T3ReferenceEntity entity : entities) {
            T3ReferenceEntity e = (T3ReferenceEntity)dao.create((TopiaEntity)entity);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Will save entity " + e));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Created entity " + constant + " with " + entities.size() + " entries"));
        }
    }
}

