/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import fr.ird.observe.maven.plugins.toolbox.MismatchMethodParameterNameException;
import fr.ird.observe.maven.plugins.toolbox.MissingClassException;
import fr.ird.observe.maven.plugins.toolbox.MissingMethodException;
import fr.ird.observe.maven.plugins.toolbox.ToolboxMojoSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Mojo(name="generate-webmotion-mapping", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateWebmotionMappingMojo
extends ToolboxMojoSupport {
    @Parameter(property="generateWebmotionMapping.sourceApiPackageName", required=true)
    private String sourceApiPackageName;
    @Parameter(property="generateWebmotionMapping.targetApiPackageName", required=true)
    private String targetApiPackageName;
    @Parameter(property="generateWebmotionMapping.targetApiClassSuffix", required=true)
    private String targetApiClassSuffix;
    @Parameter(property="generateWebmotionMapping.classTypeName")
    private String classTypeName;
    @Parameter(property="generateWebmotionMapping.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="generateWebmotionMapping.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="generateWebmotionMapping.mappingFile", defaultValue="${project.basedir}/src/main/resources/mapping", required=true)
    private File mappingFile;
    private Map<Class<?>, String> translationMap;
    protected Class<? extends Annotation> postRequestAnnotationType;
    protected Class<? extends Annotation> deleteRequestAnnotationType;

    @Override
    protected Path createOutputFile() throws IOException {
        Files.createDirectories(this.mappingFile.getParentFile().toPath(), new FileAttribute[0]);
        return this.mappingFile.toPath();
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() throws Exception {
        if (this.skip) {
            return;
        }
        super.init();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader cl = this.initClassLoader(this.getProject(), null, false, true, false, true, true);
            Thread.currentThread().setContextClassLoader(cl);
            this.postRequestAnnotationType = Class.forName("fr.ird.observe.services.spi.PostRequest");
            this.deleteRequestAnnotationType = Class.forName("fr.ird.observe.services.spi.DeleteRequest");
            Class<?> classType = Class.forName(this.classTypeName);
            LinkedHashMap<Class, String> translationMap = new LinkedHashMap<Class, String>();
            for (Class serviceContract : new Reflections(this.sourceApiPackageName, new Scanner[0]).getSubTypesOf(classType)) {
                String sourceName = serviceContract.getName();
                String sourceSimpleNameName = serviceContract.getSimpleName();
                String sourcePackageNameSuffix = sourceName.substring(this.sourceApiPackageName.length() + 1, sourceName.length() - sourceSimpleNameName.length());
                String targetPackageName = sourcePackageNameSuffix.isEmpty() ? this.targetApiPackageName : this.targetApiPackageName + "." + sourcePackageNameSuffix.substring(0, sourcePackageNameSuffix.length() - 1);
                String targetSimpleName = serviceContract.getSimpleName() + this.targetApiClassSuffix;
                String targetName = targetPackageName + "." + targetSimpleName;
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Found maching class to scan : " + serviceContract.getName() + " \u2192 " + targetName));
                }
                translationMap.put(serviceContract, targetName);
            }
            this.getLog().info((CharSequence)(translationMap.size() + " type(s) detected."));
            this.translationMap = Collections.unmodifiableMap(translationMap);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected boolean checkSkip() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping goal (skip flag is on).");
            return false;
        }
        if (this.translationMap.isEmpty()) {
            this.getLog().warn((CharSequence)"Skipping goal (No matching class).");
            return false;
        }
        return super.checkSkip();
    }

    public void doAction() throws Exception {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("project = " + this.getProject()));
        }
        this.getLog().info((CharSequence)("Generate to " + this.getOutputFile()));
        TreeMap<String, String> rules = new TreeMap<String, String>();
        for (Map.Entry<Class<?>, String> entry : this.translationMap.entrySet()) {
            Class<?> sourceClass = entry.getKey();
            String string = entry.getValue();
            this.generateForClass(sourceClass, string, rules);
        }
        int ruleMax = 2 + rules.keySet().stream().mapToInt(String::length).max().orElse(0);
        this.getLog().info((CharSequence)(rules.size() + " rule(s) detected."));
        StringBuilder rulesBuilder = new StringBuilder();
        for (Map.Entry entry : rules.entrySet()) {
            rulesBuilder.append(StringUtils.rightPad((String)((String)entry.getKey()), (int)ruleMax)).append((String)entry.getValue()).append("\n");
        }
        String rulesStr = rulesBuilder.toString();
        String string = new String(Files.readAllBytes(this.mappingFile.toPath()));
        int indexOf = string.indexOf("# \u2192\u2192\u2192 Generated dynamic mapping");
        String string2 = string.substring(0, indexOf + "# \u2192\u2192\u2192 Generated dynamic mapping".length());
        try (BufferedWriter writer = Files.newBufferedWriter(this.getOutputFile(), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.append(string2).append("\n\n# Do not modify below lines, they are generated at each maven build.\n\n").append(rulesStr);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void generateForClass(Class<?> sourceClass, String targetClassName, Map<String, String> rules) throws MissingMethodException, MismatchMethodParameterNameException, MissingClassException, IOException, ClassNotFoundException {
        Objects.requireNonNull(sourceClass);
        Objects.requireNonNull(targetClassName);
        Objects.requireNonNull(rules);
        Method[] sourceDeclaredMethods = sourceClass.getDeclaredMethods();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Check " + sourceClass.getName()));
        }
        String packagePrefix = "v1." + targetClassName.substring(this.targetApiPackageName.length() + 1) + ".";
        String rulePrefix = " /api/" + packagePrefix.replace("Controller", "").replaceAll("\\.", "/");
        for (Method sourceMethod : sourceDeclaredMethods) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Generate for " + sourceClass.getName() + "#" + sourceMethod.getName()));
            }
            String methods = sourceMethod.isAnnotationPresent(this.postRequestAnnotationType) ? "POST" : (sourceMethod.isAnnotationPresent(this.deleteRequestAnnotationType) ? "DELETE" : "GET");
            String method = packagePrefix + sourceMethod.getName().replace("/", ".");
            String rule = methods + rulePrefix + sourceMethod.getName();
            rules.put(rule, method);
        }
    }
}

