/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.converter.FloatConverter;
import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveApplicationContext;
import fr.ird.observe.ObserveCLAction;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveResourceManager;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.StartServerModeAction;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.UIManager;
import jaxx.runtime.FileChooserUtil;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.application.ApplicationRunner;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.plaf.basic.SpinningCalendarHeaderHandler;
import org.nuiton.converter.ConverterUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.i18n.init.UserI18nInitializer;
import org.nuiton.util.StringUtil;

public abstract class ObserveRunner
extends ApplicationRunner {
    private static Log log = LogFactory.getLog(ObserveRunner.class);
    protected static ObserveResourceManager resourceManager;
    protected static ObserveActionExecutor actionExecutor;
    public final boolean init;

    public static ObserveRunner getRunner() {
        return (ObserveRunner)ApplicationRunner.getRunner();
    }

    public static ObserveResourceManager getResourceManager() {
        if (resourceManager == null) {
            throw new IllegalStateException("No resourceManager initialized");
        }
        return resourceManager;
    }

    public static ObserveActionExecutor getActionExecutor() {
        if (actionExecutor == null) {
            actionExecutor = new ObserveActionExecutor();
        }
        return actionExecutor;
    }

    public abstract String getRunnerName();

    public static boolean isAdmin() {
        return true;
    }

    public ObserveRunner(String ... args) {
        super(args);
        this.init = true;
        this.initOnce();
    }

    public static void runAction(String actionLabel, Runnable action) {
        ObserveRunner.getActionExecutor().addAction(actionLabel, action);
    }

    public static void runAction(String actionLabel, Object invoker, String methodName, Object ... arguments) {
        Runnable action;
        try {
            action = ObserveRunner.getActionExecutor().createRunnable(invoker, methodName, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("could not create action " + actionLabel, e);
        }
        ObserveRunner.runAction(actionLabel, action);
    }

    protected void initOnce() {
        if (!this.init) {
            return;
        }
        this.checkScriptEngineFound();
        I18n.init((I18nInitializer)new DefaultI18nInitializer("observe-i18n"), null);
        resourceManager = new ObserveResourceManager();
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
        }
        DateConverter dateConverter = new DateConverter();
        dateConverter.setUseLocaleFormat(true);
        ConvertUtils.register((Converter)dateConverter, Date.class);
        converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        ObserveRunner.getActionExecutor();
        UIManager.put("CalendarHeaderHandler", SpinningCalendarHeaderHandler.class.getName());
        UIManager.put("SpinningCalendarHeader.arrowsSurroundMonth", true);
        UIManager.put("SpinningCalendarHeader.focusableSpinnerText", true);
    }

    protected void onInit() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.init", (Object[])new Object[]{new Date(), Arrays.toString(this.args)}));
        }
        long t0 = System.nanoTime();
        ObserveConfig config = this.initConfig();
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.config.loaded", (Object[])new Object[]{config.getVersion()}));
        }
        this.initUserDirectories(config);
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.user.directories.loaded", (Object[])new Object[]{config.getDataDirectory()}));
        }
        this.initI18n(config);
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.i18n.loaded", (Object[])new Object[]{config.getLocale().getDisplayLanguage()}));
        }
        this.initUIConfiguration(config);
        this.initContext(config);
        this.detectLocalDataBase(config);
        String time = StringUtil.convertTime((long)t0, (long)System.nanoTime());
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.context.loaded", (Object[])new Object[]{time}));
        }
    }

    protected void onStart() throws Exception {
        Boolean h2ServerMode;
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.start", (Object[])new Object[]{new Date(), Arrays.toString(this.args)}));
        }
        ObserveContext context = ObserveContext.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use context : " + (Object)((Object)context)));
        }
        UIHelper.checkJAXXContextEntries((JAXXContext)context, (JAXXContextEntryDef[])new JAXXContextEntryDef[]{ObserveContext.CONFIG_ENTRY_DEF, ObserveContext.ACTIONS_ENTRY_DEF, ObserveContext.DATA_SERVICE_ENTRY_DEF, ObserveContext.DECORATOR_SERVICE_ENTRY_DEF});
        ObserveConfig config = context.getConfig();
        if (config.containActions(ObserveConfig.Step.AfterInit)) {
            config.doAction(ObserveConfig.Step.AfterInit.ordinal());
            if (log.isInfoEnabled()) {
                log.info((Object)"Operation termin\u00e9es...");
            }
        }
        if (!config.isDisplayMainUI()) {
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"observe.runner.quit.withno.ui", (Object[])new Object[0]));
            }
            ObserveRunner.unlock();
            return;
        }
        ObserveMainUI ui = this.startUI(context, config);
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.ui.loaded", (Object[])new Object[0]));
        }
        if ((h2ServerMode = (Boolean)context.getContextValue(Boolean.class, ObserveCLAction.ActionDefinition.H2_SERVER_MODE.name())) != null && h2ServerMode.booleanValue()) {
            context.removeContextValue(Boolean.class, ObserveCLAction.ActionDefinition.H2_SERVER_MODE.name());
            new StartServerModeAction(ui).run();
            ui.getStatus().setStatus(I18n.t((String)"observe.runner.loaded", (Object[])new Object[]{config.getVersion()}));
            return;
        }
        if (!config.isLoadLocalStorage()) {
            ui.getStatus().setStatus(I18n.t((String)"observe.runner.loaded", (Object[])new Object[]{config.getVersion()}));
            return;
        }
        ObserveRunner.runAction(I18n.t((String)"observe.runner.load.database", (Object[])new Object[0]), (Object)context, "initStorage", new Object[]{config, ui, true});
    }

    protected void onClose(boolean reload) throws Exception {
        if (ObserveServiceHelper.isInit()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will close context...");
            }
            ObserveContext.get().close();
        }
    }

    protected void onShutdown() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("ObServe shutdown at " + new Date()));
        }
        I18n.close();
        ObserveRunner.getActionExecutor().terminatesAndWaits();
        Runtime.getRuntime().halt(0);
    }

    protected void onShutdown(Exception ex) {
        if (log.isErrorEnabled()) {
            log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
        }
        Runtime.getRuntime().halt(1);
    }

    protected void onError(Exception e) {
        ErrorDialogUI.showError((Exception)e);
        if (log.isErrorEnabled()) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected ObserveConfig initConfig() throws Exception {
        ObserveConfig config = new ObserveConfig();
        config.initConfig(resourceManager);
        config.parse(this.args);
        config.installSaveAction();
        return config;
    }

    protected void initUserDirectories(ObserveConfig config) throws IOException {
        File reportDirectory;
        File file;
        File dataDirectory = resourceManager.createDirectory(config, ObserveConfigOption.DATA_DIRECTORY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("user data directory : " + dataDirectory));
        }
        FileChooserUtil.setCurrentDirectory((File)dataDirectory);
        resourceManager.createParentDirectory(config, ObserveConfigOption.DB_DIRECTORY, ObserveConfigOption.INITIAL_DB_DUMP);
        resourceManager.createDirectory(config, ObserveConfigOption.TMP_DIRECTORY);
        FileUtils.deleteDirectory((File)config.getTmpDirectory());
        resourceManager.createDirectory(config, ObserveConfigOption.BACKUP_DIRECTORY);
        File resourcesDirectory = resourceManager.createDirectory(config, ObserveConfigOption.RESOURCES_DIRECTORY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("user resource data directory : " + resourcesDirectory));
        }
        if (!(file = ObserveResourceManager.Resource.ui.getFile(resourcesDirectory)).exists()) {
            String message = I18n.t((String)"observe.runner.copy.default.ui.file", (Object[])new Object[]{file});
            resourceManager.copyResource(ObserveResourceManager.Resource.ui, file, message);
        }
        if (!(file = ObserveResourceManager.Resource.report.getFile(reportDirectory = resourceManager.createDirectory(config, ObserveConfigOption.REPORT_DIRECTORY))).exists()) {
            String message = I18n.t((String)"observe.runner.copy.default.report.file", (Object[])new Object[]{file});
            resourceManager.copyResource(ObserveResourceManager.Resource.report, file, message);
        }
        resourceManager.createDirectory(config, ObserveConfigOption.VALIDATION_REPORT_DIRECTORY);
        File mapdirectory = resourceManager.createDirectory(config, ObserveConfigOption.MAP_DIRECTORY);
        String message = I18n.t((String)"observe.runner.copy.default.map.file", (Object[])new Object[]{mapdirectory});
        resourceManager.unzipToDirectory(ObserveResourceManager.Resource.mapLayers, config, ObserveConfigOption.RESOURCES_DIRECTORY, message);
    }

    protected void detectLocalDataBase(ObserveConfig config) throws IOException {
        boolean hasLocalStorage = ObserveServiceHelper.isLocalStorageExists((IObserveConfig)config);
        config.setLocalStorageExist(hasLocalStorage);
        if (!hasLocalStorage && log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.init.no.local.db.detected", (Object[])new Object[]{config.getLocalDBDirectory()}));
        }
        boolean hasInitialDb = ObserveServiceHelper.isInitialDbExists((IObserveConfig)config);
        config.setInitialDumpExist(hasInitialDb);
        if (!hasInitialDb && log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.init.no.initial.dump.detected", (Object[])new Object[]{config.getInitialDbDump()}));
        }
    }

    protected void initI18n(ObserveConfig config) {
        I18n.close();
        File i18nDirectory = config.getI18nDirectory();
        UserI18nInitializer i18nInitializer = new UserI18nInitializer(i18nDirectory, new DefaultI18nInitializer("observe-i18n")){

            protected void createUserI18nLayout(File directory) throws Exception {
                super.createUserI18nLayout(directory);
                URL resource = ObserveResourceManager.getResource("/META-INF/observe-i18n.csv");
                resourceManager.copyResource(resource, new File(directory, "observe-i18n.csv"), "Copy i18n csv bundle");
            }
        };
        long t00 = System.nanoTime();
        Locale locale = config.getLocale();
        I18n.init((I18nInitializer)i18nInitializer, (Locale)locale);
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n language : " + locale));
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    protected void initUIConfiguration(ObserveConfig config) throws IOException {
        try {
            UIHelper.initNimbusLoookAndFeel();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n.t((String)"observe.warning.nimbus.landf", (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n.t((String)"observe.warning.no.ui", (Object[])new Object[0]));
            }
            config.setCanUseUI(false);
        }
        if (config.isCanUseUI()) {
            this.loadUIConfig(config);
        }
    }

    public void loadUIConfig(ObserveConfig config) {
        File dir = config.getResourcesDirectory();
        File file = ObserveResourceManager.Resource.ui.getFile(dir);
        if (!file.exists()) {
            String message = I18n.t((String)"observe.runner.copy.default.ui.file", (Object[])new Object[]{file});
            try {
                resourceManager.copyResource(ObserveResourceManager.Resource.ui, file, message);
            }
            catch (IOException e) {
                throw new ObserveTechnicalException("could not copy ui configuration: " + file, (Throwable)e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.runner.loading.ui.configuration", (Object[])new Object[]{file}));
        }
        try {
            Properties p = resourceManager.getResource(file);
            UIHelper.loadUIConfig((Properties)p);
        }
        catch (IOException e) {
            throw new ObserveTechnicalException("could not load ui configuration: " + file, (Throwable)e);
        }
    }

    public ObserveContext initContext(ObserveConfig config) throws Exception {
        if (ObserveServiceHelper.isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        ObserveContext instance = new ObserveContext();
        ObserveContext.CONFIG_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)config);
        instance.getDataService();
        instance.getDataContext();
        ObserveContext.ACTIONS_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)new ObserveCLAction());
        ObserveServiceHelper.set((ObserveApplicationContext)instance);
        ObserveServiceHelper.getDecoratorService();
        return instance;
    }

    protected ObserveMainUI startUI(ObserveContext context, ObserveConfig config) {
        ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
        ObserveMainUI ui = uiHandler.initUI(context, config);
        UIHelper.setMainUIVisible(ui);
        return ui;
    }

    protected void checkScriptEngineFound() {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine scriptEngine = factory.getEngineByExtension("js");
        if (scriptEngine == null) {
            String message = "Could not found script engine, use a Oracle jvm";
            if (Locale.FRANCE.getCountry().equals(Locale.getDefault().getCountry())) {
                message = "Moteur de scripting non trouv\u00e9, Utiliser une jvm fournie par Oracle.";
            }
            this.onError(new ScriptException(message));
        }
    }
}

