/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveRunner;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.AboutPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class ShowAboutAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final ObserveMainUI ui;

    public ShowAboutAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.about", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"about"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.about.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 65);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String translateText;
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;

            public void buildTopPanel() {
                this.topPanel.setLayout(new BorderLayout());
                ImageIcon logoIcon = Resource.getIcon((String)"/icons/logo-OT_web.png");
                JLabel labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "West");
                logoIcon = Resource.getIcon((String)"/icons/logo_ird.png");
                labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "East");
            }
        };
        String name = ObserveRunner.getRunner().getRunnerName();
        about.setTitle(I18n.t((String)"observe.title.about", (Object[])new Object[0]));
        about.setAboutText(I18n.t((String)"observe.about.message", (Object[])new Object[0]));
        about.setBottomText(this.ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/logo-OT_web.png");
        about.setLicenseFile("META-INF/" + name + "-LICENSE.txt");
        about.setThirdpartyFile("META-INF/" + name + "-THIRD-PARTY.txt");
        about.buildTopPanel();
        JScrollPane translatePane = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        File csvFile = new File(this.ui.getConfig().getI18nDirectory(), "observe-i18n.csv");
        try {
            translateText = I18n.t((String)"observe.about.translate.content", (Object[])new Object[]{csvFile.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not obtain url from " + csvFile, e);
        }
        translateArea.setText(translateText);
        translatePane.getViewport().add(translateArea);
        translateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                UIHelper.openLink(e);
            }
        });
        about.getTabs().add(I18n.t((String)"observe.about.translate.title", (Object[])new Object[0]), translatePane);
        about.init();
        about.showInDialog((Frame)this.ui, true);
    }
}

