/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ird.observe.ui.util.table.EditableList;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public abstract class AbstractEditableTableModel<E extends TopiaEntity>
extends AbstractTableModel {
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String EMPTY_PROPERTY = "empty";
    public static final String MODIFIED_PROPERTY = "modified";
    public static final String SELECTED_ROW_PROPERTY = "selectedRow";
    public static final String VALID_PROPERTY = "valid";
    private static final long serialVersionUID = 1L;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected boolean editable;
    protected boolean valid;
    protected boolean modified;
    protected int selectedRow = -1;
    protected List<E> data = new ArrayList();
    protected final TopiaEntityBinder<E> loader;
    protected final Map<Integer, EditableList<E>> cacheByRow;

    protected abstract E createNewRow();

    public abstract boolean isRowNotEmpty(E var1);

    protected abstract boolean isRowValid(E var1);

    protected AbstractEditableTableModel(TopiaEntityBinder<E> loader) {
        this.loader = loader;
        this.cacheByRow = new TreeMap<Integer, EditableList<E>>();
    }

    public TopiaEntityBinder<E> getLoader() {
        return this.loader;
    }

    public List<E> getData() {
        return this.data;
    }

    public E getData(int rowIndex) {
        return (E)((TopiaEntity)this.data.get(rowIndex));
    }

    public List<E> getCacheForRow(int rowIndex) {
        EditableList<E> measures = this.cacheByRow.get(rowIndex);
        return measures == null ? null : measures.getData();
    }

    public void initCacheForRow(int editingRow, List<E> data) {
        EditableList<E> editableList = this.cacheByRow.get(editingRow);
        Preconditions.checkState((editableList == null ? 1 : 0) != 0);
        editableList = new EditableList();
        List<E> original = this.copyList(data);
        editableList.setOriginal(original);
        editableList.setData(data);
        this.cacheByRow.put(editingRow, editableList);
    }

    public void storeInCacheForRow(int editingRow) {
        List<E> measures = this.getData();
        EditableList<E> editableList = this.cacheByRow.get(editingRow);
        Preconditions.checkState((editableList != null ? 1 : 0) != 0);
        editableList.setData(measures);
    }

    public void removeCacheForRow(int rowToDelete) {
        this.cacheByRow.remove(rowToDelete);
        ArrayList rows = Lists.newArrayList(this.getCacheRowsChanged());
        Collections.sort(rows);
        for (Integer row : rows) {
            if (row <= rowToDelete) continue;
            EditableList<E> remove = this.cacheByRow.remove(row);
            this.cacheByRow.put(row - 1, remove);
        }
    }

    public void resetCacheForRow(int rowtoReset) {
        EditableList<E> editableList = this.cacheByRow.get(rowtoReset);
        Preconditions.checkState((editableList != null ? 1 : 0) != 0);
        editableList.reset();
        List<E> newData = this.copyList(editableList.getOriginal());
        editableList.setData(newData);
        this.setData(newData);
        this.validate();
    }

    public Set<Integer> getCacheRowsChanged() {
        Set<Integer> rows = this.cacheByRow.keySet();
        return rows;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public void setData(List<E> data) {
        this.data.clear();
        this.data.addAll(data);
        if (this.data.isEmpty() && this.editable) {
            this.addNewRow();
        }
        this.setSelectedRow(this.isEmpty() ? -1 : 0);
        this.fireTableDataChanged();
    }

    public void addNewRow() {
        this.ensureEditable();
        int row = this.getRowCount();
        E bean = this.createNewRow();
        this.data.add(bean);
        this.fireTableRowsInserted(row, row);
        this.updateEmpty();
        this.setSelectedRow(row);
    }

    public void clear() {
        this.cacheByRow.clear();
        this.setData(Collections.emptyList());
        this.validate();
        this.setModified(false);
        this.updateEmpty();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int selectedRow) {
        int old = this.selectedRow;
        this.selectedRow = selectedRow;
        this.firePropertyChange(SELECTED_ROW_PROPERTY, old, selectedRow);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.firePropertyChange(MODIFIED_PROPERTY, null, modified);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void updateEmpty() {
        this.firePropertyChange(EMPTY_PROPERTY, null, this.isEmpty());
    }

    protected void ensureEditable() throws IllegalStateException {
        if (!this.editable) {
            throw new IllegalStateException("can not edit this model since it is marked as none editable " + this);
        }
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY, null, this.isValid());
    }

    public void validate() {
        boolean valid = true;
        for (TopiaEntity measure : this.data) {
            boolean measureValid = !this.isRowNotEmpty(measure) || this.isRowValid(measure);
            if (measureValid) continue;
            valid = false;
            break;
        }
        this.setValid(valid);
    }

    protected List<E> copyList(List<E> data) {
        ArrayList<E> copy = new ArrayList<E>(data.size());
        for (TopiaEntity measure : data) {
            E originalMeasure = this.createNewRow();
            this.loader.load(measure, originalMeasure, true, new String[0]);
            copy.add(originalMeasure);
        }
        return copy;
    }
}

