/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.seine.TripSeinesUI;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class TripSeinesUIHandler
extends ContentListUIHandler<Program, TripSeine> {
    private static final Log log = LogFactory.getLog(TripSeinesUIHandler.class);

    public TripSeinesUIHandler(TripSeinesUI ui) {
        super(ui, DataContextType.Program, DataContextType.TripSeine);
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openProgramId = dataContext.getOpenProgramId();
        if (openProgramId == null) {
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.maree.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Program.class)) {
            this.addInfoMessage(I18n.n((String)"observe.message.active.maree.found", (Object[])new Object[0]));
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.n((String)"observe.message.active.maree.found.for.other.program", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    protected void finalizeOpenUI() {
        String title = this.getDecoratorService().decorate(this.getBean());
        ((ContentUI)this.getUi()).setContentTitle(title);
    }

    @Override
    protected List<TripSeine> getChilds(Program bean) throws DataSourceException {
        DataSource source = this.getDataSource();
        DataService dataService = this.getDataService();
        List<TripSeine> list = dataService.getTripSeineByProgram(source, bean.getTopiaId(), true);
        if (list == null) {
            list = Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + list.size() + " marees."));
        }
        return list;
    }
}

