/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.constants.seine.SchoolType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.longline.SetLonglineUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class SetLonglineUIHandler
extends ContentUIHandler<SetLongline> {
    private static Log log = LogFactory.getLog(SetLonglineUIHandler.class);

    public SetLonglineUIHandler(SetLonglineUI ui) {
        super(ui, DataContextType.ActivitySeine, DataContextType.SetLongline);
    }

    public SetLonglineUI getUi() {
        return (SetLonglineUI)super.getUi();
    }

    public String updateTypeValue(SchoolType schoolType) {
        if (schoolType == null) {
            return I18n.t((String)"observe.common.schoolType.not.fill", (Object[])new Object[0]);
        }
        return I18n.t((String)schoolType.getI18nKey(), (Object[])new Object[0]);
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String setId = this.getSelectedId();
        if (setId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(ActivityLongline.class)) {
            return ContentMode.UPDATE;
        }
        SetLonglineUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        String setId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
            log.info((Object)("setId      = " + setId));
        }
        ContentMode mode = this.computeContentMode();
        DataService dataService = this.getDataService();
        SetLongline bean = (SetLongline)this.getBean();
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (setId == null) {
            dataService.preCreate(source, activityId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, setId, this.getLoadExecutor());
        }
        this.setContentMode(mode);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    protected SetLongline onPreCreate(TopiaContext tx, Object parent, SetLongline bean) throws TopiaException {
        ActivityLongline parentBean = (ActivityLongline)parent;
        Date timeStamp = parentBean.getTimeStamp();
        bean.setSettingStartTimeStamp(timeStamp);
        bean.setSettingEndTimeStamp(timeStamp);
        bean.setHaulingStartTimeStamp(timeStamp);
        bean.setHaulingEndTimeStamp(timeStamp);
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        this.getUi().getValidator().setContext(contextName);
        if (create) {
            this.addInfoMessage(I18n.t((String)"observe.message.creating.set", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.t((String)"observe.message.updating.set", (Object[])new Object[0]));
        }
        super.startEditUI("comment2.text", "homeId.text", "number.model", "settingVesselSpeed.model", "shooterUsed.selected", "shooterSpeed.model", "timeBetweenHooks.model", "settingShape.selectedItem", "weightedSwivel.selected", "swivelWeight.model", "weightedSnap.selected", "snapWeight.model", "lineType.selectedItem", "maxDepthTargeted.model", "monitored.selected", "lightsticksType.selectedItem", "lightsticksColor.selectedItem", "branchlineLength.model", "tracelineLength.model", "lightsticksPerBasketCount.model", "basketsPerSectionCount.model", "totalBasketsCount.model", "hooksPerBasketCount.model", "totalSectionsCount.model", "totalHooksCount.model", "haulingDirectionSameAsSetting.selected", "haulingBreaks.model", "settingStartTimeStamp.date", "settingStartCoordinates.latitude", "settingStartCoordinates.longitude", "settingStartCoordinates.quadrant", "settingEndTimeStamp.date", "settingEndCoordinates.latitude", "settingEndCoordinates.longitude", "settingEndCoordinates.quadrant", "haulingStartTimeStamp.date", "haulingStartCoordinates.latitude", "haulingStartCoordinates.longitude", "haulingStartCoordinates.quadrant", "haulingEndTimeStamp.date", "haulingEndCoordinates.latitude", "haulingEndCoordinates.longitude", "haulingEndCoordinates.quadrant");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(SetLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<SetLongline> binder) throws Exception {
        String activityId = this.getSelectedParentId();
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, activityId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        return true;
    }

    @Override
    protected SetLongline onCreate(TopiaContext tx, Object parent, SetLongline editBean) throws TopiaException {
        ActivityLongline parentBean = (ActivityLongline)parent;
        SetLongline beanToSave = (SetLongline)ObserveDAOHelper.getSetLonglineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.setSetLongline(beanToSave);
        return beanToSave;
    }

    @Override
    protected SetLongline onUpdate(TopiaContext tx, Object parentBean, SetLongline beanToSave) throws TopiaException {
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"baitsComposition", "floatlinesComposition", "hooksComposition", "branchlinesComposition", "section", "catchLongline", "mitigationType", "tdr"});
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        boolean create;
        super.afterSave(refresh);
        SetLongline bean = (SetLongline)this.getBean();
        SwingValidatorUtil.setValidatorChanged((JAXXObject)this.getUi(), (boolean)false, (String[])new String[0]);
        ObserveTreeHelper treeHelper = SetLonglineUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean bl = create = node.getId() == null;
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            node = treeHelper.addSet(parentNode, bean);
            this.stopEditUI();
            treeHelper.selectNode((NavNode)node);
        } else {
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected boolean doDelete(SetLongline bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, SetLongline> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String activityId = this.getSelectedParentId();
        dataService.delete(dataSource, activityId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, SetLongline beanToDelete) throws TopiaException {
        ActivityLongline parentBean = (ActivityLongline)parent;
        ObserveDAOHelper.getSetLonglineDAO((TopiaContext)tx).delete(parentBean.getSetLongline());
        parentBean.setSetLongline(null);
    }
}

