/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.util.BooleanEditor;
import fr.ird.observe.util.DBHelper;
import fr.ird.observe.validation.ObserveValidator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.util.DateUtil;

public class ContentUIInitializer<E extends TopiaEntity, UI extends ObserveContentUI<E>> {
    public static final String OBSERVE_ACTION = "observeAction";
    public static final String CLIENT_PROPERTY_PROPERTY_NAME = "propertyName";
    public static final String CLIENT_PROPERTY_RESET_PROPERTY_NAME = "resetPropertyName";
    private static final Log log = LogFactory.getLog(ContentUIInitializer.class);
    protected final UI ui;

    public ContentUIInitializer(UI ui) {
        this.ui = ui;
    }

    protected static void attachTopiaContext(DataSource service, TopiaEntityAbstract entity) {
        DBHelper.attachTopiaContext((TopiaContext)service.getRootCtxt(), (TopiaEntityAbstract)entity);
    }

    protected E getBean() {
        Object bean = this.ui.getModel().getBean();
        return bean;
    }

    public void initUI(DataSource dataSource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ui " + this.getClass()));
        }
        ActionMap actionMap = ObserveContext.get().getActionMap();
        this.init(dataSource);
        DecoratorService decoratorService = ObserveContext.get().getDecoratorService();
        for (String name : this.ui.get$objectMap().keySet()) {
            Object o = this.ui.getObjectById(name);
            if (o == null) continue;
            if (o instanceof TopiaEntity) {
                this.init(dataSource);
                continue;
            }
            if (o instanceof JCheckBox) {
                this.init((JCheckBox)o);
            }
            if (o instanceof AbstractButton) {
                this.init(actionMap, (AbstractButton)o);
                continue;
            }
            if (o instanceof NumberEditor) {
                this.init((NumberEditor)o);
                continue;
            }
            if (o instanceof BeanComboBox) {
                this.init(dataSource, (BeanComboBox)o);
                continue;
            }
            if (o instanceof BeanListHeader) {
                this.init(dataSource, decoratorService, (BeanListHeader)o);
                continue;
            }
            if (o instanceof JXDatePicker) {
                this.init((JXDatePicker)o);
                continue;
            }
            if (o instanceof TimeEditor) {
                this.init((TimeEditor)o);
                continue;
            }
            if (o instanceof SimpleTimeEditor) {
                this.init((SimpleTimeEditor)o);
                continue;
            }
            if (o instanceof DateTimeEditor) {
                this.init((DateTimeEditor)o);
                continue;
            }
            if (o instanceof CoordinatesEditor) {
                this.init((CoordinatesEditor)o);
                continue;
            }
            if (o instanceof BooleanEditor) {
                this.init((BooleanEditor)o);
                continue;
            }
            if (o instanceof ObserveValidator) {
                this.init(this.ui, (ObserveValidator)o);
                continue;
            }
            if (o instanceof JTextField) {
                this.init((JTextField)o);
                continue;
            }
            if (!(o instanceof JTextArea)) continue;
            this.init((JTextArea)o);
        }
    }

    protected void init(UI ui, ObserveValidator<?> validator) {
        SwingValidatorUtil.listenValidatorContextNameAndRefreshFields(validator, (JAXXValidator)((JAXXValidator)ui));
    }

    protected void init(DataSource service) throws DataSourceException {
        E bean = this.getBean();
        if (bean == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init entity " + bean.getClass()));
        }
        ContentUIInitializer.attachTopiaContext(service, (TopiaEntityAbstract)bean);
    }

    protected void init(ActionMap actionMap, AbstractButton editor) throws DataSourceException {
        String actionId = (String)editor.getClientProperty(OBSERVE_ACTION);
        if (actionId == null) {
            final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_RESET_PROPERTY_NAME);
            if (propertyName != null) {
                editor.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, null);
                    }
                });
            }
            return;
        }
        AbstractUIAction action = (AbstractUIAction)actionMap.get(actionId);
        if (action == null) {
            throw new IllegalStateException("action [" + actionId + "] not found for ui " + this.ui.getClass().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init common action " + actionId));
        }
        action.initAction(null, editor);
    }

    protected void init(NumberEditor editor) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(DataSource dataSource, BeanComboBox beanComboBox) throws DataSourceException {
        Class klass = beanComboBox.getHandler().getBeanType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("init combobox for " + klass));
        }
        beanComboBox.setI18nPrefix("observe.common.");
        beanComboBox.setMinimumSize(new Dimension(0, 24));
        UIHelper.prepareBeanComboBox(dataSource, klass, beanComboBox);
    }

    protected void init(DataSource dataSource, DecoratorService decoratorService, BeanListHeader beanList) throws DataSourceException {
        beanList.setI18nPrefix("observe.common.");
        if (log.isInfoEnabled()) {
            log.info((Object)("init list for " + beanList.getBeanType()));
        }
        UIHelper.prepareEntityList(dataSource, beanList.getBeanType(), beanList);
        JList jlist = beanList.getList();
        Object init = jlist.getClientProperty("addDecorator");
        if (init != null) {
            Class klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("addDecorator to list " + jlist.getName()));
            }
            Decorator decorator = decoratorService.getDecoratorByType(klass);
            jlist.putClientProperty("decorator", decorator);
        }
        if ((init = jlist.getClientProperty("addToogleListSelectionModel")) != null && init instanceof Boolean && ((Boolean)init).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            UIHelper.prepareToogleListSelectionModel(jlist);
        }
    }

    protected void init(TimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getProperty()));
        }
        editor.init();
    }

    protected void init(SimpleTimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(DateTimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init date time editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(CoordinatesEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init coordinates editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(JTextField editor) {
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextField source = (JTextField)e.getSource();
                    String text = source.getText();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)text);
                }
            });
        }
    }

    protected void init(JTextArea editor) {
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextArea source = (JTextArea)e.getSource();
                    String text = source.getText();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)text);
                }
            });
        }
    }

    protected void init(BooleanEditor editor) throws DataSourceException {
        String propertyName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("init boolean editor " + editor.getName()));
        }
        if ((propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME)) != null) {
            editor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        Boolean newValue = ((BooleanEditor)event.getSource()).getBooleanValue();
                        JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)newValue);
                    }
                }
            });
        }
    }

    protected void init(JCheckBox editor) throws DataSourceException {
        String propertyName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("init simple boolean editor " + editor.getName()));
        }
        if ((propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME)) != null) {
            editor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    Boolean newValue = ((JCheckBox)event.getSource()).isSelected();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)newValue);
                }
            });
        }
    }

    protected void init(JXDatePicker picker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        }
        picker.getEditor().setEditable(false);
        JXMonthView monthView = new JXMonthView();
        monthView.setLowerBound(DateUtil.createDate((int)1, (int)1, (int)1970));
        monthView.setTraversable(true);
        monthView.setZoomable(true);
        picker.setMonthView(monthView);
        final String propertyName = (String)picker.getClientProperty((Object)CLIENT_PROPERTY_PROPERTY_NAME);
        if (propertyName != null) {
            picker.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JXDatePicker source = (JXDatePicker)e.getSource();
                    Date date = source.getDate();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)date);
                }
            });
        }
    }
}

