/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.util.PGInstall;
import fr.ird.observe.db.util.SecurityModel;
import fr.ird.observe.ui.storage.ObstunaAdminAction;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.Window;
import java.util.ArrayList;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RemoteUILauncher
extends StorageUILauncher {
    private static Log log = LogFactory.getLog(RemoteUILauncher.class);
    protected ObstunaAdminAction action;

    public RemoteUILauncher(ObstunaAdminAction action, JAXXContext context, Window frame, String title) {
        super(context, frame, title);
        this.action = action;
    }

    @Override
    protected void init(StorageUI ui) {
        super.init(ui);
        StorageUIModel model = ui.getModel();
        model.setCanCreateLocalService(false);
        model.setCanUseLocalService(false);
        model.setCanUseRemoteService(true);
        model.setDbMode(DbMode.USE_REMOTE);
        model.setAdminAction(this.action);
        model.setPgInstall(new PGInstall(){

            public void execute() throws Exception {
                RemoteUILauncher.this.execute(this);
            }
        });
        ArrayList<StorageStep> steps = new ArrayList<StorageStep>();
        steps.add(StorageStep.CONFIG);
        if (this.action == ObstunaAdminAction.CREATE) {
            steps.add(StorageStep.CONFIG_REFERENTIEL);
            steps.add(StorageStep.CONFIG_DATA);
            steps.add(StorageStep.SELECT_DATA);
        }
        steps.add(StorageStep.ROLES);
        steps.add(StorageStep.CONFIRM);
        model.setSteps(steps.toArray(new StorageStep[steps.size()]));
        ui.setSize(800, 600);
    }

    @Override
    protected void doAction(StorageUI ui) {
        super.doAction(ui);
        StorageUIModel model = ui.getModel();
        SecurityModel securityModel = model.getSecurityModel();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use security model " + securityModel));
        }
        PGInstall install = model.getPgInstall();
        try {
            this.initTask(model, install);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not init task.", (Throwable)e);
            }
            ErrorDialogUI.showError((Exception)e);
            throw new RuntimeException(e);
        }
        try {
            this.execute(install);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not create db.", (Throwable)e);
            }
            ErrorDialogUI.showError((Exception)e);
            throw new RuntimeException(e);
        }
        try {
            this.applySecurity(install);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not apply security to db.", (Throwable)e);
            }
            ErrorDialogUI.showError((Exception)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract String getPgLabel();

    protected void initTask(StorageUIModel model, PGInstall task) throws Exception {
        task.init(model.toPostgresStorageConfig(this.getPgLabel()), model.getSecurityModel(), false);
    }

    protected void execute(PGInstall task) throws Exception {
    }

    protected void applySecurity(PGInstall task) throws Exception {
    }

    protected DataService getDataService() {
        return ObserveContext.get().getDataService();
    }
}

