/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.ref;

import com.google.common.base.Preconditions;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.entities.referentiel.ReferenceEntity;
import fr.ird.observe.ui.content.ref.ContentReferenceUI;
import fr.ird.observe.ui.content.ref.ContentReferenceUIHandler;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentReferenceUIHandlerFactory {
    private static final Log log = LogFactory.getLog(ContentReferenceUIHandlerFactory.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static EnumMap<ObserveEntityEnum, HandlerDefinition<?>> mapping;

    public static <E extends ReferenceEntity> ContentReferenceUIHandler<E> newHandler(ContentReferenceUI<E> ui) {
        ObserveEntityEnum constant;
        HandlerDefinition<E> definition;
        Class type = ui.getModel().getBeanType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("recherche handler pour " + type));
        }
        if ((definition = ContentReferenceUIHandlerFactory.getDefinition(constant = ObserveEntityEnum.valueOf(type))) == null) {
            throw new IllegalStateException("Aucune d\u00e9finition pour l'objet " + constant);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("create handler for " + type));
        }
        ContentReferenceUIHandler<E> result = definition.toHandler(ui);
        return result;
    }

    protected static <E extends ReferenceEntity> HandlerDefinition<E> getDefinition(ObserveEntityEnum constant) {
        HandlerDefinition<?> definition = ContentReferenceUIHandlerFactory.getMapping().get(constant);
        return definition;
    }

    protected static void loadMapping() {
        ContentReferenceUIHandlerFactory.loadCommonMapping();
        ContentReferenceUIHandlerFactory.checkMapping(DBHelper.REFERENCE_COMMON_ENTITIES_LIST);
        ContentReferenceUIHandlerFactory.loadSeineMapping();
        ContentReferenceUIHandlerFactory.checkMapping(DBHelper.REFERENCE_SEINE_ENTITIES_LIST);
        ContentReferenceUIHandlerFactory.loadLonglineMapping();
        ContentReferenceUIHandlerFactory.checkMapping(DBHelper.REFERENCE_LONGLINE_ENTITIES_LIST);
        ContentReferenceUIHandlerFactory.checkMapping(DBHelper.REFERENCE_ENTITIES_LIST);
    }

    protected static void loadCommonMapping() {
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SpeciesGroup);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Sex);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Ocean);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.VesselType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Vessel, new String[]{"vesselType", "vesselSizeCategory", "flagCountry", "keelCode", "fleetCountry", "yearService", "length", "capacity", "power", "searchMaximum", "changeDate"}, "vesselType.selectedItem", "vesselSizeCategory.selectedItem", "flagCountry.selectedItem", "keelCode.model", "fleetCountry.model", "yearService.model", "length.model", "capacity.model", "power.model", "searchMaximum.model", "changeDate.date");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.VesselSizeCategory, new String[]{"gaugeLabel", "capacityLabel"}, "capacityLabel.text", "gaugeLabel.text");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Species, new String[]{"speciesGroup", "ocean"}, "speciesGroup.selectedItem");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Person, new String[]{"code", "lastName", "firstName", "captain", "observer", "dataEntryOperator"}, new String[]{"code"}, new String[]{"code.text", "firstName.text", "lastName.text", "captain.selected", "observer.selected", "dataEntryOperator.selected"});
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Organism, new String[]{"country", "description"}, "country.selectedItem", "description.text");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.LengthWeightParameter, EMPTY_STRING_ARRAY, new String[]{"sex", "ocean", "species", "startDate"}, EMPTY_STRING_ARRAY);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.FpaZone, new String[]{"startDate", "endDate"}, "startDate.date", "endDate.date");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Country, new String[]{"iso2Code", "iso3Code"}, "iso2Code.text", "iso3Code.text");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Program, new String[]{"organism", "startDate", "endDate", "detailledActivitiesObservation", "nonTargetObservation", "baitObservation", "mammalsObservation", "samplesObservation", "objectsObservation", "birdsObservation", "targetDiscardsObservation", "gearType"}, "organism.selectedItem", "startDate.date", "endDate.date", "detailledActivitiesObservation.selectedIndex", "nonTargetObservation.selectedIndex", "baitObservation.selectedIndex", "mammalsObservation.selectedIndex", "samplesObservation.selectedIndex", "objectsObservation.selectedIndex", "birdsObservation.selectedIndex", "targetDiscardsObservation.selectedIndex", "gearType.selectedItem");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SpeciesList, new String[]{"species"}, new String[0]);
    }

    protected static void loadSeineMapping() {
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.VesselActivity);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SurroundingActivity);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ReasonForNullSet);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ReasonForNoFishing);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SpeciesFate);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ObjectFate);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.DetectionMode);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.TransmittingBuoyOperation);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ObjectOperation);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ReasonForDiscard);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SpeciesStatus);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.TransmittingBuoyType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ObjectType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.WeightCategory, new String[]{"code", "species"}, new String[]{"code", "species"}, new String[]{"code.text", "species.selectedItem"});
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ObservedSystem, new String[]{"schoolType"}, "schoolType.selectedItem");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Wind, new String[]{"speedRange", "waveHeight"}, "speedRange.text", "waveHeight.text");
    }

    protected static void loadLonglineMapping() {
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.BaitHaulingStatus);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.BaitSettingStatus);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.BaitType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.CatchFateLongline);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.EncounterType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.Healthness);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.HookPosition);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.HookSize);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.HookType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ItemHorizontalPosition);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.ItemVerticalPosition);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.LightsticksColor);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.LightsticksType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.LineType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.MaturityStatus, new String[]{"lowerValue", "upperValue"}, "lowerValue.text", "upperValue.text");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.MitigationType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SensorBrand, new String[]{"brandName"}, "brandName.text");
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SensorDataFormat);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SensorPosition);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SensorType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SettingShape);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.SizeMeasureType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.StomacFullness);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.TripType);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.VesselActivityLongline);
        ContentReferenceUIHandlerFactory.registerMapping(ObserveEntityEnum.WeightMeasureType);
    }

    private static void checkMapping(List<ObserveEntityEnum> expected) {
        EnumSet<ObserveEntityEnum> missing = EnumSet.copyOf(expected);
        missing.removeAll(mapping.keySet());
        Preconditions.checkState((boolean)missing.isEmpty(), (Object)("There is some missing references screens: " + missing));
    }

    protected static EnumMap<ObserveEntityEnum, HandlerDefinition<?>> getMapping() {
        if (mapping == null) {
            mapping = new EnumMap(ObserveEntityEnum.class);
            ContentReferenceUIHandlerFactory.loadMapping();
        }
        return mapping;
    }

    protected static void registerMapping(ObserveEntityEnum entityClass) {
        ContentReferenceUIHandlerFactory.registerMapping(entityClass, null, new String[0]);
    }

    protected static void registerMapping(ObserveEntityEnum entityClass, String[] extraProperties, String ... extraDataBindings) {
        ContentReferenceUIHandlerFactory.registerMapping(entityClass, extraProperties, null, extraDataBindings);
    }

    protected static void registerMapping(ObserveEntityEnum entityClass, String[] extraProperties, String[] naturalIds, String ... extraDataBindings) {
        HandlerDefinition ref = new HandlerDefinition(entityClass.getContract(), naturalIds, extraProperties, extraDataBindings);
        mapping.put(entityClass, ref);
    }

    protected static class HandlerDefinition<E extends ReferenceEntity> {
        protected Class<E> entityClass;
        protected String[] extraProperties;
        protected String[] naturalIds;
        protected String[] extraDataBindings;

        public HandlerDefinition(Class<E> entityClass, String[] naturalIds, String[] extraProperties, String[] extraDataBindings) {
            this.entityClass = entityClass;
            this.naturalIds = naturalIds;
            this.extraProperties = extraProperties == null ? EMPTY_STRING_ARRAY : extraProperties;
            this.extraDataBindings = extraDataBindings == null ? EMPTY_STRING_ARRAY : extraDataBindings;
        }

        public Class<E> getEntityClass() {
            return this.entityClass;
        }

        public String[] getExtraProperties() {
            return this.extraProperties;
        }

        public String[] getNaturalIds() {
            return this.naturalIds;
        }

        public String[] getExtraDataBindings() {
            return this.extraDataBindings;
        }

        public ContentReferenceUIHandler<E> toHandler(ContentReferenceUI<E> ui) {
            ContentReferenceUIHandler<E> result = new ContentReferenceUIHandler<E>(ui, this.getExtraProperties(), this.getNaturalIds(), this.getExtraDataBindings());
            return result;
        }
    }
}

