/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl.seine;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.Trip;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.seine.TripsUI;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;

public class TripsUIHandler
extends ContentListUIHandler<Program, Trip> {
    private static final Log log = LogFactory.getLog(TripsUIHandler.class);

    public TripsUIHandler(TripsUI ui) {
        super(ui, DataContextType.Program, DataContextType.Trip);
    }

    @Override
    protected TopiaEntityBinder<Program> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Program.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Program.class, new String[]{"label1", "label2", "label3", "label4", "label5", "label6", "label7", "label8"});
            r = binderService.registerTopiaBinder(Program.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openProgramId = dataContext.getOpenProgramId();
        if (openProgramId == null) {
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.maree.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Program.class)) {
            this.addInfoMessage(I18n.n((String)"observe.message.active.maree.found", (Object[])new Object[0]));
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.n((String)"observe.message.active.maree.found.for.other.program", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    protected void finalizeOpenUI() {
        String title = this.getDecoratorService().decorate(this.getBean());
        this.getUi().setContentTitle(title);
    }

    @Override
    protected List<Trip> getChilds(Program bean) throws DataSourceException {
        DataSource source = this.getDataSource();
        DataService dataService = this.getDataService();
        List<Trip> list = dataService.getTripByProgram(source, bean.getTopiaId(), true);
        if (list == null) {
            list = Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + list.size() + " marees."));
        }
        return list;
    }
}

