/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.OpenableEntity;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.referentiel.seine.ObservedSystem;
import fr.ird.observe.entities.seine.Activity;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.Trip;
import fr.ird.observe.ui.content.impl.seine.FloatingObjectUI;
import fr.ird.observe.ui.content.impl.seine.SetUI;
import fr.ird.observe.ui.content.open.impl.seine.ActivityUI;
import fr.ird.observe.ui.content.open.impl.seine.RouteUI;
import fr.ird.observe.ui.content.open.impl.seine.TripUI;
import fr.ird.observe.ui.tree.ObserveDataProvider;
import fr.ird.observe.ui.tree.ObserveNode;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public abstract class AbstractObserveTreeCellRenderer
extends AbstractNavTreeCellRenderer<DefaultTreeModel, ObserveNode> {
    protected static final Log log = LogFactory.getLog(AbstractObserveTreeCellRenderer.class);
    public static final List<Class<?>> CREATION_UI = Collections.unmodifiableList(Arrays.asList(TripUI.class, RouteUI.class, ActivityUI.class, FloatingObjectUI.class, SetUI.class));
    private static final long serialVersionUID = 1L;
    protected Color closeColor;
    protected Color openColor;
    protected Color redColor;
    protected DecoratorService decoratorService;

    public DecoratorService getDecoratorService() {
        if (this.decoratorService == null) {
            this.decoratorService = ObserveContext.get().getDecoratorService();
        }
        return this.decoratorService;
    }

    public ObserveDataProvider getDataProvider() {
        DataSource source;
        ObserveDataProvider provider = (ObserveDataProvider)super.getDataProvider();
        if (provider == null && (source = ObserveContext.get().getDataSource()) != null) {
            provider = new ObserveDataProvider(source);
            this.setDataProvider(provider);
        }
        return provider;
    }

    public AbstractObserveTreeCellRenderer() {
        this.init();
    }

    protected void init() {
        this.closeColor = Color.LIGHT_GRAY;
        this.openColor = this.getForeground();
        this.redColor = Color.RED;
    }

    public void setIcon(ObserveNode node) {
        Icon icon = this.getNavigationIcon(node);
        this.setDefaultIcons(icon);
    }

    public Icon getNavigationIcon(ObserveNode node) {
        Icon icon = this.getNavigationIcon(node, null);
        return icon;
    }

    public Color getBackgroundSelectionColor() {
        return null;
    }

    public Color getBackgroundNonSelectionColor() {
        return Color.WHITE;
    }

    public Icon getNavigationIcon(ObserveNode node, String suffix) {
        String path;
        if (node == null || node.isRoot()) {
            return null;
        }
        if (suffix == null) {
            suffix = "";
        }
        if (node.isReferentielNode()) {
            Icon icon = node.isStringNode() ? UIManager.getIcon("navigation.referentiel" + suffix) : UIManager.getIcon("navigation.sub.referentiel" + suffix);
            return icon;
        }
        if (!node.isStringNode()) {
            String path2 = "navigation." + node.getInternalClass().getName() + suffix;
            Icon icon = UIManager.getIcon(path2);
            return icon;
        }
        ObserveNode containerNode = (ObserveNode)node.getContainerNode();
        Class containerClass = containerNode.getInternalClass();
        if (Trip.class.equals((Object)containerClass)) {
            path = Route.class.getName();
        } else if (Route.class.equals((Object)containerClass)) {
            path = Activity.class.getName();
        } else if (Activity.class.equals((Object)containerClass)) {
            path = ObservedSystem.class.getName();
        } else {
            suffix = "";
            path = containerClass.getName() + ".sub";
        }
        Icon icon = UIManager.getIcon("navigation." + path + suffix);
        return icon;
    }

    public void setDefaultIcons(Icon icon) {
        if (icon == null) {
            this.setOpenIcon(this.getDefaultOpenIcon());
            this.setClosedIcon(this.getDefaultClosedIcon());
            this.setLeafIcon(this.getDefaultLeafIcon());
        } else {
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
        }
    }

    protected String computeNodeText(ObserveNode node) {
        String text;
        if (log.isDebugEnabled()) {
            log.debug((Object)("for node : " + node.getId()));
        }
        if (node.isStringNode()) {
            String text2 = I18n.t((String)node.getId(), (Object[])new Object[0]);
            return text2;
        }
        Class beanType = node.getInternalClass();
        if (node.isReferentielNode()) {
            String text3 = I18n.t((String)this.getDecoratorService().getEntityLabel(beanType), (Object[])new Object[0]);
            return text3;
        }
        String id = node.getId();
        if (id == null) {
            String text4 = I18n.t((String)node.getContext(), (Object[])new Object[0]);
            return text4;
        }
        Decorator decorator = this.getDecoratorService().getDecoratorByType(beanType);
        if (this.getDataProvider() == null) {
            String text5 = "No data provider opened to render " + id;
            return text5;
        }
        DataSource source = this.getDataProvider().getDataSource();
        if (source == null || !source.isOpen()) {
            String text6 = "No source opened to render " + id;
            return text6;
        }
        try {
            text = source.decorateEntity(null, id, decorator);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not decorate entity " + id), (Throwable)e);
            }
            text = node.getId();
        }
        return text;
    }

    public Color getNavigationTextColor(ObserveNode node) {
        Class parentContentClass;
        if (node == null) {
            return this.openColor;
        }
        if (node.isRoot() || node.isReferentielNode()) {
            return this.openColor;
        }
        Class contentClass = node.getInternalClass();
        ObserveNode parentNode = (ObserveNode)node.getParent();
        Class clazz = parentContentClass = parentNode == null ? null : parentNode.getInternalClass();
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + (Object)((Object)node) + "] Content class to use : " + contentClass));
            log.trace((Object)("[" + (Object)((Object)node) + "] Parent Content class to use : " + parentContentClass));
        }
        DataContext dataContext = ObserveContext.get().getDataContext();
        String nodeId = node.getId();
        if (Program.class.equals((Object)contentClass)) {
            String p = dataContext.getOpenProgramId();
            if (p != null && p.equals(nodeId)) {
                return this.openColor;
            }
            return this.closeColor;
        }
        boolean nodeIsOpen = this.isOpenNode(node);
        if (!nodeIsOpen) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + (Object)((Object)node) + "] is not open, use closeColor"));
            }
            return this.closeColor;
        }
        if (CREATION_UI.contains(contentClass)) {
            if (nodeId == null) {
                return this.redColor;
            }
            return this.openColor;
        }
        return this.openColor;
    }

    public boolean isOpenNode(ObserveNode node) {
        if (node.isRoot() || node.isReferentielNode()) {
            return false;
        }
        boolean nodeIsOpen = false;
        ObserveNode openableNode = this.getFirstOpenableNode(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("openable node " + Arrays.toString(openableNode.getPath()) + " for " + Arrays.toString(node.getPath())));
        }
        if (openableNode != null) {
            Boolean open = openableNode.isOpen();
            nodeIsOpen = open != null && open != false;
        }
        return nodeIsOpen;
    }

    public static ObserveNode getNode(Object value) {
        ObserveNode node = null;
        if (value instanceof ObserveNode) {
            node = (ObserveNode)((Object)value);
        }
        return node;
    }

    public ObserveNode getFirstOpenableNode(ObserveNode node) {
        if (OpenableEntity.class.isAssignableFrom(node.getInternalClass())) {
            return node;
        }
        if (Program.class.isAssignableFrom(node.getInternalClass())) {
            return node;
        }
        ObserveNode parentNode = (ObserveNode)node.getParent();
        if (parentNode != null) {
            return this.getFirstOpenableNode(parentNode);
        }
        return null;
    }
}

