/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.Activity;
import fr.ird.observe.entities.seine.FloatingObject;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.Set;
import fr.ird.observe.entities.seine.Trip;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.impl.seine.FloatingObjectUI;
import fr.ird.observe.ui.content.impl.seine.ObservedSystemUI;
import fr.ird.observe.ui.content.impl.seine.SetUI;
import fr.ird.observe.ui.content.impl.seine.TransmittingBuoyOperationUI;
import fr.ird.observe.ui.content.list.impl.seine.ActivitysUI;
import fr.ird.observe.ui.content.list.impl.seine.RoutesUI;
import fr.ird.observe.ui.content.list.impl.seine.TripsUI;
import fr.ird.observe.ui.content.open.impl.seine.ActivityUI;
import fr.ird.observe.ui.content.open.impl.seine.RouteUI;
import fr.ird.observe.ui.content.open.impl.seine.TripUI;
import fr.ird.observe.ui.content.ref.ContentReferenceUI;
import fr.ird.observe.ui.content.ref.ReferenceHomeUI;
import fr.ird.observe.ui.content.table.impl.seine.NonTargetCatchUI;
import fr.ird.observe.ui.content.table.impl.seine.NonTargetSampleUI;
import fr.ird.observe.ui.content.table.impl.seine.ObjectObservedSpeciesUI;
import fr.ird.observe.ui.content.table.impl.seine.ObjectSchoolEstimateUI;
import fr.ird.observe.ui.content.table.impl.seine.SchoolEstimateUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetCatchUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetDiscardCatchUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetSampleCaptureUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetSampleRejeteUI;
import fr.ird.observe.ui.tree.ObserveNode;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ContentUIManager {
    public static final String REFERENCE = "reference";
    public static final String DATA = "data";
    private static final Log log = LogFactory.getLog(ContentUIManager.class);
    protected final ObserveMainUI ui;
    protected final Map<String, Class<? extends ContentUI<?>>> mapping;

    public ContentUIManager(ObserveMainUI ui) {
        Class<?> result;
        String fqn;
        Class editType;
        this.ui = ui;
        this.mapping = new TreeMap();
        for (ObserveEntityEnum anEnum : DBHelper.REFERENCE_COMMON_ENTITIES_LIST) {
            editType = anEnum.getContract();
            fqn = ContentReferenceUI.class.getPackage().getName() + ".impl." + editType.getSimpleName() + "UI";
            try {
                result = Class.forName(fqn);
                this.addMapping(REFERENCE, editType, null, result);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find " + fqn);
            }
        }
        for (ObserveEntityEnum anEnum : DBHelper.REFERENCE_SEINE_ENTITIES_LIST) {
            editType = anEnum.getContract();
            fqn = ContentReferenceUI.class.getPackage().getName() + ".impl.seine." + editType.getSimpleName() + "UI";
            try {
                result = Class.forName(fqn);
                this.addMapping(REFERENCE, editType, null, result);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find " + fqn);
            }
        }
        for (ObserveEntityEnum anEnum : DBHelper.REFERENCE_LONGLINE_ENTITIES_LIST) {
            editType = anEnum.getContract();
            fqn = ContentReferenceUI.class.getPackage().getName() + ".impl.longline." + editType.getSimpleName() + "UI";
            try {
                result = Class.forName(fqn);
                this.addMapping(REFERENCE, editType, null, result);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find " + fqn);
            }
        }
        this.addMapping(REFERENCE, null, ReferenceHomeUI.class);
        this.addMapping(DATA, Program.class, TripsUI.class);
        this.addMapping(DATA, Trip.class, TripUI.class);
        this.addMapping(DATA, Trip.class, I18n.n((String)"observe.common.trip.unsaved", (Object[])new Object[0]), TripUI.class);
        this.addMapping(DATA, Trip.class, "route", RoutesUI.class);
        this.addMapping(DATA, Route.class, RouteUI.class);
        this.addMapping(DATA, Route.class, I18n.n((String)"observe.common.route.unsaved", (Object[])new Object[0]), RouteUI.class);
        this.addMapping(DATA, Route.class, "activity", ActivitysUI.class);
        this.addMapping(DATA, Activity.class, ActivityUI.class);
        this.addMapping(DATA, Activity.class, I18n.n((String)"observe.common.activity.unsaved", (Object[])new Object[0]), ActivityUI.class);
        this.addMapping(DATA, Activity.class, "observedSystem", ObservedSystemUI.class);
        this.addMapping(DATA, Set.class, SetUI.class);
        this.addMapping(DATA, Set.class, I18n.n((String)"observe.common.set.unsaved", (Object[])new Object[0]), SetUI.class);
        this.addMapping(DATA, Set.class, "schoolEstimate", SchoolEstimateUI.class);
        this.addMapping(DATA, Set.class, "targetCatch", TargetCatchUI.class);
        this.addMapping(DATA, Set.class, "targetDiscarded", TargetDiscardCatchUI.class);
        this.addMapping(DATA, Set.class, "targetSample", TargetSampleRejeteUI.class);
        this.addMapping(DATA, Set.class, "targetSampleCapture", TargetSampleCaptureUI.class);
        this.addMapping(DATA, Set.class, "nonTargetCatch", NonTargetCatchUI.class);
        this.addMapping(DATA, Set.class, "nonTargetSample", NonTargetSampleUI.class);
        this.addMapping(DATA, FloatingObject.class, FloatingObjectUI.class);
        this.addMapping(DATA, FloatingObject.class, I18n.n((String)"observe.common.floatingObject.unsaved", (Object[])new Object[0]), FloatingObjectUI.class);
        this.addMapping(DATA, FloatingObject.class, "objectOperation", TransmittingBuoyOperationUI.class);
        this.addMapping(DATA, FloatingObject.class, "objectObservedSpecies", ObjectObservedSpeciesUI.class);
        this.addMapping(DATA, FloatingObject.class, "objectSchoolEstimate", ObjectSchoolEstimateUI.class);
    }

    public Class<? extends ContentUI<?>> convertNodeToContentUI(ObserveNode node) {
        String mappingKey;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entrer for node = " + (Object)((Object)node)));
        }
        if (node.isRoot()) {
            return null;
        }
        Class editType = node.getInternalClass();
        String prefix = node.isReferentielNode() ? REFERENCE : DATA;
        String context = node.getContext();
        if (node.isReferentielNode()) {
            if (String.class.equals((Object)editType)) {
                editType = null;
            }
        } else if (String.class.equals((Object)editType)) {
            editType = ((ObserveNode)node.getContainerNode()).getInternalClass();
        }
        if ((mappingKey = this.getMappingKey(prefix, editType, context)) == null) {
            throw new NullPointerException("Could not find mappingKey for node " + (Object)((Object)node));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("mappingKey = [" + mappingKey + "] for node " + (Object)((Object)node)));
        }
        Class<? extends ContentUI<?>> result = this.mapping.get(mappingKey);
        return result;
    }

    public <U extends ContentUI<?>> U getContent(Class<U> uiClass) {
        CardLayout2 layout = this.getLayout();
        JPanel layoutContent = this.getLayoutContent();
        String constraints = uiClass.getName();
        if (!layout.contains((Serializable)((Object)constraints))) {
            return null;
        }
        ContentUI content = (ContentUI)((Object)layout.getComponent((Container)layoutContent, constraints));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use existing content [" + constraints + "] : " + ((Object)((Object)content)).getClass().getName()));
        }
        return (U)((Object)content);
    }

    public <U extends ContentUI<?>> U createContent(Class<U> uiClass) {
        ContentUI result;
        String constraints = uiClass.getName();
        if (this.getLayout().contains((Serializable)((Object)constraints))) {
            throw new IllegalStateException("Already existing constrainst [" + constraints + "]");
        }
        try {
            Constructor<U> constructor = uiClass.getConstructor(JAXXContext.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("create new content : " + uiClass + " from ui " + this.ui.getClass().getName()));
            }
            result = (ContentUI)((Object)constructor.newInstance(new JAXXInitialContext().add((Object)this.ui)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create content ui " + uiClass, e);
        }
        try {
            this.getLayoutContent().add((Component)((Object)result), constraints);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add new content [" + constraints + "] : " + ((Object)((Object)result)).getClass().getName()));
            }
            result.init();
            return (U)((Object)result);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init content ui " + uiClass, e);
        }
    }

    public ContentUI<?> getCurrentContent() {
        ContentUI component = (ContentUI)((Object)this.getLayout().getVisibleComponent((Container)this.getLayoutContent()));
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openContent(ContentUI<?> content) {
        String constraints = ((Object)content).getClass().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will open ui [" + constraints + "] : " + ((Object)content).getClass()));
        }
        try {
            content.open();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
        finally {
            this.getLayout().show((Container)this.getLayoutContent(), constraints);
        }
    }

    public void close() {
        this.getLayout().reset((Container)this.getLayoutContent());
    }

    protected JPanel getLayoutContent() {
        JPanel content = this.ui.getContent();
        return content;
    }

    protected CardLayout2 getLayout() {
        CardLayout2 layout = this.ui.getContentLayout();
        return layout;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    protected void addMapping(String prefix, Class<?> klass, Class<? extends ContentUI<?>> contentClass) {
        this.addMapping(prefix, klass, null, contentClass);
    }

    protected void addMapping(String prefix, Class<?> klass, String context, Class<?> contentClass) {
        String key = this.getMappingKey(prefix, klass, context);
        this.mapping.put(key, contentClass);
    }

    protected String getMappingKey(String prefix, Class<?> klass, String context) {
        String key = prefix + ".";
        if (klass != null) {
            key = key + klass.getName();
        }
        if (context != null) {
            if (klass != null) {
                key = key + "#";
            }
            key = key + context;
        }
        return key;
    }
}

