/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree.actions;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeTripProgramActionListener
implements ActionListener {
    private static final Log log = LogFactory.getLog(ChangeTripProgramActionListener.class);
    private final String tripId;
    private final String programId;
    private final ObserveTreeHelper treeHelper;
    private final DataService dataService;
    private final DataSource dataSource;

    public ChangeTripProgramActionListener(ObserveTreeHelper treeHelper, DataService dataService, DataSource dataSource, String tripId, String programId) {
        this.tripId = tripId;
        this.programId = programId;
        this.treeHelper = treeHelper;
        this.dataService = dataService;
        this.dataSource = dataSource;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int position;
        ObserveNode tripNode = (ObserveNode)this.treeHelper.getSelectedNode();
        ObserveNode rootNode = (ObserveNode)this.treeHelper.getRootNode();
        ObserveNode newProgramNode = (ObserveNode)this.treeHelper.getChild((NavNode)rootNode, this.programId);
        ObserveNode oldProgramNode = (ObserveNode)this.treeHelper.getChild((NavNode)rootNode, ((ObserveNode)tripNode.getParent()).getId());
        try {
            this.dataService.moveTripToProgram(this.dataSource, this.tripId, this.programId);
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Can't change trip " + this.tripId + " to program " + this.programId, (Throwable)e);
        }
        try {
            position = this.dataService.getOpenablePosition(this.dataSource, this.programId, this.tripId);
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Can't get trip " + this.tripId + " position for program " + this.programId, (Throwable)e);
        }
        this.treeHelper.removeNode((NavNode)tripNode);
        ObserveNode newTripNode = (ObserveNode)this.treeHelper.getChild((NavNode)newProgramNode, this.tripId);
        if (newTripNode == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Insert trip node: ");
            }
            this.treeHelper.insertNode((NavNode)newProgramNode, (NavNode)tripNode, position);
            newTripNode = tripNode;
        }
        this.treeHelper.refreshNode((NavNode)oldProgramNode, true);
        this.treeHelper.refreshNode((NavNode)newProgramNode, true);
        this.treeHelper.selectNode((NavNode)newTripNode);
    }
}

