/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.Entities;
import fr.ird.observe.entities.EntityMap;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.Section;
import fr.ird.observe.entities.longline.SectionTemplate;
import fr.ird.observe.entities.longline.SectionWithTemplate;
import fr.ird.observe.entities.longline.SectionWithTemplates;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.longline.BasketsTableModel;
import fr.ird.observe.ui.content.impl.longline.BranchlineUI;
import fr.ird.observe.ui.content.impl.longline.BranchlineUIModel;
import fr.ird.observe.ui.content.impl.longline.BranchlinesTableModel;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUI;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIInitializer;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIModel;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIValidationHelper;
import fr.ird.observe.ui.content.impl.longline.SectionTemplatesTableModel;
import fr.ird.observe.ui.content.impl.longline.SectionsTableModel;
import fr.ird.observe.ui.util.JVetoableTabbedPane;
import fr.ird.observe.ui.util.table.EditableTableModelSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class LonglineDetailCompositionUIHandler
extends ContentUIHandler<SetLongline> {
    static final String SECTION_TEMPLATES_EDITOR = "sectionTemplatesEditor";
    private static Log log = LogFactory.getLog(LonglineDetailCompositionUIHandler.class);
    private final PropertyChangeListener sectionTemplatesTableModelModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Boolean newValue = (Boolean)evt.getNewValue();
            LonglineDetailCompositionUIHandler.this.onSectionTemplatesTableModelModified(newValue);
        }
    };
    private final PropertyChangeListener sectionsTableModelModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Boolean newValue = (Boolean)evt.getNewValue();
            LonglineDetailCompositionUIHandler.this.onSectionsTableModelModified(newValue);
        }
    };
    private final TableModelListener sectionsTableModelChanged = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            SectionsTableModel source = (SectionsTableModel)e.getSource();
            LonglineDetailCompositionUIHandler.this.onSectionsTableModelChanged(source.getData());
        }
    };
    private final PropertyChangeListener branchlineDetailSaved = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LonglineDetailCompositionUIHandler.this.getUi().getValidator().setChanged(true);
        }
    };
    private final PropertyChangeListener selectedSectionTemplateChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SectionTemplate newValue = (SectionTemplate)evt.getNewValue();
            LonglineDetailCompositionUIHandler.this.onSelectedSectionTemplateChanged(newValue);
        }
    };
    private final PropertyChangeListener basketsTableModelModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Boolean newValue = (Boolean)evt.getNewValue();
            LonglineDetailCompositionUIHandler.this.onBasketsTableModelModified(newValue);
        }
    };
    private final TableModelListener basketsTableModelChanged = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            BasketsTableModel source = (BasketsTableModel)e.getSource();
            LonglineDetailCompositionUIHandler.this.onBasketsTableModelChanged(source.getData());
        }
    };
    private final PropertyChangeListener branchinesTableModelModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LonglineDetailCompositionUIHandler.this.onBranchlinesTableModelModified((Boolean)evt.getNewValue());
        }
    };
    private final TableModelListener branchinesTableModelChanged = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            BranchlinesTableModel source = (BranchlinesTableModel)e.getSource();
            LonglineDetailCompositionUIHandler.this.onBranchlinesTableModelChanged(source.getData());
        }
    };
    private final PropertyChangeListener selectedBranchlineChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Branchline previousValue = (Branchline)evt.getOldValue();
            Branchline newValue = (Branchline)evt.getNewValue();
            LonglineDetailCompositionUIHandler.this.onSelectedBranchlineChanged(previousValue, newValue);
        }
    };
    private final ChangeListener tabbedPaneChanged = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            JVetoableTabbedPane source = (JVetoableTabbedPane)e.getSource();
            int previousIndex = source.getPreviousIndex();
            int selectedIndex = source.getSelectedIndex();
            LonglineDetailCompositionUIHandler.this.onTabChanged(previousIndex, selectedIndex);
        }
    };
    private Decorator<Section> sectionDecorator;
    private Decorator<Basket> basketDecorator;
    private Decorator<Branchline> branchlineDecorator;
    private boolean skipSavePreviousSelectedSection;
    private boolean skipSavePreviousSelectedBasket;
    private boolean skipSavePreviousSelectedBranchline;
    private boolean sectionAdjusting;
    private final PropertyChangeListener modelCanGenerateChanged = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LonglineDetailCompositionUIHandler.this.sectionAdjusting = true;
            try {
                Boolean newValue = (Boolean)evt.getNewValue();
                LonglineDetailCompositionUIHandler.this.onModelCanGenerateChanged(newValue);
            }
            finally {
                LonglineDetailCompositionUIHandler.this.sectionAdjusting = false;
            }
        }
    };
    private final PropertyChangeListener selectedSectionChanged = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LonglineDetailCompositionUIHandler.this.sectionAdjusting = true;
            try {
                Section previousValue = (Section)evt.getOldValue();
                Section newValue = (Section)evt.getNewValue();
                LonglineDetailCompositionUIHandler.this.onSelectedSectionChanged(previousValue, newValue);
            }
            finally {
                LonglineDetailCompositionUIHandler.this.sectionAdjusting = false;
            }
        }
    };
    private boolean basketAdjusting;
    private final PropertyChangeListener selectedBasketChanged = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LonglineDetailCompositionUIHandler.this.basketAdjusting = true;
            try {
                Basket previousValue = (Basket)evt.getOldValue();
                Basket newValue = (Basket)evt.getNewValue();
                LonglineDetailCompositionUIHandler.this.onSelectedBasketChanged(previousValue, newValue);
            }
            finally {
                LonglineDetailCompositionUIHandler.this.basketAdjusting = false;
            }
        }
    };
    private LonglineDetailCompositionUIValidationHelper validationHelper;
    private boolean onOpen;
    private JVetoableTabbedPane.ChangeSelectedIndex tabbedPaneWillChanged = new JVetoableTabbedPane.ChangeSelectedIndex(){

        @Override
        public boolean canChangeTab(int currentSelectedIndex, int newSelectedIndex) {
            return LonglineDetailCompositionUIHandler.this.onTabWillChanged(currentSelectedIndex, newSelectedIndex);
        }
    };

    public LonglineDetailCompositionUIHandler(LonglineDetailCompositionUI ui) {
        super(ui, DataContextType.ActivitySeine, DataContextType.SetLongline);
    }

    public LonglineDetailCompositionUI getUi() {
        return (LonglineDetailCompositionUI)super.getUi();
    }

    public LonglineDetailCompositionUIModel getModel() {
        return (LonglineDetailCompositionUIModel)super.getModel();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        ContentMode contentMode;
        if (dataContext.isSelectedOpen(ActivityLongline.class)) {
            contentMode = ContentMode.UPDATE;
        } else {
            LonglineDetailCompositionUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.activityLongline.message.not.open", (Object[])new Object[0]));
            contentMode = ContentMode.READ;
        }
        return contentMode;
    }

    @Override
    public void initUI() throws Exception {
        this.sectionDecorator = this.getDecoratorService().getDecoratorByType(Section.class);
        this.basketDecorator = this.getDecoratorService().getDecoratorByType(Basket.class);
        this.branchlineDecorator = this.getDecoratorService().getDecoratorByType(Branchline.class);
        LonglineDetailCompositionUIInitializer uiInitializer = new LonglineDetailCompositionUIInitializer(this.getUi());
        uiInitializer.initUI(this.getDataSource());
        LonglineDetailCompositionUI ui1 = this.getUi();
        this.validationHelper = new LonglineDetailCompositionUIValidationHelper(ui1, this.getDecoratorService());
        this.getBranchlineDetailUIModel().addPropertyChangeListener("saved", this.branchlineDetailSaved);
        EditableTableModelSupport tableModel = this.getSectionTemplatesTableModel();
        tableModel.addPropertyChangeListener("modified", this.sectionTemplatesTableModelModified);
        this.getModel().addPropertyChangeListener("canGenerate", this.modelCanGenerateChanged);
        tableModel = this.getSectionsTableModel();
        tableModel.addPropertyChangeListener("modified", this.sectionsTableModelModified);
        tableModel.addPropertyChangeListener("selectedRow", this.selectedSectionChanged);
        tableModel.addPropertyChangeListener("template", this.selectedSectionTemplateChanged);
        tableModel.addTableModelListener(this.sectionsTableModelChanged);
        tableModel = this.getBasketsTableModel();
        tableModel.addPropertyChangeListener("modified", this.basketsTableModelModified);
        tableModel.addPropertyChangeListener("selectedRow", this.selectedBasketChanged);
        tableModel.addTableModelListener(this.basketsTableModelChanged);
        tableModel = this.getBranchlinesTableModel();
        tableModel.addPropertyChangeListener("modified", this.branchinesTableModelModified);
        tableModel.addPropertyChangeListener("selectedRow", this.selectedBranchlineChanged);
        tableModel.addTableModelListener(this.branchinesTableModelChanged);
        JVetoableTabbedPane tabPane = ui1.getFishingOperationTabPane();
        tabPane.setChangeSelectedIndex(this.tabbedPaneWillChanged);
        tabPane.addChangeListener(this.tabbedPaneChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openUI() throws Exception {
        UIHelper.stopEditing((JTable)this.getUi().getSectionTemplatesTable());
        UIHelper.stopEditing((JTable)this.getUi().getSectionsTable());
        super.openUI();
        this.getLoadBinder();
        BranchlineUI branchlineDetailUI = this.getUi().getBranchlineDetailUI();
        branchlineDetailUI.open();
        String setId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("setId      = " + setId));
        }
        ContentMode mode = this.computeContentMode();
        DataService dataService = this.getDataService();
        DataSource source = this.getDataSource();
        dataService.loadEditEntity(source, setId, this.getLoadExecutor());
        this.setContentMode(mode);
        SetLongline bean = (SetLongline)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("Use as default branchline timer date: " + bean.getSettingStartTimeStamp()));
        }
        this.getBranchlinesTableModel().setDefaultDate(bean.getSettingStartTimeStamp());
        this.getBranchlinesTableModel().setUseTimer(BooleanUtils.isTrue((Boolean)bean.getMonitored()));
        this.getModel().setCanGenerate(bean.isSectionEmpty());
        this.getSectionTemplatesTableModel().setData(Collections.emptyList());
        BranchlineUI branchlineDetailUI2 = this.getUi().getBranchlineDetailUI();
        branchlineDetailUI2.edit(null);
        this.onOpen = true;
        try {
            List section = SectionWithTemplates.getSectionTemplates((Collection)bean.getSection());
            this.getSectionsTableModel().setData(section);
            this.validationHelper.setObjectValueAdjusting(true);
            try {
                this.onSectionTemplatesTableModelModified(false);
                this.onSectionsTableModelModified(false);
                this.onBasketsTableModelModified(false);
                this.onBranchlinesTableModelModified(false);
            }
            finally {
                this.validationHelper.setObjectValueAdjusting(false);
                this.validationHelper.whenSectionChanged();
            }
            this.getUi().getFishingOperationTabPane().setSelectedIndex(0);
        }
        finally {
            this.onOpen = false;
        }
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        LonglineDetailCompositionUIModel model = this.getModel();
        this.addInfoMessage(I18n.t((String)"observe.longlineDetailComposition.message.updating", (Object[])new Object[0]));
        super.startEditUI("generateAll.enabled", "deleteAll.enabled");
        model.setModified(false);
    }

    @Override
    protected boolean doSave(SetLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<SetLongline> binder) throws Exception {
        SectionsTableModel sectionsTableModel = this.getSectionsTableModel();
        SectionWithTemplate selectedSection = (SectionWithTemplate)sectionsTableModel.getSelectedRow();
        if (selectedSection != null) {
            this.flushSection((Section)selectedSection);
        }
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected SetLongline onUpdate(TopiaContext tx, Object parentBean, SetLongline beanToSave) throws TopiaException {
        Map existingSectionsByTopiaId = Entities.toIdMap((Collection)beanToSave.getSection());
        TopiaDAO sectionsDao = this.getDataSource().getDAO(tx, Section.class);
        TopiaDAO basketDao = this.getDataSource().getDAO(tx, Basket.class);
        TopiaDAO branchlineDao = this.getDataSource().getDAO(tx, Branchline.class);
        List sections = this.getSectionsTableModel().getNotEmptyData();
        beanToSave.clearSection();
        for (SectionWithTemplate section : sections) {
            Section sectionToSave = this.persistSection((TopiaDAO<Section>)sectionsDao, (TopiaDAO<Basket>)basketDao, (TopiaDAO<Branchline>)branchlineDao, existingSectionsByTopiaId, (Section)section);
            beanToSave.addSection(sectionToSave);
            sectionToSave.setSetLongline(beanToSave);
        }
        return beanToSave;
    }

    protected Section persistSection(TopiaDAO<Section> sectionsDao, TopiaDAO<Basket> basketDao, TopiaDAO<Branchline> branchlineDao, Map<String, Section> existingSectionsByTopiaId, Section section) throws TopiaException {
        Section sectionToSave = section.getTopiaId() == null ? (Section)sectionsDao.create(new Object[]{"settingIdentifier", section.getSettingIdentifier(), "haulingIdentifier", section.getHaulingIdentifier()}) : existingSectionsByTopiaId.get(section.getTopiaId());
        TopiaEntityBinder<Section> sectionBinder = this.getModel().getSectionBinder();
        sectionBinder.copyExcluding((Object)section, (Object)sectionToSave, new String[]{"basket"});
        Map existingBasketsByTopiaId = Entities.toIdMap((Collection)sectionToSave.getBasket());
        List baskets = section.getBasket();
        sectionToSave.clearBasket();
        for (Basket basket : baskets) {
            Basket basketToSave = this.persistBasket(basketDao, branchlineDao, existingBasketsByTopiaId, basket);
            sectionToSave.addBasket(basketToSave);
        }
        return sectionToSave;
    }

    protected Basket persistBasket(TopiaDAO<Basket> basketDao, TopiaDAO<Branchline> branchlineDao, Map<String, Basket> existingBasketsByTopiaId, Basket basket) throws TopiaException {
        Basket basketToSave = basket.getTopiaId() == null ? (Basket)basketDao.create(new Object[]{"settingIdentifier", basket.getSettingIdentifier(), "haulingIdentifier", basket.getHaulingIdentifier()}) : existingBasketsByTopiaId.get(basket.getTopiaId());
        TopiaEntityBinder<Basket> basketBinder = this.getModel().getBasketBinder();
        basketBinder.copyExcluding((Object)basket, (Object)basketToSave, new String[]{"branchline"});
        Map existingBranchlinesByTopiaId = Entities.toIdMap((Collection)basketToSave.getBranchline());
        basketToSave.clearBranchline();
        List branchlines = basket.getBranchline();
        for (Branchline branchline : branchlines) {
            Branchline branchlineToSave = this.persistBranchline(branchlineDao, existingBranchlinesByTopiaId, branchline);
            basketToSave.addBranchline(branchlineToSave);
        }
        return basketToSave;
    }

    protected Branchline persistBranchline(TopiaDAO<Branchline> branchlineDao, Map<String, Branchline> existingBranchlinesByTopiaId, Branchline branchline) throws TopiaException {
        Branchline branchlineToSave = branchline.getTopiaId() == null ? (Branchline)branchlineDao.create(new Object[]{"settingIdentifier", branchline.getSettingIdentifier(), "haulingIdentifier", branchline.getHaulingIdentifier()}) : existingBranchlinesByTopiaId.get(branchline.getTopiaId());
        TopiaEntityBinder<Branchline> branchlineBinder = this.getModel().getBranchlineBinder();
        branchlineBinder.copy((Object)branchline, (Object)branchlineToSave, new String[0]);
        return branchlineToSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAllSections() {
        boolean usingTemplate;
        boolean compiliantWithBasketCount;
        if (log.isInfoEnabled()) {
            log.info((Object)"Generate all sections.");
        }
        SetLongline bean = (SetLongline)this.getBean();
        Integer nbSections = bean.getTotalSectionsCount();
        Integer basketsCount = bean.getBasketsPerSectionCount();
        Integer nbBranchlines = bean.getBranchlinesPerBasketCount();
        SectionTemplate template = null;
        SectionTemplatesTableModel sectionTemplatesTableModel = this.getSectionTemplatesTableModel();
        List sectionTemplates = sectionTemplatesTableModel.getNotEmptyData();
        if (sectionTemplates.size() == 1 && !(compiliantWithBasketCount = (template = (SectionTemplate)sectionTemplates.get(0)).isCompiliantWithBasketCount(basketsCount.intValue()))) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("sectionTemplate " + template + " is not compliant with basketCount: " + basketsCount));
            }
            UIHelper.displayWarning(I18n.t((String)"observe.longlineDetailComposition.title.section.cant.use.firstTemplate", (Object[])new Object[0]), I18n.t((String)"observe.longlineDetailComposition.firstTemplate.template.notCompilant.basketCount", (Object[])new Object[]{template.getFloatlineLengths(), basketsCount}));
            template = null;
        }
        boolean bl = usingTemplate = template != null;
        if (usingTemplate && log.isInfoEnabled()) {
            log.info((Object)("Will use sectionTemplate: " + template));
        }
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            SectionsTableModel sectionsTableModel = this.getSectionsTableModel();
            BasketsTableModel basketsTableModel = this.getBasketsTableModel();
            BranchlinesTableModel branchlinesTableModel = this.getBranchlinesTableModel();
            ArrayList<SectionWithTemplate> sections = new ArrayList<SectionWithTemplate>(nbSections);
            for (int sectionNumber = 0; sectionNumber < nbSections; ++sectionNumber) {
                SectionWithTemplate section = sectionsTableModel.createNewRow();
                sections.add(section);
                for (int basketNumber = 0; basketNumber < basketsCount; ++basketNumber) {
                    Basket basket = basketsTableModel.createNewRow();
                    section.addBasket(basket);
                    for (int branchlineNumber = 0; branchlineNumber < nbBranchlines; ++branchlineNumber) {
                        Branchline branchline = branchlinesTableModel.createNewRow();
                        basket.addBranchline(branchline);
                    }
                    branchlinesTableModel.rearrangeIds(basket.getBranchline());
                }
                List baskets = section.getBasket();
                basketsTableModel.rearrangeIds(baskets);
                if (!usingTemplate) continue;
                section.setSectionTemplate(template);
                template.applyToBaskets(baskets);
            }
            sectionsTableModel.rearrangeIds(sections);
            sectionsTableModel.setData(sections);
            this.getModel().setModified(true);
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenSectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSections() {
        if (this.getSectionsTableModel().isEmpty()) {
            return;
        }
        boolean canDelete = true;
        for (SectionWithTemplate sectionWithTemplate : this.getSectionsTableModel().getNotEmptyData()) {
            if (this.canDeleteSection(sectionWithTemplate.getDelegate())) continue;
            canDelete = false;
            break;
        }
        if (!canDelete) {
            UIHelper.displayWarning(I18n.t((String)"observe.section.cant.delete.title", (Object[])new Object[0]), I18n.t((String)"observe.section.cant.delete.message", (Object[])new Object[0]));
            return;
        }
        ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
        int response = UIHelper.askUser(mainUI, I18n.t((String)"observe.title.delete", (Object[])new Object[0]), I18n.t((String)"observe.sections.delete.message", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
        if (response != 0) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Remove all sections.");
        }
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            this.getSectionsTableModel().setData(Collections.emptyList());
            this.getModel().setModified(true);
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenSectionChanged();
        }
    }

    public void deleteSelectedSectionTemplate() {
        SectionTemplatesTableModel tableModel = this.getSectionTemplatesTableModel();
        boolean selectionEmpty = tableModel.isSelectionEmpty();
        if (!selectionEmpty) {
            SectionTemplate data = (SectionTemplate)this.getSectionTemplatesTableModel().getSelectedRow();
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete: " + data));
            }
            ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
            int response = UIHelper.askUser(mainUI, I18n.t((String)"observe.title.delete", (Object[])new Object[0]), I18n.t((String)"observe.sectionTemplate.delete.message", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
            if (response != 0) {
                return;
            }
            this.getSectionTemplatesTableModel().removeSelectedRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedSection() {
        SectionsTableModel tableModel = this.getSectionsTableModel();
        boolean selectionEmpty = tableModel.isSelectionEmpty();
        if (!selectionEmpty) {
            SectionWithTemplate selectedSection = (SectionWithTemplate)tableModel.getSelectedRow();
            boolean canDelete = this.canDeleteSection(selectedSection.getDelegate());
            if (!canDelete) {
                UIHelper.displayWarning(I18n.t((String)"observe.section.cant.delete.title", (Object[])new Object[0]), I18n.t((String)"observe.section.cant.delete.message", (Object[])new Object[0]));
                return;
            }
            boolean accept = UIHelper.confirmForEntityDelete(this.ui, Section.class, selectedSection);
            ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
            mainUI.setBusy(false);
            if (!accept) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete section: " + this.sectionDecorator.toString((Object)selectedSection)));
            }
            this.validationHelper.setObjectValueAdjusting(true);
            this.skipSavePreviousSelectedSection = true;
            try {
                tableModel.removeSelectedRow();
            }
            finally {
                this.skipSavePreviousSelectedSection = false;
                this.validationHelper.setObjectValueAdjusting(false);
                this.validationHelper.whenSectionChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBeforeSelectedSection() {
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            SectionsTableModel tableModel = this.getSectionsTableModel();
            tableModel.insertBeforeSelectedRow();
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenSectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfterSelectedSection() {
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            SectionsTableModel tableModel = this.getSectionsTableModel();
            tableModel.insertAfterSelectedRow();
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenSectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedBasket() {
        boolean selectionNotEmpty;
        BasketsTableModel tableModel = this.getBasketsTableModel();
        boolean bl = selectionNotEmpty = !tableModel.isSelectionEmpty();
        if (selectionNotEmpty) {
            Basket selectedBasket = (Basket)tableModel.getSelectedRow();
            boolean canDelete = this.canDeleteBasket(selectedBasket);
            if (!canDelete) {
                UIHelper.displayWarning(I18n.t((String)"observe.basket.cant.delete.title", (Object[])new Object[0]), I18n.t((String)"observe.basket.cant.delete.message", (Object[])new Object[0]));
                return;
            }
            boolean accept = UIHelper.confirmForEntityDelete(this.ui, Basket.class, selectedBasket);
            ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
            mainUI.setBusy(false);
            if (!accept) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete basket: " + this.basketDecorator.toString((Object)selectedBasket)));
            }
            this.validationHelper.setObjectValueAdjusting(true);
            this.skipSavePreviousSelectedBasket = true;
            try {
                ((SectionWithTemplate)this.getSectionsTableModel().getSelectedRow()).removeBasket(selectedBasket);
                tableModel.removeSelectedRow();
            }
            finally {
                this.skipSavePreviousSelectedBasket = false;
                this.validationHelper.setObjectValueAdjusting(false);
                this.validationHelper.whenBasketChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBeforeSelectedBasket() {
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            BasketsTableModel tableModel = this.getBasketsTableModel();
            tableModel.insertBeforeSelectedRow();
            Basket newBasket = (Basket)tableModel.getSelectedRow();
            int selectedRowIndex = tableModel.getSelectedRowIndex();
            SectionWithTemplate selectedSection = (SectionWithTemplate)this.getSectionsTableModel().getSelectedRow();
            if (selectedSection.isBasketEmpty()) {
                selectedSection.setBasket(new ArrayList());
            }
            selectedSection.getBasket().add(selectedRowIndex, newBasket);
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenBasketChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfterSelectedBasket() {
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            BasketsTableModel tableModel = this.getBasketsTableModel();
            tableModel.insertAfterSelectedRow();
            Basket newBasket = (Basket)tableModel.getSelectedRow();
            int selectedRowIndex = tableModel.getSelectedRowIndex();
            SectionWithTemplate selectedSection = (SectionWithTemplate)this.getSectionsTableModel().getSelectedRow();
            if (selectedSection.isBasketEmpty()) {
                selectedSection.setBasket(new ArrayList());
            }
            ((SectionWithTemplate)this.getSectionsTableModel().getSelectedRow()).getBasket().add(selectedRowIndex, newBasket);
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenBasketChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedBranchline() {
        boolean selectionNotEmpty;
        BranchlinesTableModel tableModel = this.getBranchlinesTableModel();
        boolean bl = selectionNotEmpty = !tableModel.isSelectionEmpty();
        if (selectionNotEmpty) {
            Branchline selectedBranchline = (Branchline)tableModel.getSelectedRow();
            boolean canDelete = this.canDeleteBranchline(selectedBranchline);
            if (!canDelete) {
                UIHelper.displayWarning(I18n.t((String)"observe.branchLine.cant.delete.title", (Object[])new Object[0]), I18n.t((String)"observe.branchLine.cant.delete.message", (Object[])new Object[0]));
                return;
            }
            boolean accept = UIHelper.confirmForEntityDelete(this.ui, Branchline.class, selectedBranchline);
            ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
            mainUI.setBusy(false);
            if (!accept) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete branchline: " + this.branchlineDecorator.toString((Object)selectedBranchline)));
            }
            this.validationHelper.setObjectValueAdjusting(true);
            this.skipSavePreviousSelectedBranchline = true;
            try {
                ((Basket)this.getBasketsTableModel().getSelectedRow()).removeBranchline(selectedBranchline);
                tableModel.removeSelectedRow();
            }
            finally {
                this.skipSavePreviousSelectedBranchline = false;
                this.validationHelper.setObjectValueAdjusting(false);
                this.validationHelper.whenBranchlineChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBeforeSelectedBranchline() {
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            BranchlinesTableModel tableModel = this.getBranchlinesTableModel();
            tableModel.insertBeforeSelectedRow();
            Branchline newBranchline = (Branchline)tableModel.getSelectedRow();
            int selectedRowIndex = tableModel.getSelectedRowIndex();
            Basket selectedBasket = (Basket)this.getBasketsTableModel().getSelectedRow();
            if (selectedBasket.isBranchlineEmpty()) {
                selectedBasket.setBranchline(new ArrayList());
            }
            selectedBasket.getBranchline().add(selectedRowIndex, newBranchline);
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenBasketChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfterSelectedBranchline() {
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            BranchlinesTableModel tableModel = this.getBranchlinesTableModel();
            tableModel.insertAfterSelectedRow();
            Branchline newBranchline = (Branchline)tableModel.getSelectedRow();
            int selectedRowIndex = tableModel.getSelectedRowIndex();
            Basket selectedBasket = (Basket)this.getBasketsTableModel().getSelectedRow();
            if (selectedBasket.isBranchlineEmpty()) {
                selectedBasket.setBranchline(new ArrayList());
            }
            selectedBasket.getBranchline().add(selectedRowIndex, newBranchline);
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
            this.validationHelper.whenBasketChanged();
        }
    }

    protected void onSectionTemplatesTableModelModified(Boolean newValue) {
        this.getSectionTemplatesTableModel().validate();
    }

    protected void onSectionsTableModelModified(Boolean newValue) {
        if (newValue.booleanValue()) {
            this.getModel().setModified(true);
        }
        this.validationHelper.whenSectionChanged();
    }

    protected void onSectionsTableModelChanged(List<SectionWithTemplate> data) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Sections was changed, new size: " + data.size()));
        }
        this.validationHelper.whenSectionChanged();
    }

    protected void onModelCanGenerateChanged(Boolean canGenerate) {
        if (canGenerate.booleanValue() && this.getSectionTemplatesTableModel().isEmpty()) {
            this.getSectionTemplatesTableModel().addNewRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSelectedSectionChanged(Section previousSection, Section newSection) {
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected section: " + this.sectionDecorator.toString((Object)newSection)));
        }
        this.validationHelper.setObjectValueAdjusting(true);
        try {
            List baskets;
            if (previousSection != null && !this.onOpen && !this.skipSavePreviousSelectedSection) {
                this.flushSection(previousSection);
            }
            List list = baskets = newSection == null ? null : newSection.getBasket();
            if (baskets == null) {
                baskets = Collections.emptyList();
            }
            this.getBasketsTableModel().setData(baskets);
        }
        finally {
            this.validationHelper.setObjectValueAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSelectedSectionTemplateChanged(SectionTemplate newTemplate) {
        if (newTemplate != null) {
            SectionWithTemplate selectedSection = (SectionWithTemplate)this.getSectionsTableModel().getSelectedRow();
            if (log.isInfoEnabled()) {
                log.info((Object)("Will apply template: " + newTemplate + " to section: " + this.sectionDecorator.toString((Object)selectedSection)));
            }
            this.validationHelper.setObjectValueAdjusting(true);
            try {
                this.getBasketsTableModel().applySectionTemplate(newTemplate);
            }
            finally {
                this.validationHelper.setObjectValueAdjusting(false);
                this.validationHelper.whenSectionChanged();
            }
        }
    }

    protected void onBasketsTableModelModified(Boolean newValue) {
        if (newValue.booleanValue()) {
            this.getModel().setModified(true);
        }
        this.validationHelper.whenBasketChanged();
    }

    protected void onBasketsTableModelChanged(List<Basket> data) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Baskets was changed, new size: " + data.size()));
        }
    }

    protected void onSelectedBasketChanged(Basket previousBasket, Basket newBasket) {
        List branchlines;
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected basket: " + this.basketDecorator.toString((Object)newBasket)));
        }
        if (previousBasket != null && !this.sectionAdjusting && !this.skipSavePreviousSelectedBasket) {
            this.flushBasket(previousBasket);
        }
        List list = branchlines = newBasket == null ? null : newBasket.getBranchline();
        if (branchlines == null) {
            branchlines = Collections.emptyList();
        }
        this.getBranchlinesTableModel().setData(branchlines);
    }

    protected void onBranchlinesTableModelModified(Boolean newValue) {
        if (newValue.booleanValue()) {
            this.getModel().setModified(true);
        }
        this.validationHelper.whenBranchlineChanged();
    }

    protected void onBranchlinesTableModelChanged(List<Branchline> data) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Branchlines was changed, new size: " + data.size()));
        }
    }

    protected void onSelectedBranchlineChanged(Branchline previousBranchline, Branchline newBranchline) {
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected branchline: " + this.branchlineDecorator.toString((Object)newBranchline)));
        }
        if (previousBranchline != null && !this.basketAdjusting && !this.skipSavePreviousSelectedBranchline) {
            this.flushBranchline(previousBranchline);
        }
    }

    protected boolean onTabWillChanged(int selectedIndex, int index) {
        boolean result = true;
        if (!this.onOpen && index > -1) {
            switch (selectedIndex) {
                case 0: {
                    boolean generateTabValid;
                    result = generateTabValid = this.getModel().isGenerateTabValid();
                    break;
                }
                case 1: {
                    boolean compositionTabValid;
                    result = compositionTabValid = this.getModel().isCompositionTabValid();
                    break;
                }
                case 2: {
                    boolean branchlineDetailTabValid;
                    result = branchlineDetailTabValid = this.getUi().getBranchlineDetailUI().getHandler().tryToQuit();
                }
            }
        }
        return result;
    }

    protected void onTabChanged(int previousIndex, int selectedIndex) {
        switch (previousIndex) {
            case 0: {
                UIHelper.stopEditing((JTable)this.getUi().getSectionTemplatesTable());
                break;
            }
            case 1: {
                UIHelper.stopEditing((JTable)this.getUi().getSectionsTable());
                break;
            }
            case 2: {
                BranchlineUI branchlineDetailUI = this.getUi().getBranchlineDetailUI();
                branchlineDetailUI.edit(null);
            }
        }
        switch (selectedIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (previousIndex != 0 || !this.getModel().isCanGenerate()) break;
                List sectionTemplates = this.getSectionTemplatesTableModel().getNotEmptyData();
                JComboBox comboBox = (JComboBox)this.getUi().getSectionsTable().getClientProperty((Object)SECTION_TEMPLATES_EDITOR);
                LonglineDetailCompositionUIInitializer.prepareComboBoxData(comboBox, sectionTemplates);
                break;
            }
            case 2: {
                Branchline branchline = (Branchline)this.getBranchlinesTableModel().getSelectedRow();
                if (branchline == null) break;
                BranchlineUI branchlineDetailUI = this.getUi().getBranchlineDetailUI();
                branchlineDetailUI.edit(branchline);
            }
        }
    }

    protected void flushSection(Section section) {
        BasketsTableModel basketsTableModel = this.getBasketsTableModel();
        if (!basketsTableModel.isSelectionEmpty()) {
            Basket selectedBasket = (Basket)basketsTableModel.getSelectedRow();
            this.flushBasket(selectedBasket);
        }
        List baskets = basketsTableModel.getNotEmptyData();
        section.setBasket(baskets);
        if (log.isInfoEnabled()) {
            log.info((Object)("Flush baskets (" + baskets.size() + ") to his section: " + this.sectionDecorator.toString((Object)section)));
        }
    }

    protected void flushBasket(Basket basket) {
        BranchlinesTableModel branchlinesTableModel = this.getBranchlinesTableModel();
        if (!branchlinesTableModel.isSelectionEmpty()) {
            this.flushBranchline((Branchline)branchlinesTableModel.getSelectedRow());
        }
        List branchlines = branchlinesTableModel.getNotEmptyData();
        basket.setBranchline(branchlines);
        if (log.isInfoEnabled()) {
            log.info((Object)("Flush branchlines (" + branchlines.size() + ") to his basket: " + this.basketDecorator.toString((Object)basket)));
        }
    }

    protected void flushBranchline(Branchline branchline) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Flush branchline details: " + this.branchlineDecorator.toString((Object)branchline)));
        }
    }

    protected SectionTemplatesTableModel getSectionTemplatesTableModel() {
        return this.getModel().getSectionTemplatesTableModel();
    }

    protected SectionsTableModel getSectionsTableModel() {
        return this.getModel().getSectionsTableModel();
    }

    protected BasketsTableModel getBasketsTableModel() {
        return this.getModel().getBasketsTableModel();
    }

    protected BranchlinesTableModel getBranchlinesTableModel() {
        return this.getModel().getBranchlinesTableModel();
    }

    public BranchlineUIModel getBranchlineDetailUIModel() {
        return this.getUi().getBranchlineDetailUIModel();
    }

    protected boolean canDeleteSection(Section section) {
        boolean canDelete;
        block5: {
            canDelete = true;
            if (section.getTopiaId() != null) {
                try {
                    EntityMap allUsages = this.getDataService().findAllUsages(this.getDataSource(), (TopiaEntity)section);
                    allUsages.remove(SetLongline.class);
                    if (!allUsages.isEmpty()) {
                        canDelete = false;
                        break block5;
                    }
                    if (section.isBasketEmpty()) break block5;
                    for (Basket basket : section.getBasket()) {
                        if (this.canDeleteBasket(basket)) continue;
                        canDelete = false;
                        break;
                    }
                }
                catch (DataSourceException e) {
                    throw new ObserveTechnicalException("Could not find all usage of selected section", (Throwable)e);
                }
            }
        }
        return canDelete;
    }

    protected boolean canDeleteBasket(Basket basket) {
        boolean canDelete;
        block5: {
            canDelete = true;
            if (basket.getTopiaId() != null) {
                try {
                    EntityMap allUsages = this.getDataService().findAllUsages(this.getDataSource(), (TopiaEntity)basket);
                    allUsages.remove(Section.class);
                    if (!allUsages.isEmpty()) {
                        canDelete = false;
                        break block5;
                    }
                    if (basket.isBranchlineEmpty()) break block5;
                    for (Branchline branchline : basket.getBranchline()) {
                        if (this.canDeleteBranchline(branchline)) continue;
                        canDelete = false;
                        break;
                    }
                }
                catch (DataSourceException e) {
                    throw new ObserveTechnicalException("Could not find all usage of selected section", (Throwable)e);
                }
            }
        }
        return canDelete;
    }

    protected boolean canDeleteBranchline(Branchline branchline) {
        boolean canDelete = true;
        if (branchline.getTopiaId() != null) {
            try {
                EntityMap allUsages = this.getDataService().findAllUsages(this.getDataSource(), (TopiaEntity)branchline);
                allUsages.remove(Basket.class);
                if (!allUsages.isEmpty()) {
                    canDelete = false;
                }
            }
            catch (DataSourceException e) {
                throw new ObserveTechnicalException("Could not find all usage of selected branchline", (Throwable)e);
            }
        }
        return canDelete;
    }
}

