/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSource;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.util.PGInstall;
import fr.ird.observe.ui.storage.RemoteUILauncher;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.Window;
import java.io.File;
import java.net.URL;
import java.sql.SQLException;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public enum ObstunaAdminAction {
    CREATE(I18n.n_((String)"observe.obstuna.action.create", (Object[])new Object[0]), I18n.n_((String)"observe.obstuna.action.create.description", (Object[])new Object[0]), null){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel(), (Object[])new Object[0])){

                @Override
                protected void init(StorageUI ui) {
                    StorageUIModel model = ui.getModel();
                    model.getPgConfig().setCreationMode(CreationMode.IMPORT_REMOTE_STORAGE);
                    model.getPgConfig().setCanMigrate(true);
                    super.init(ui);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void checkImportDbVersion(StorageUIModel model, DataSource importDatasource) throws DataSourceException {
                    try {
                        importDatasource.doOpen();
                        Version importServiceDbVersion = importDatasource.getDbVersion();
                        Version currentDbVersion = model.getDbVersion();
                        if (importServiceDbVersion.before(currentDbVersion)) {
                            throw new IllegalStateException("Import db version (" + importServiceDbVersion + ") is not compatible with the current database version (" + currentDbVersion + ")");
                        }
                    }
                    finally {
                        importDatasource.doClose(false);
                    }
                }

                @Override
                protected void initTask(StorageUIModel model, PGInstall task) throws Exception {
                    PGDataSourceConfig importConfig = null;
                    switch (model.getReferentielImportMode()) {
                        case IMPORT_EXTERNAL_DUMP: {
                            model.getPgConfig().setCreationMode(CreationMode.IMPORT_EXTERNAL_DUMP);
                            File tempDirectory = FileUtil.createTempDirectory((String)"obstunaReferentielImport", (String)"");
                            importConfig = DataSourceFactory.newH2ConfigFromDump((String)"Import referentiel", (File)tempDirectory, (URL)model.getCentralSourceModel().toH2StorageConfig("Import referentiel").getDbDump(), (String)"sa", (char[])new char[]{'s', 'a'}, (boolean)false);
                            H2DataSource h2DataSource = DataSourceFactory.newService((H2DataSourceConfig)((H2DataSourceConfig)importConfig));
                            this.checkImportDbVersion(model, (DataSource)h2DataSource);
                            model.getPgConfig().setImportConfig((DataSourceConfig)importConfig);
                            break;
                        }
                        case IMPORT_REMOTE_STORAGE: {
                            model.getPgConfig().setCreationMode(CreationMode.IMPORT_REMOTE_STORAGE);
                            importConfig = model.getCentralSourceModel().getPgConfig();
                            PGDataSource pgDataSource = DataSourceFactory.newService((PGDataSourceConfig)importConfig);
                            this.checkImportDbVersion(model, (DataSource)pgDataSource);
                            break;
                        }
                        default: {
                            model.getPgConfig().setCreationMode(CreationMode.EMPTY);
                        }
                    }
                    if (importConfig != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Use referentiel import data source " + importConfig.getLabel()));
                        }
                        importConfig.setCanMigrate(false);
                    }
                    model.getPgConfig().setCanMigrate(false);
                    super.initTask(model, task);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute(PGInstall task) throws Exception {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Create db...");
                    }
                    task.dropDb();
                    PGDataSourceConfig config = task.getDataSourceConfig();
                    PGDataSource service = DataSourceFactory.newService((PGDataSourceConfig)config);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Open [" + service.getLabel() + "] and create it."));
                    }
                    try {
                        service.doOpen();
                    }
                    finally {
                        service.doClose(false);
                    }
                }

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Apply security...");
                    }
                    task.applySecurity();
                }
            };
        }
    }
    ,
    UPDATE(I18n.n_((String)"observe.obstuna.action.update", (Object[])new Object[0]), I18n.n_((String)"observe.obstuna.action.update.description", (Object[])new Object[0]), VersionUtil.valueOf((String)"1.0")){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel(), (Object[])new Object[0])){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute(PGInstall task) throws Exception {
                    PGDataSourceConfig config = task.getDataSourceConfig();
                    PGDataSource service = DataSourceFactory.newService((PGDataSourceConfig)config);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Open [" + service.getLabel() + "] and update it."));
                    }
                    try {
                        service.doOpen();
                    }
                    finally {
                        service.doClose(false);
                    }
                }

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Apply security...");
                    }
                    task.applySecurity();
                }
            };
        }
    }
    ,
    SECURITY(I18n.n_((String)"observe.obstuna.action.security", (Object[])new Object[0]), I18n.n_((String)"observe.obstuna.action.security.description", (Object[])new Object[0]), VersionUtil.valueOf((String)"1.4")){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel(), (Object[])new Object[0])){

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Apply security...");
                    }
                    task.applySecurity();
                }
            };
        }
    }
    ,
    DROP(I18n.n_((String)"observe.obstuna.action.drop", (Object[])new Object[0]), I18n.n_((String)"observe.obstuna.action.drop.description", (Object[])new Object[0]), null){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n._((String)this.getLabel(), (Object[])new Object[0])){

                @Override
                protected void execute(PGInstall task) throws Exception {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Drop db...");
                    }
                    task.dropDb();
                }
            };
        }
    };

    private static Log log;
    private final String label;
    private final String description;
    private final Version requiredVersion;

    private ObstunaAdminAction(String label, String description, Version requiredVersion) {
        this.label = label;
        this.description = description;
        this.requiredVersion = requiredVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getRequiredVersion() {
        return this.requiredVersion;
    }

    public static ObstunaAdminAction valueOfIgnoreCase(String value) {
        for (ObstunaAdminAction step : ObstunaAdminAction.values()) {
            if (!step.name().equalsIgnoreCase(value)) continue;
            return step;
        }
        return null;
    }

    public abstract RemoteUILauncher newLauncher(JAXXContext var1, Window var2);

    static {
        log = LogFactory.getLog(ObstunaAdminAction.class);
    }
}

