/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.constants.SexeEnum;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableMeta;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.EchantillonFauneUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.validator.NuitonValidatorScope;

public class EchantillonFauneUIHandler
extends ContentTableUIHandler<EchantillonFaune, TailleFaune> {
    private static Log log = LogFactory.getLog(EchantillonFauneUIHandler.class);
    JAXXContextEntryDef<List<EspeceFaune>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");

    public static ContentTableUIModel<EchantillonFaune, TailleFaune> newModel(EchantillonFauneUI ui) {
        return new ContentTableUIModel<EchantillonFaune, TailleFaune>(EchantillonFaune.class, TailleFaune.class, new String[]{"tailleFaune", "commentaire"}, new String[]{"espece", "longueur", "longueurCalcule", "poids", "poidsCalcule", "sexe", "referencePhoto"}, ui, ContentTableModel.newTableMeta(TailleFaune.class, "espece", false), ContentTableModel.newTableMeta(TailleFaune.class, "longueur", false), ContentTableModel.newTableMeta(TailleFaune.class, "poids", false), new ContentTableMeta<TailleFaune>(TailleFaune.class, "sexe", false){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNullValue(ContentTableModel<?, ?> m, TailleFaune bean, int row) {
                return bean.getSexe() == -1;
            }
        }, ContentTableModel.newTableMeta(TailleFaune.class, "referencePhoto", false));
    }

    public EchantillonFauneUIHandler(EchantillonFauneUI ui) {
        super(ui);
    }

    @Override
    public EchantillonFauneUI getUi() {
        return (EchantillonFauneUI)super.getUi();
    }

    @Override
    protected EchantillonFaune loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String caleeId = dataContext.getSelectedCaleeId();
        List especes = mode == ContentMode.UPDATE ? dataService.getAvailableEspeceForEchantillonFaune(dataSource, caleeId) : new ArrayList();
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), especes);
        String id = dataService.getEchantillonFauneId(dataSource, caleeId);
        EchantillonFaune editBean = (EchantillonFaune)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + " - calee id             : " + caleeId));
            log.info((Object)(this.prefix + " - echantillon faune id : " + id));
            log.info((Object)(this.prefix + " - edit bean id         : " + editBean.getTopiaId()));
        }
        if (id == null) {
            this.getLoadBinder().load(null, (TopiaEntity)editBean, true, new String[0]);
            this.getChildsUpdator().setChilds((TopiaEntity)editBean, new ArrayList());
        } else {
            dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
        }
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected boolean prepareSave(EchantillonFaune bean, List<TailleFaune> objets) throws DataSourceException {
        if (bean.getTopiaId() == null) {
            String caleeId = this.getDataContext().getSelectedCaleeId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create echantillon faune " + bean + " for " + caleeId));
            }
            this.getDataService().create(this.getDataSource(), caleeId, (TopiaEntity)bean, null, this.getCreateExecutor());
        }
        return true;
    }

    @Override
    protected EchantillonFaune onCreate(TopiaContext tx, Object parent, EchantillonFaune editBean) throws TopiaException {
        Calee parentBean = (Calee)parent;
        EchantillonFaune beanToSave = (EchantillonFaune)ObserveDAOHelper.getEchantillonFauneDAO((TopiaContext)tx).create(new Object[0]);
        if (log.isInfoEnabled()) {
            log.info((Object)("Echantillon faune " + beanToSave.getTopiaId() + " was created."));
        }
        editBean.setTopiaId(beanToSave.getTopiaId());
        editBean.setTopiaCreateDate(beanToSave.getTopiaCreateDate());
        editBean.setTopiaVersion(beanToSave.getTopiaVersion());
        parentBean.addEchantillonFaune(beanToSave);
        return beanToSave;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean canUse;
        ContentMode mode;
        block4: {
            mode = super.getContentMode(dataContext);
            if (mode != ContentMode.UPDATE) {
                return mode;
            }
            canUse = false;
            try {
                String caleeId = this.getDataContext().getSelectedCaleeId();
                canUse = this.getDataService().canUseEchantillonFaune(this.getDataSource(), caleeId);
            }
            catch (DataSourceException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)e);
            }
        }
        if (!canUse) {
            mode = ContentMode.READ;
            EchantillonFauneUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(Calee.class), I18n._((String)"observe.message.calee.no.rejetFaune", (Object[])new Object[0]));
        }
        return mode;
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TailleFaune bean, boolean create) {
        BeanComboBox<EspeceFaune> requestFocus;
        List<EspeceFaune> availableEspeces;
        EspeceFaune espece = bean == null ? null : bean.getEspece();
        EchantillonFauneUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected espece " + espece));
        }
        if (create) {
            availableEspeces = new ArrayList<EspeceFaune>((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            requestFocus = ui.getEspece();
        } else {
            availableEspeces = Arrays.asList(espece);
            requestFocus = ui.getLongueur();
        }
        ui.getEspece().setData(availableEspeces);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonFaune.especeFaune", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.especeFaune.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.longueur", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.longueur.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.poidsIndividuel", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.poidsIndividuel.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.sexe", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.sexe.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, SexeEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)renderer);
    }
}

