/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.util.TopiaExecutor;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureThon;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.referentiel.CategoriePoids;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.CaptureThonUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class CaptureThonUIHandler
extends ContentTableUIHandler<Calee, CaptureThon> {
    private static final Log log = LogFactory.getLog(CaptureThonUIHandler.class);
    JAXXContextEntryDef<List<TailleThon>> ALL_TAILLES_TO_DELETE_ENTRY = UIHelper.newListContextEntryDef((String)"all-taille-to-delete");
    JAXXContextEntryDef<List<EspeceThon>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");
    JAXXContextEntryDef<List<CategoriePoids>> ALL_CATEGORIES_ENTRY = UIHelper.newListContextEntryDef((String)"all-categories");
    TopiaExecutor<CategoriePoids> categoriePoidsTopiaExecutor = new TopiaExecutor<CategoriePoids>(){

        public void execute(TopiaContext tx, CategoriePoids bean) {
            CaptureThonUIHandler.this.getDecoratorService().decorate((Object)bean.getEspece());
        }
    };

    public static ContentTableUIModel<Calee, CaptureThon> newModel(CaptureThonUI ui) {
        return new ContentTableUIModel<Calee, CaptureThon>(Calee.class, CaptureThon.class, new String[]{"captureThon"}, new String[]{"calee", "categoriePoids", "poids", "cuve", "surLePont", "rejete", "commentaire"}, ui, ContentTableModel.newTableMeta(CaptureThon.class, "espece", true), ContentTableModel.newTableMeta(CaptureThon.class, "categoriePoids", true), ContentTableModel.newTableMeta(CaptureThon.class, "cuve", false), ContentTableModel.newTableMeta(CaptureThon.class, "poids", false), ContentTableModel.newTableMeta(CaptureThon.class, "commentaire", false));
    }

    public CaptureThonUIHandler(CaptureThonUI ui) {
        super(ui);
    }

    @Override
    public CaptureThonUI getUi() {
        return (CaptureThonUI)super.getUi();
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        this.getUi().getEspece().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = CaptureThonUIHandler.this.getTableModel();
                if (((CaptureThon)model.getRowBean()).getTopiaId() == null) {
                    EspeceThon espece = (EspeceThon)evt.getNewValue();
                    CaptureThonUIHandler.this.onEspeceChanged(espece);
                }
            }
        });
    }

    @Override
    protected Calee loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        ArrayList especeList;
        ArrayList categorieList;
        if (mode == ContentMode.UPDATE) {
            HashSet<EspeceThon> availableEspeces = new HashSet<EspeceThon>();
            categorieList = new ArrayList(dataService.loadDecoratedEntities(dataSource, CategoriePoids.class, this.categoriePoidsTopiaExecutor));
            UIHelper.filterReferentielList(categorieList, null);
            for (CategoriePoids c : categorieList) {
                availableEspeces.add(c.getEspece());
            }
            especeList = new ArrayList(availableEspeces);
            UIHelper.filterReferentielList(especeList, null);
        } else {
            especeList = new ArrayList();
            categorieList = new ArrayList();
        }
        CaptureThonUI ui = this.getUi();
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)ui, especeList);
        this.ALL_CATEGORIES_ENTRY.setContextValue((JAXXContext)ui, categorieList);
        ui.getEspece().setData(especeList);
        return (Calee)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected Collection<CaptureThon> loadChilds(TopiaContext tx, Calee bean) throws TopiaException {
        Collection childs = this.getChildsUpdator().getChilds((TopiaEntity)bean);
        ArrayList<CaptureThon> data = new ArrayList<CaptureThon>();
        if (CollectionUtils.isNotEmpty((Collection)childs)) {
            TopiaDAO dao = this.getDataSource().getDAO(tx, this.getTableEditBean());
            TopiaEntityBinder childLoador = this.getChildLoador();
            DecoratorService decoratorService = this.getDecoratorService();
            for (CaptureThon c : childs) {
                if (c.isRejete()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("rejetThon " + c.getEspece().getLibelle2() + " non retenu."));
                    continue;
                }
                try {
                    CaptureThon c2 = (CaptureThon)((ContentTableUIModel)this.getModel()).newTableEditBean();
                    CaptureThon safeC = (CaptureThon)dao.findByTopiaId(c.getTopiaId());
                    CategoriePoids categoriePoids = safeC.getCategoriePoids();
                    if (categoriePoids != null) {
                        EspeceThon espece = categoriePoids.getEspece();
                        decoratorService.decorate((Object)espece);
                    }
                    childLoador.load((TopiaEntity)safeC, (TopiaEntity)c2, true, new String[0]);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    @Override
    protected boolean prepareSave(Calee bean, List<CaptureThon> objets) throws DataSourceException {
        HashSet<EspeceThon> especesUsed = new HashSet<EspeceThon>();
        for (CaptureThon c : objets) {
            especesUsed.add(c.getEspece());
        }
        ArrayList tailleToDelete = new ArrayList();
        HashSet especesToDelete = new HashSet();
        this.getDataService().getObsoleteEspeceForEchantillonThon(this.getDataSource(), bean.getTopiaId(), especesUsed, especesToDelete, tailleToDelete, true);
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder(512);
            StringBuilder sb2 = new StringBuilder(512);
            Decorator decorator = this.getDecoratorService().getDecorator(EspeceThon.class);
            Decorator decorator2 = this.getDecoratorService().getDecorator(TailleThon.class);
            for (EspeceThon e : especesToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (TailleThon t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n._((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n._((String)"observe.message.table.rejetThon.will.delete.tailleThon", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n._((String)"observe.choice.continue", (Object[])new Object[0]), I18n._((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            this.ALL_TAILLES_TO_DELETE_ENTRY.setContextValue((JAXXContext)this.getUi(), tailleToDelete);
        }
        for (CaptureThon captureThon : objets) {
            captureThon.setCalee(bean);
        }
        return true;
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, Calee bean, Collection<CaptureThon> oldChilds) {
        List tailleToDelete;
        if (oldChilds != null && !oldChilds.isEmpty()) {
            for (CaptureThon captureThon : oldChilds) {
                if (!captureThon.getRejete()) continue;
                bean.addCaptureThon(captureThon);
            }
        }
        if ((tailleToDelete = (List)this.ALL_TAILLES_TO_DELETE_ENTRY.getContextValue((JAXXContext)this.getUi())) != null && !tailleToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will remove " + tailleToDelete.size() + " obsolete tailleThon(s)."));
            }
            EchantillonThon echantillon = bean.getEchantillonThon(true);
            echantillon.getTailleThon().removeAll(tailleToDelete);
        }
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, CaptureThon bean, boolean create) {
        NumberEditor requestFocus;
        EspeceThon beanEspece;
        CaptureThonUI ui = this.getUi();
        CategoriePoids beanCategoriePoids = bean.getCategoriePoids();
        EspeceThon especeThon = beanEspece = beanCategoriePoids == null ? null : beanCategoriePoids.getEspece();
        if (create) {
            ui.getEspece().setSelectedItem(null);
            if (!this.getTableModel().isCreate()) {
                ui.getEspece().setSelectedItem((Object)beanEspece);
                ui.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
            }
            requestFocus = ui.getEspece();
        } else {
            ui.getEspece().setSelectedItem((Object)beanEspece);
            ui.getCategoriePoids().setData(Arrays.asList(beanCategoriePoids));
            ui.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
            requestFocus = ui.getPoids();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected categoriePoid " + beanCategoriePoids));
            log.debug((Object)("selected espece " + beanEspece));
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)50);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.captureThon.especeThon", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.especeThon.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.categoriePoids", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.categoriePoids.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.cuve", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.cuve.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.poids", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.poids.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.commentaire", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureThon.commentaire.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, CategoriePoids.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)renderer);
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    protected void onEspeceChanged(EspeceThon espece) {
        List<Object> availableCategories;
        if (espece == null) {
            availableCategories = Collections.emptyList();
        } else {
            availableCategories = this.getAllCategories((JAXXContext)this.getUi());
            Iterator<Object> it = availableCategories.iterator();
            while (it.hasNext()) {
                CategoriePoids poidse = (CategoriePoids)it.next();
                if (espece.equals(poidse.getEspece())) continue;
                it.remove();
            }
        }
        BeanComboBox<CategoriePoids> combo = this.getUi().getCategoriePoids();
        combo.setData(availableCategories);
        combo.setSelectedItem(null);
    }

    protected List<CategoriePoids> getAllCategories(JAXXContext context) {
        ArrayList<CategoriePoids> list = new ArrayList<CategoriePoids>((Collection)this.ALL_CATEGORIES_ENTRY.getContextValue(context));
        return list;
    }
}

