/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.MareeUI;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class MareeUIHandler
extends ContentOpenableUIHandler<Maree> {
    private static final Log log = LogFactory.getLog(MareeUIHandler.class);

    public MareeUIHandler(MareeUI ui) {
        super(ui, DataContextType.Programme, DataContextType.Maree, I18n.n_((String)"observe.message.maree.not.open", (Object[])new Object[0]));
    }

    @Override
    public MareeUI getUi() {
        return (MareeUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Maree> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Maree.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Maree.class, new String[]{"dateDebut", "dateFin", "formulairesUrl", "rapportsUrl", "commentaire", "bateau", "senne", "observateur", "ocean", "programme", "route", "open"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"route"});
            r = binderService.registerTopiaBinder(Maree.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String mareeId = this.getSelectedId();
        if (mareeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Maree.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n._((String)this.closeMessage, (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        boolean create;
        super.openUI();
        ContentMode mode = this.computeContentMode();
        String programmeId = this.getSelectedParentId();
        String mareeId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "programmeId = " + programmeId));
            log.info((Object)(this.prefix + "mareeId     = " + mareeId));
            log.info((Object)(this.prefix + "mode        = " + (Object)((Object)mode)));
        }
        DataService dataService = this.getDataService();
        Maree bean = (Maree)this.getBean();
        DataSource source = this.getDataSource();
        boolean bl = create = mareeId == null;
        if (create) {
            if (log.isInfoEnabled()) {
                log.info((Object)"create a new maree");
            }
            dataService.preCreate(source, programmeId, (TopiaEntity)bean, this.getLoadBinder(), this.getPreCreateExecutor());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("using existing maree " + mareeId));
            }
            dataService.loadEditEntity(source, mareeId, this.getLoadExecutor());
            if (!bean.isRouteEmpty()) {
                DBHelper.sortRoutes((List)bean.getRoute());
            }
        }
        this.finalizeOpenUI(mode, create);
    }

    @Override
    protected Maree onPreCreate(TopiaContext tx, Object parent, Maree bean) throws TopiaException {
        Programme parentBean = (Programme)parent;
        Date date = DBHelper.getDay((Date)new Date());
        bean.setDateDebut(date);
        if (log.isDebugEnabled()) {
            log.debug((Object)("date debut " + date));
            log.debug((Object)("programme : " + parentBean));
        }
        bean.setProgramme(parentBean);
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        MareeUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        ContentMode mode = model.getMode();
        boolean create = mode == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(mode);
        ui.getValidator().setContext(contextName);
        if (create) {
            this.addInfoMessage(I18n._((String)"observe.message.creating.maree", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n._((String)"observe.message.updating.maree", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)model).isHistoricalData()) {
                this.addInfoMessage(I18n._((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        }
        if (model.getMode() == ContentMode.UPDATE && ((Maree)this.getBean()).getDateFin() == null) {
            Date date = DBHelper.getEndOfDay((Date)new Date());
            ((Maree)this.getBean()).setDateFin(date);
            if (log.isDebugEnabled()) {
                log.debug((Object)("date fin " + date));
            }
        }
        super.startEditUI("bateau.selectedItem", "observateur.selectedItem", "ocean.selectedItem", "senne.selectedItem", "dateDebut.date", "dateFin.date", "commentaire2.text", "close.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(Maree bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Maree> binder) throws Exception {
        String programmeId = this.getDataContext().getSelectedProgrammeId();
        Date dateDebut = DBHelper.getDay((Date)bean.getDateDebut());
        if (log.isDebugEnabled()) {
            log.debug((Object)("dateDebut = " + dateDebut));
        }
        bean.setDateDebut(dateDebut);
        bean.updateDateFin();
        Date dateFin = bean.getDateFin();
        if (log.isDebugEnabled()) {
            log.debug((Object)("dateFin   = " + dateFin));
        }
        if (bean.getTopiaId() == null) {
            bean.setOpen(true);
            dataService.create(dataSource, programmeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected Maree onCreate(TopiaContext tx, Object parent, Maree editBean) throws TopiaException {
        Maree beanToSave = (Maree)ObserveDAOHelper.getMareeDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        return beanToSave;
    }

    @Override
    protected Maree onUpdate(TopiaContext tx, Object parentBean, Maree beanToSave) throws TopiaException {
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"route"});
        return beanToSave;
    }

    @Override
    protected boolean doDelete(Maree bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, Maree> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        dataService.delete(dataSource, null, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parentBean, Maree beanToDelete) throws TopiaException {
        TopiaDAO dao = this.getDataSource().getDAO(tx, (TopiaEntity)beanToDelete);
        dao.delete((TopiaEntity)beanToDelete);
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        return !create && !dataContext.isOpenMaree();
    }
}

