/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.config;

import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.tree.DataSelectionTreeCellRenderer;
import java.awt.Window;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;

public class ConfigUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ConfigUIHandler.class);

    public ConfigUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, ConfigUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)("specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        UIHelper.getLayer((JComponent)tabUI.getOperations()).setUI((LayerUI)ui.getOperationBlockLayerUI());
        UIHelper.getLayer((JComponent)tabUI.getConfig()).setUI((LayerUI)ui.getConfigBlockLayerUI());
        UIHelper.getLayer((JComponent)tabUI.getContent()).setUI(null);
    }

    public void initTabUI(AdminUI ui, SelectDataUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        UIHelper.getLayer((JComponent)tabUI.getContent()).setUI(null);
        UIHelper.getLayer((JComponent)tabUI.getSelectTreePane()).setUI((LayerUI)ui.getConfigBlockLayerUI());
        JTree tree = tabUI.getSelectTree();
        tabUI.getTreeHelper().setUI(tree, false, null);
        DataSelectionTreeCellRenderer.initUI(tree);
    }

    public void updateOperationState(JCheckBox checkBox) {
        AdminStep op = this.getOperation(checkBox);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Operation " + (Object)((Object)op) + " selection has changed : selected:" + checkBox.isSelected()));
        }
        if (checkBox.isSelected()) {
            this.getModel().addOperation(op);
        } else {
            this.getModel().removeOperation(op);
        }
    }

    public String updateStorageLabel(StorageUIModel service, boolean serviceValid, JLabel label) {
        String text = serviceValid ? service.getLabel() : I18n._((String)((String)label.getClientProperty("no")), (Object[])new Object[0]);
        return text;
    }

    public AdminStep getOperation(JCheckBox checkBox) {
        return AdminStep.valueOf(checkBox.getName());
    }

    public boolean isOperationSelected(Set<AdminStep> operations, JCheckBox checkBox) {
        AdminStep scope = this.getOperation(checkBox);
        return operations.contains((Object)scope);
    }

    public StorageUIHandler getStorageHandler() {
        return this.ui.getContextValue(StorageUIHandler.class);
    }

    public void obtainIncomingConnexion() {
        StorageUIModel sourceModel = this.ui.getLocalSourceModel();
        StorageUILauncher.obtainConnexion((JAXXContext)this.ui, this.ui.getParentContainer(Window.class), sourceModel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After modifiy source model isValid : " + sourceModel.isValid() + " / " + sourceModel.isValidStep()));
        }
        this.model.removeLocalSource();
        this.model.getLocalSourceModel().validate(StorageStep.CONFIG);
        this.model.validate();
    }

    public void obtainRemoteConnexion() {
        StorageUIModel sourceModel = this.ui.getCentralSourceModel();
        StorageUILauncher.obtainRemoteConnexion((JAXXContext)this.ui, this.ui.getParentContainer(Window.class), sourceModel);
        this.model.removeCentralSource();
        this.model.getCentralSourceModel().validate(StorageStep.CONFIG);
        this.model.validate();
    }

    protected String updateDataSourcePolicy(StorageUIModel sourceModel, boolean valid) {
        if (!valid) {
            return I18n._((String)"observe.common.storage.not.valid", (Object[])new Object[0]);
        }
        Object config = sourceModel.getDbMode() == DbMode.USE_REMOTE ? sourceModel.getPgConfig() : sourceModel.getH2Config();
        return config.getPolicyLabel();
    }

    protected boolean canShowLocalStorage(Set<AdminStep> operations, boolean needLocalStorage) {
        return !operations.isEmpty() && needLocalStorage;
    }
}

