/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.entities.constants.ReferentielLocaleEnum;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUILauncher;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIManager;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.storage.StorageBackupUILauncher;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import jaxx.runtime.swing.editor.config.model.CallBackFinalizer;
import jaxx.runtime.swing.editor.config.model.MainCallBackFinalizer;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;

@DefaultApplicationContext.AutoLoad
public class ObserveMainUIHandler
implements JAXXHelpUIHandler {
    private static Log log = LogFactory.getLog(ObserveMainUIHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNavigationNode(ObserveMainUI ui, TreeSelectionEvent event) {
        DataSource source = ui.getDataSource();
        if (source == null || !source.isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No open Data source.");
            }
            return;
        }
        if (ui.getNavigation().isSelectionEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No selection, do nothing...");
            }
            return;
        }
        TreePath path = event.getPath();
        ObserveNode node = (ObserveNode)((Object)path.getLastPathComponent());
        ContentUIManager manager = ui.getContentManager();
        Class<? extends ContentUI<?>> uiClass = manager.convertNodeToContentUI(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected path = " + (Object)((Object)node) + ", ui = " + uiClass));
        }
        if (uiClass == null) {
            return;
        }
        ui.setBusy(true);
        try {
            this.doOpencontent(ui, path, manager, uiClass);
            ui.setBusy(false);
        }
        catch (Exception e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                ErrorDialogUI.showError((Exception)e);
                ui.setBusy(false);
            }
            catch (Throwable throwable) {
                ui.setBusy(false);
                String params = node.isStringNode() ? I18n._((String)node.getId()) : I18n._((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()));
                ui.getStatus().setStatus(I18n._((String)"observe.action.open.screen", (Object[])new Object[]{params}));
                throw throwable;
            }
            String params = node.isStringNode() ? I18n._((String)node.getId()) : I18n._((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()));
            ui.getStatus().setStatus(I18n._((String)"observe.action.open.screen", (Object[])new Object[]{params}));
        }
        String params = node.isStringNode() ? I18n._((String)node.getId()) : I18n._((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()));
        ui.getStatus().setStatus(I18n._((String)"observe.action.open.screen", (Object[])new Object[]{params}));
    }

    public void doOpencontent(ObserveMainUI ui, TreePath path, ContentUIManager manager, Class<? extends ContentUI<?>> uiClass) {
        Object[] nodes = path.getPath();
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : nodes) {
            ObserveNode n = (ObserveNode)((Object)o);
            if (n.isStringNode() || n.isReferentielNode() || n.isRoot() || !n.isDataNode()) continue;
            ids.add(n.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected ids from tree = " + ids));
        }
        String[] selectedIds = ids.toArray(new String[ids.size()]);
        DataContext context = ui.getDataContext();
        context.populateSelectedIds(selectedIds);
        ContentUI<?> content = manager.getContent(uiClass);
        if (content == null) {
            content = manager.createContent(uiClass);
        }
        manager.openContent(content);
    }

    public ObserveMainUI initUI(ObserveContext context, ObserveConfig config) {
        SwingValidatorMessageTableModel errorModel = new SwingValidatorMessageTableModel(){
            private static final long serialVersionUID = 1L;

            public void removeMessages(JComponent editor, BeanValidatorScope scope) {
                if (scope == null) {
                    int nb = this.getRowCount();
                    if (nb > 0) {
                        this.data.clear();
                        this.fireTableRowsDeleted(0, nb - 1);
                    }
                } else {
                    super.removeMessages(editor, scope);
                }
            }
        };
        DecoratorService decoratorService = context.getDecoratorService();
        boolean reloadDecorators = false;
        if (!config.getLocale().equals(I18n.getStore().getLanguage().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init I18n with locale " + config.getLocale()));
            }
            I18n.init((Locale)config.getLocale());
            reloadDecorators = true;
        }
        if (!config.getDbLocale().equals(decoratorService.getReferentielLocale().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init db with locale " + config.getDbLocale()));
            }
            decoratorService.setReferentielLocale(ReferentielLocaleEnum.valueOf((Locale)config.getDbLocale()));
            reloadDecorators = true;
        }
        if (reloadDecorators) {
            if (log.isInfoEnabled()) {
                log.info((Object)"reload decorators");
            }
            decoratorService.reload();
        }
        ObserveTreeHelper treeHelper = new ObserveTreeHelper();
        DataSource source = context.getDataSource();
        boolean open = context.getDataContext().getEnabled();
        if (open) {
            treeHelper.createModel(source);
        } else {
            treeHelper.createEmptyModel();
        }
        JAXXInitialContext tx = new JAXXInitialContext();
        tx.add((Object)context).add((Object)treeHelper).add((Object)errorModel);
        ObserveMainUI ui = new ObserveMainUI((JAXXContext)tx);
        ui.setUndecorated(config.isFullScreen());
        String title = ObserveRunner.isAdmin() ? I18n._((String)"observe.title.welcome.admin") : I18n._((String)"observe.title.welcome");
        title = title + " v " + config.getVersion();
        ui.setTitle(title);
        context.setObserveMainUI(ui);
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(config.isFullScreen() ? ui : null);
        context.registerShareActions(ui);
        return ui;
    }

    public void reloadI18n(ObserveMainUI ui) {
        log.info((Object)"ObServe reloading i18n...");
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        File directory = config.getI18nDirectory();
        log.info((Object)I18n._((String)"observe.message.delete.directory", (Object[])new Object[]{directory}));
        FileUtil.deleteRecursively((File)directory);
        I18n.close();
        I18n.init((Locale)config.getLocale());
        DecoratorService decoratorService = ui.getContextValue(DecoratorService.class);
        if (log.isInfoEnabled()) {
            log.info((Object)"reload decorators");
        }
        decoratorService.reload();
        Callback.ui.run();
    }

    public void reloadDefaultConfiguration(ObserveMainUI ui) {
        log.info((Object)"ObServe reloading default configuration...");
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        File directory = config.getResourcesDirectory();
        log.info((Object)I18n._((String)"observe.message.delete.directory", (Object[])new Object[]{directory}));
        FileUtil.deleteRecursively((File)directory);
        Callback.application.run();
    }

    public void reloadApplication(ObserveMainUI ui) {
        log.info((Object)"ObServe reloading...");
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        Callback.application.run();
    }

    public void changeLanguage(ObserveMainUI ui, Locale newLocale) {
        log.info((Object)"ObServe changing application language...");
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.LOCALE, newLocale);
        Callback.ui.run();
    }

    public void changeDbLanguage(ObserveMainUI ui, ReferentielLocaleEnum newLocale) {
        log.info((Object)"ObServe changing db language...");
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.DB_LOCALE, newLocale.getLocale());
        Callback.ui.run();
    }

    public void changeScreen(ObserveMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.FULL_SCREEN, fullscreen);
        this.reloadUI(ObserveContext.get(), config);
    }

    public void showStorageInfo(ObserveMainUI ui) {
        String text = ui.getConfig().isMainStorageOpened() ? ui.getDataSource().toString() : I18n._((String)"observe.message.db.none.loaded");
        JOptionPane.showMessageDialog(ui, text, I18n._((String)"observe.title.storage.info"), 1);
    }

    public void launchImportFromFile(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        new StorageUILauncher((JAXXContext)ui, this.getUI((JAXXContext)ui), I18n._((String)"observe.title.import.localDB")){

            @Override
            protected void init(StorageUI ui) {
                super.init(ui);
                StorageUIModel model = ui.getModel();
                model.setCanCreateLocalService(true);
                model.setCanUseLocalService(false);
                model.setCanUseRemoteService(false);
                model.setDbMode(DbMode.CREATE_LOCAL);
                model.setCreationMode(CreationMode.IMPORT_EXTERNAL_DUMP);
                if (model.isLocalStorageExist()) {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.BACKUP, StorageStep.CONFIRM});
                } else {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.CONFIRM});
                }
            }

            @Override
            protected void doAction(StorageUI ui) {
                super.doAction(ui);
                StorageUIHandler handler = this.getStorageUIHandler();
                handler.doChangeStorage((JAXXContext)ui, ui.getModel());
            }
        }.start();
    }

    public void launchChangeStorage(ObserveMainUI ui, DbMode mode, String title) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        StorageUILauncher.changeStorage((JAXXContext)ui, this.getUI((JAXXContext)ui), mode, title);
    }

    public void launchExportToFile(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        DataSource service = ObserveMainUIHandler.getStorage();
        boolean local = service.getConfig() instanceof H2DataSourceConfig;
        if (!(local || service.canReadData() && service.canWriteData())) {
            UIHelper.askUser(null, I18n._((String)"observe.title.can.not.export.obstuna"), I18n._((String)"observe.storage.required.rw.on.data", (Object[])new Object[]{service}), 0, new Object[]{I18n._((String)"observe.choice.cancel")}, 0);
            return;
        }
        String title = local ? I18n._((String)"observe.title.save.localDB") : I18n._((String)"observe.title.save.remoteDB");
        StorageBackupUILauncher launcher = new StorageBackupUILauncher((JAXXContext)ui, ui, title);
        launcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchCloseStorage(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        this.setBusy((JAXXContext)ui, true);
        try {
            DataSource storage = ObserveMainUIHandler.getStorage();
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> close main storage " + storage));
            }
            storage.doClose(false);
        }
        catch (DataSourceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            log.error((Object)ex);
        }
        finally {
            this.setBusy((JAXXContext)ui, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchReloadStorage(ObserveMainUI ui) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        DataSource storage = ObserveMainUIHandler.getStorage();
        if (storage == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No storage to reload");
            }
            return;
        }
        this.setBusy((JAXXContext)ui, false);
        String[] ids = ui.getTreeHelper().getSelectedIds();
        try {
            DataSourceConfig config = storage.getConfig().clone();
            try {
                log.debug((Object)(">>> close main storage " + storage));
                storage.doClose(false);
            }
            catch (DataSourceException e) {
                ErrorDialogUI.showError((Exception)((Object)e));
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            ObserveConfig appConfig = ObserveContext.get().getConfig();
            if (config instanceof H2DataSourceConfig) {
                H2DataSourceConfig h2Config = (H2DataSourceConfig)config;
                h2Config.setCanMigrate(appConfig.isCanMigrateH2());
                h2Config.detectPolicy();
            }
            if (config instanceof PGDataSourceConfig) {
                PGDataSourceConfig pgConfig = (PGDataSourceConfig)config;
                pgConfig.setCanMigrate(appConfig.isCanMigrateObstuna());
            }
            try {
                storage = DataSourceFactory.newService((DataSourceConfig)config, storage.getClass());
                ObserveContext.get().prepareMainStorage(storage);
                storage.doOpen();
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (ids != null) {
                    ui.getTreeHelper().selectNode(ids);
                }
            }
        }
        finally {
            this.setBusy((JAXXContext)ui, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeApplication(ObserveMainUI ui) {
        log.info((Object)"ObServe quitting...");
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ask to release runner.");
            }
            ObserveRunner.unlock();
        }
    }

    public void showConfig(JAXXContext context) {
        boolean canContinue;
        ObserveMainUI ui = this.getUI(context);
        log.info((Object)"ObServe opening configuration ui...");
        if (ui != null && !(canContinue = this.ensureModification(ui))) {
            return;
        }
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        ObserveConfigUIBuilder helper = new ObserveConfigUIBuilder(config);
        for (Callback callback : Callback.values()) {
            helper.registerCallBack(callback);
        }
        helper.setFinalizer((CallBackFinalizer)new MainCallBackFinalizer(Callback.application.name()));
        helper.setCloseAction(new Runnable(){

            @Override
            public void run() {
                ObserveMainUIHandler.restartEdit();
            }
        });
        helper.addCategory(I18n.n_((String)"observe.config.category.directories"), I18n.n_((String)"observe.config.category.directories.description"));
        helper.addOption(ObserveConfigOption.CONFIG_FILE);
        helper.addOption(ObserveConfigOption.DB_DIRECTORY);
        helper.addOption(ObserveConfigOption.BACKUP_DIRECTORY);
        helper.addOption(ObserveConfigOption.TMP_DIRECTORY);
        helper.addOption(ObserveConfigOption.VALIDATION_REPORT_DIRECTORY);
        helper.addOption(ObserveConfigOption.RESOURCES_DIRECTORY, Callback.application);
        helper.addCategory(I18n.n_((String)"observe.config.category.h2"), I18n.n_((String)"observe.config.category.h2.description"));
        helper.addOption(ObserveConfigOption.H2_LOGIN);
        helper.addOption(ObserveConfigOption.H2_PASSWORD);
        helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
        helper.addCategory(I18n.n_((String)"observe.config.category.obstuna"), I18n.n_((String)"observe.config.category.obstuna.description"));
        helper.addOption(ObserveConfigOption.OBSTUNA_URL);
        helper.addOption(ObserveConfigOption.OBSTUNA_LOGIN);
        helper.addOption(ObserveConfigOption.OBSTUNA_USE_SSL_CERT);
        helper.addOption(ObserveConfigOption.OBSTUNA_SSL_CERTIFICAT_FILE);
        if (ObserveRunner.isAdmin()) {
            helper.addOption(ObserveConfigOption.OBSTUNA_CAN_MIGRATE, Callback.db);
        }
        helper.addCategory(I18n.n_((String)"observe.config.category.changeStorage"), I18n.n_((String)"observe.config.category.changeStorage.description"));
        helper.addOption(ObserveConfigOption.DEFAULT_DB_MODE);
        helper.addOption(ObserveConfigOption.DEFAULT_CREATION_MODE);
        helper.addOption(ObserveConfigOption.STORE_REMOTE_STORAGE);
        helper.addOption(ObserveConfigOption.SHOW_MIGRATION_PROGRESSION);
        helper.addOption(ObserveConfigOption.SHOW_MIGRATION_SQL);
        helper.addCategory(I18n.n_((String)"observe.config.category.gps"), I18n.n_((String)"observe.config.category.gps.description"));
        helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_DELAY);
        helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_SPEED);
        if (ObserveRunner.isAdmin()) {
            helper.addCategory(I18n.n_((String)"observe.config.category.synchro"), I18n.n_((String)"observe.config.category.synchro.description"));
            helper.addOption(ObserveConfigOption.CHANGE_SYNCHRO_SRC);
            helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
            helper.addCategory(I18n.n_((String)"observe.config.category.observation"), I18n.n_((String)"observe.config.category.observation.description"));
            helper.addOption(ObserveConfigOption.OBSERVATION_ACTIVITES_DETAILLEES, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_FAUNE_ASSOCIEE, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_GLEURE, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_MAMMIFERES, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_MENSURATIONS, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_OBJET_FLOTTANT, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_OISEAUX, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_REJETS_THONS, Callback.ui);
        }
        helper.addCategory(I18n.n_((String)"observe.config.category.other"), I18n.n_((String)"observe.config.category.other.description"));
        helper.addOption(ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON);
        helper.addOption(ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR);
        helper.addOption(ObserveConfigOption.LOAD_LOCAL_STORAGE, Callback.application);
        helper.addOption(ObserveConfigOption.FULL_SCREEN, Callback.ui);
        helper.addOption(ObserveConfigOption.LOCALE, Callback.ui);
        helper.addOption(ObserveConfigOption.DB_LOCALE, Callback.ui);
        helper.buildUI(context, "observe.config.category.directories");
        helper.displayUI(ui, false);
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        ObserveMainUI mainUI = this.getUI(context);
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        log.debug((Object)("show help " + helpId));
        mainUI.getHelp().setCurrentID(helpId);
        mainUI.setContextValue(mainUI.getMode(), "oldMode");
        mainUI.setMode(ObserveUIMode.HELP);
    }

    public void closeHelp(JAXXContext context) {
        ObserveMainUI mainUI = this.getUI(context);
        ObserveUIMode oldMode = mainUI.getContextValue(ObserveUIMode.class, "oldMode");
        if (oldMode == null) {
            DataSource mainStorage = mainUI.getDataSource();
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        mainUI.setMode(oldMode);
    }

    public void gotoSite(ObserveMainUI ui) {
        ObserveConfig config = ui.getConfig();
        URL siteURL = config.getOptionAsURL("application.site.url");
        UIHelper.displayInfo(I18n._((String)"observe.message.goto.site", (Object[])new Object[]{siteURL}));
        log.info((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(ObserveMainUI ui) {
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;

            public void buildTopPanel() {
                this.topPanel.setLayout(new BorderLayout());
                ImageIcon logoIcon = Resource.getIcon((String)"/icons/logo-OT_web.png");
                JLabel labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "West");
                logoIcon = Resource.getIcon((String)"/icons/logo_ird.png");
                labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "East");
            }
        };
        String name = ObserveRunner.getRunner().getRunnerName();
        about.setTitle(I18n._((String)"observe.title.about"));
        about.setAboutText(I18n._((String)"observe.about.message"));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/logo-OT_web.png");
        about.setLicenseFile("META-INF/" + name + "-LICENSE.txt");
        about.setThirdpartyFile("META-INF/" + name + "-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected static DataSource getStorage() {
        DataSource source = ObserveContext.get().getDataSource();
        return source;
    }

    protected static DataService getDataService() {
        return ObserveContext.get().getDataService();
    }

    protected void setBusy(JAXXContext context, boolean busy) {
        ObserveMainUI observeMainUI = this.getUI(context);
        if (observeMainUI != null) {
            observeMainUI.setBusy(busy);
        }
    }

    public static void restartEdit() {
        ContentUI<?> selectedUI = ObserveContext.get().getSelectedContentUI();
        if (selectedUI == null) {
            return;
        }
        ContentUIModel<?> model = selectedUI.getModel();
        if (!model.isEditable()) {
            return;
        }
        ContentMode contentMode = model.getMode();
        if (ContentMode.UPDATE != contentMode) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will restart edit for " + selectedUI.getName()));
        }
        selectedUI.restartEdit();
    }

    public void launchAdminAction(ObserveMainUI ui, AdminStep action) {
        boolean canContinue = this.ensureModification(ui);
        if (!canContinue) {
            return;
        }
        AdminUILauncher launcher = AdminUILauncher.newLauncher((JAXXContext)ui, action);
        launcher.start();
    }

    protected void reloadUI(ObserveContext rootContext, ObserveConfig config) {
        config.removeJaxxPropertyChangeListener();
        ObserveMainUI ui = this.getUI((JAXXContext)rootContext);
        DataSource mainStorage = rootContext.getDataSource();
        ObserveUIMode oldMode = null;
        Object[] ids = null;
        if (ui != null) {
            oldMode = ui.getMode();
            ids = ui.getTreeHelper().getSelectedIds();
            ErrorDialogUI.init(null);
            rootContext.removeObserveMainUI();
            ui.dispose();
            ui.setVisible(false);
            System.runFinalization();
        }
        ui = this.initUI(rootContext, config);
        if (oldMode == null) {
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        ui.setMode(oldMode);
        JTree navigation = ui.getNavigation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will reselect ids : " + Arrays.toString(ids)));
        }
        if (ids != null) {
            ui.getTreeHelper().selectNode((String[])ids);
        }
        navigation.requestFocus();
        ui.setVisible(true);
    }

    public ContentUI<?> getSelectedContent(JAXXContext rootContext) {
        JPanel container;
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        ObserveMainUI ui = this.getUI(rootContext);
        ContentUI ui1 = null;
        if (ui == null) {
            return ui1;
        }
        CardLayout2 layout = ui.getContentLayout();
        Component currentContent = layout.getVisibleComponent((Container)(container = ui.getContent()));
        if (currentContent != null && currentContent instanceof ContentUI) {
            ui1 = (ContentUI)((Object)currentContent);
        }
        return ui1;
    }

    protected Icon updateStorageSatutIcon(ObserveMainUI ui, boolean isOpened) {
        DataSource service;
        Icon icon = ui.getConfig().isMainStorageOpened() ? ((service = ui.getDataSource()) instanceof H2DataSource ? (Icon)ui.storageStatus.getClientProperty("localIcon") : (Icon)ui.storageStatus.getClientProperty("remoteIcon")) : (Icon)ui.storageStatus.getClientProperty("noneIcon");
        return icon;
    }

    protected String updateStorageSatutText(ObserveMainUI ui, boolean isOpened) {
        String text;
        if (ui.getConfig().isMainStorageOpened()) {
            DataSource service = ui.getDataSource();
            text = service.getShortLabel();
        } else {
            text = I18n._((String)"observe.message.db.none.loaded");
        }
        return text;
    }

    protected String updateStorageStatutToolTipText(ObserveMainUI ui, boolean isOpened) {
        String text;
        if (ui.getConfig().isMainStorageOpened()) {
            DataSource source = ui.getDataSource();
            text = I18n._((String)"observe.message.loaded.tip", (Object[])new Object[]{source.getLabel()});
        } else {
            text = I18n._((String)"observe.message.db.none.loaded.tip");
        }
        return text;
    }

    public boolean acceptMode(ObserveUIMode mode, ObserveUIMode ... modes) {
        return this.acceptMode(mode, true, modes);
    }

    public boolean acceptMode(ObserveUIMode mode, boolean condition, ObserveUIMode ... modes) {
        if (condition) {
            for (ObserveUIMode m : modes) {
                if (!m.equals((Object)mode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean acceptMode(ObserveUIMode mode, boolean notBusy, boolean condition, ObserveUIMode ... modes) {
        if (notBusy && condition) {
            for (ObserveUIMode m : modes) {
                if (!m.equals((Object)mode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean rejectMode(ObserveUIMode mode, ObserveUIMode ... modes) {
        for (ObserveUIMode m : modes) {
            if (!m.equals((Object)mode)) continue;
            return false;
        }
        return true;
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    protected boolean ensureModification(ObserveMainUI ui) throws IllegalArgumentException {
        boolean closed = ObserveContext.get().closeSelectedContentUI(ui);
        return closed;
    }

    protected ObserveMainUI getUI(JAXXContext context) {
        if (context instanceof ObserveMainUI) {
            return (ObserveMainUI)context;
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        return ui;
    }

    protected void $afterCompleteSetup(final ObserveMainUI ui) {
        ui.getStatus().init();
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ObserveMainUIHandler.this.changeNavigationNode(ui, e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ui.getNavigationScrollPane().getHorizontalScrollBar().setValue(0);
                        ui.getSplitpane2().resetToPreferredSizes();
                    }
                });
            }
        };
        TreeWillExpandListener veteobableTreeWillExpand = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                ObserveNode selectedNode = (ObserveNode)ui.getTreeHelper().getSelectedNode();
                if (selectedNode == null) {
                    return;
                }
                ObserveNode o = (ObserveNode)((Object)event.getPath().getLastPathComponent());
                if (((Object)((Object)selectedNode)).equals((Object)o) || !selectedNode.isNodeAncestor((TreeNode)((Object)o))) {
                    return;
                }
                boolean canChange = ObserveMainUIHandler.this.ensureModification(ui);
                if (!canChange) {
                    throw new ExpandVetoException(event, "Can not collapse node " + event.getPath());
                }
            }
        };
        ui.getTreeHelper().setUI(ui.getNavigation(), true, true, listener, veteobableTreeWillExpand);
        ui.setContextValue(ui.getBroker());
        SwingValidatorUtil.installUI((JTable)ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new UIHelper.ObserveValidatorMessageTableRenderer());
        UIHelper.getLayer((JComponent)ui.getBody()).setUI((LayerUI)ui.getBusyBlockLayerUI());
        ui.addPropertyChangeListener("busy", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                ObserveMainUIHandler.this.updateBusyState(ui, newvalue != null && newvalue != false);
            }
        });
    }

    protected void updateBusyState(ObserveMainUI ui, boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ui.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ui.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected class ObserveConfigUIBuilder
    extends ConfigUIHelper {
        public ObserveConfigUIBuilder(ObserveConfig config) {
            super((ApplicationConfig)config);
        }

        public ObserveConfigOption addOption(ObserveConfigOption option) {
            String beanProperty = option.getPropertyKey();
            if (StringUtils.isEmpty((String)beanProperty)) {
                super.addOption((ApplicationConfig.OptionDef)option);
            } else {
                this.addOption(option, beanProperty);
            }
            if (!option.isAdmin() || ObserveRunner.isAdmin()) {
                return option;
            }
            return null;
        }

        public void addOption(ObserveConfigOption option, Callback callBack) {
            if ((option = this.addOption(option)) != null) {
                this.setOptionCallBack(callBack.name());
            }
        }

        public void registerCallBack(Callback callback) {
            String name = callback.name();
            String description = callback.getLabel();
            ImageIcon icon = callback.getIcon();
            Callback action = callback;
            this.registerCallBack(name, description, icon, action);
        }
    }

    public static enum Callback implements Runnable
    {
        application(I18n.n_((String)"observe.action.reload.application"), "reload-application"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload application");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                context.askReload();
                handler.closeApplication(ui);
            }
        }
        ,
        ui(I18n.n_((String)"observe.action.reload.ui"), "reload-ui"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload ui");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                ObserveConfig config = ui.getConfig();
                handler.reloadUI(context, config);
            }
        }
        ,
        db(I18n.n_((String)"observe.action.reload.storage"), "reload-db"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload db");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                handler.launchReloadStorage(ui);
            }
        };

        private final String label;
        private final String iconPath;

        private Callback(String label, String iconPath) {
            this.iconPath = iconPath;
            this.label = label;
            this.getIcon();
        }

        public ImageIcon getIcon() {
            ImageIcon icon = UIHelper.createActionIcon((String)this.iconPath);
            return icon;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

