/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.DBHelper;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class SelectDataTreeSelectionModel
implements TreeSelectionModel,
PropertyChangeListener,
Serializable {
    private static final Log log = LogFactory.getLog(SelectDataTreeSelectionModel.class);
    private static final long serialVersionUID = -1L;
    protected SelectDataModel dataModel;
    protected TreePath[] selection;
    protected EventListenerList listenerList = new EventListenerList();
    protected TreePath leadPath;
    protected int leadIndex;
    protected int leadRow;
    protected int minSelectionRow;
    protected int maxSelectionRow;
    protected int[] selectionRows;
    protected transient RowMapper rowMapper;
    protected Set<TreePath> universe;
    private PropertyChangeSupport changeSupport;
    private static final PropertyChangeListener[] EMPTY_PROPERTY_CHANGE_LISTENERS = new PropertyChangeListener[0];

    public void initUI(JTree tree) {
        this.clearSelection();
        if (this.universe != null) {
            this.universe.clear();
        }
        int i = 0;
        while (i < tree.getRowCount()) {
            tree.expandRow(i++);
        }
        int count = tree.getRowCount();
        this.universe = new HashSet<TreePath>(count);
        for (i = 0; i < count; ++i) {
            TreePath path = tree.getPathForRow(i);
            this.universe.add(path);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("init path : " + path.getLastPathComponent()));
        }
    }

    public void setDataModel(SelectDataModel dataModel) {
        SelectDataModel oldModel = this.dataModel;
        if (oldModel != null) {
            oldModel.removePropertyChangeListener((PropertyChangeListener)this);
            oldModel.destroy();
        }
        this.dataModel = dataModel;
        if (dataModel != null) {
            this.dataModel.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.updateModel();
    }

    @Override
    public void setSelectionMode(int mode) {
    }

    @Override
    public int getSelectionMode() {
        return 4;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        boolean referentiel;
        if (this.dataModel == null) {
            return;
        }
        Object o = path.getLastPathComponent();
        NavigationTreeNode node = AbstractObserveTreeCellRenderer.getNode(o);
        if (node == null) {
            return;
        }
        Class internalClass = node.getInternalClass();
        String nodePath = node.getFullPath();
        boolean bl = referentiel = TopiaEntity.class.isAssignableFrom(internalClass) && nodePath.startsWith("$root/referentiel") && DBHelper.isReferentielClass((Class)internalClass);
        if (!this.universe.contains(path)) {
            TreePath parentPath;
            this.universe.add(path);
            if (log.isDebugEnabled()) {
                log.debug((Object)("add new path to universe " + path.getLastPathComponent()));
            }
            if (!referentiel && Programme.class.equals((Object)internalClass)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding programme childs path (" + node.getChildCount() + ")"));
                }
                Enumeration childs = node.children();
                while (childs.hasMoreElements()) {
                    Object o1 = childs.nextElement();
                    TreePath path1 = path.pathByAddingChild(o1);
                    if (this.universe.contains(path1)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding path for node " + o1));
                    }
                    this.universe.add(path1);
                }
            }
            if (Maree.class.equals((Object)internalClass) && !this.universe.contains(parentPath = path.getParentPath())) {
                this.universe.add(parentPath);
                NavigationTreeNode parentNode = node.getParent();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding programme with his childs (" + parentNode.getChildCount() + ")"));
                }
                Enumeration childs = parentNode.children();
                while (childs.hasMoreElements()) {
                    Object o1 = childs.nextElement();
                    TreePath path1 = parentPath.pathByAddingChild(o1);
                    if (this.universe.contains(path1)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding path for node " + o1));
                    }
                    this.universe.add(path1);
                }
            }
        }
        boolean pathSelected = this.isPathSelected(path);
        if (log.isDebugEnabled()) {
            log.debug((Object)("node " + node + ", path selected ? " + pathSelected));
        }
        if (nodePath.equals("$root/referentiel")) {
            if (pathSelected) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Will remove all referentiels");
                }
                this.dataModel.removeAllSelectedReferentiel();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Will add all referentiels");
                }
                this.dataModel.addAllSelectedReferentiel();
            }
            return;
        }
        if (referentiel) {
            if (pathSelected) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will remove referentiel " + internalClass + " to model"));
                }
                this.dataModel.removeSelectedReferentiel(internalClass);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will add referentiel " + internalClass + " to model"));
                }
                this.dataModel.addSelectedReferentiel(internalClass);
            }
            return;
        }
        Object bean = node.getBean();
        if (log.isDebugEnabled()) {
            log.debug((Object)("bean " + bean));
        }
        if (pathSelected) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Already add ? remove it.");
            }
            this.removeFromDataModel(bean);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will add selection to model");
            }
            this.addToDataModel(bean);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
    }

    @Override
    public void addSelectionPath(TreePath path) {
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
    }

    @Override
    public void removeSelectionPath(TreePath path) {
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
    }

    @Override
    public TreePath getSelectionPath() {
        return this.selection == null ? null : this.selection[0];
    }

    @Override
    public TreePath[] getSelectionPaths() {
        return this.selection;
    }

    @Override
    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.length;
    }

    @Override
    public boolean isPathSelected(TreePath path) {
        if (this.dataModel == null) {
            return false;
        }
        Object o = path.getLastPathComponent();
        NavigationTreeNode node = AbstractObserveTreeCellRenderer.getNode(o);
        if (node != null) {
            String contextPath = node.getFullPath();
            Class internalClass = node.getInternalClass();
            if (contextPath.equals("$root/referentiel")) {
                boolean result = this.dataModel.isReferentielFull();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("selectModel use full referentiel " + internalClass + " ? " + result));
                }
                return result;
            }
            if (contextPath.startsWith("$root/referentiel")) {
                boolean result = this.dataModel.isSelectedReferentiel(internalClass);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("selectModel use referentiel " + internalClass + " ? " + result));
                }
                return result;
            }
            Object bean = node.getBean();
            if (log.isTraceEnabled()) {
                log.trace((Object)("begin node " + node + " / " + node.getFullPath()));
            }
            if (bean instanceof Programme) {
                Programme p = (Programme)bean;
                boolean result = this.dataModel.isSelectedData(p);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("selectModel contains the programme ? " + result));
                }
                return result;
            }
            if (bean instanceof Maree) {
                Maree m = (Maree)bean;
                boolean result = this.dataModel.isSelectedData(m);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("selectModel contains the maree ? " + result));
                }
                return result;
            }
        }
        return false;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection == null || this.selection.length == 0;
    }

    @Override
    public void clearSelection() {
        if (this.dataModel == null) {
            return;
        }
        this.selection = null;
        this.dataModel.removeAll();
    }

    @Override
    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public void setRowMapper(RowMapper newMapper) {
        this.rowMapper = newMapper;
    }

    @Override
    public int[] getSelectionRows() {
        return this.selectionRows;
    }

    @Override
    public int getMinSelectionRow() {
        return this.minSelectionRow;
    }

    @Override
    public int getMaxSelectionRow() {
        return this.maxSelectionRow;
    }

    @Override
    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    @Override
    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    @Override
    public boolean isRowSelected(int row) {
        if (!this.isSelectionEmpty()) {
            for (int i : this.selectionRows) {
                if (row != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void resetRowSelection() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start rebuild row values...");
        }
        this.maxSelectionRow = -1;
        this.minSelectionRow = -1;
        this.leadRow = -1;
        this.selectionRows = null;
        if (this.rowMapper == null || this.selection == null) {
            return;
        }
        int[] rows = this.rowMapper.getRowsForPaths(this.selection);
        if (rows != null) {
            int invisCount = 0;
            for (int counter = rows.length - 1; counter >= 0; --counter) {
                if (rows[counter] != -1) continue;
                ++invisCount;
            }
            if (invisCount > 0) {
                if (invisCount == rows.length) {
                    rows = null;
                } else {
                    int[] tempRows = new int[rows.length - invisCount];
                    int visCounter = 0;
                    for (int counter = rows.length - 1; counter >= 0; --counter) {
                        if (rows[counter] == -1) continue;
                        tempRows[visCounter++] = rows[counter];
                    }
                    rows = tempRows;
                }
            }
        }
        this.selectionRows = rows;
        if (this.isSelectionEmpty()) {
            this.leadPath = null;
            this.leadIndex = -1;
            this.leadRow = -1;
        } else {
            this.leadPath = this.selection[0];
            this.leadIndex = 0;
            this.leadRow = this.selectionRows[0];
        }
        int selectionLength = this.selection.length;
        this.minSelectionRow = -1;
        this.maxSelectionRow = 0;
        for (int i = 0; i < selectionLength; ++i) {
            int row = this.selectionRows[i];
            if (row > this.maxSelectionRow) {
                this.maxSelectionRow = row;
            }
            if (row >= this.minSelectionRow) continue;
            this.minSelectionRow = row;
        }
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener x) {
        this.listenerList.add(TreeSelectionListener.class, x);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener x) {
        this.listenerList.remove(TreeSelectionListener.class, x);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(TreeSelectionListener.class);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return EMPTY_PROPERTY_CHANGE_LISTENERS;
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (!TreeSelectionListener.class.equals(listeners[i])) continue;
            ((TreeSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    protected void addToDataModel(Object bean) {
        if (bean instanceof Programme) {
            Programme p = (Programme)bean;
            if (log.isTraceEnabled()) {
                log.trace((Object)"selectModel add programme");
            }
            this.dataModel.addSelectedData(p);
        }
        if (bean instanceof Maree) {
            Maree m = (Maree)bean;
            if (log.isTraceEnabled()) {
                log.trace((Object)"selectModel add maree");
            }
            this.dataModel.addSelectedData(m);
        }
    }

    protected void removeFromDataModel(Object bean) {
        if (bean instanceof Programme) {
            Programme p = (Programme)bean;
            if (log.isTraceEnabled()) {
                log.trace((Object)"selectModel remove programme");
            }
            this.dataModel.removeSelectedData(p);
        }
        if (bean instanceof Maree) {
            Maree m = (Maree)bean;
            if (log.isTraceEnabled()) {
                log.trace((Object)"selectModel remove maree");
            }
            this.dataModel.removeSelectedData(m);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("selectedData".equals(propertyName) || "selectedReferentiel".equals(propertyName)) {
            Object value = evt.getNewValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("selection data changed " + value));
            }
        }
        this.updateModel();
    }

    protected void updateModel() {
        if (this.rowMapper == null || this.universe == null) {
            return;
        }
        List oldSelection = this.isSelectionEmpty() ? Collections.emptyList() : Arrays.asList(this.selection);
        ArrayList<TreePath> newSelection = new ArrayList<TreePath>();
        for (TreePath p : this.universe) {
            if (!this.isPathSelected(p)) continue;
            newSelection.add(p);
        }
        int selectionLength = newSelection.size();
        this.selection = newSelection.toArray(new TreePath[selectionLength]);
        TreePath oldLeadPath = this.leadPath;
        if (this.isSelectionEmpty()) {
            this.leadPath = null;
            this.leadIndex = -1;
        } else {
            this.leadPath = selectionLength > 0 ? this.selection[0] : null;
            this.leadIndex = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selection length = " + selectionLength));
        }
        this.resetRowSelection();
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selection length = " + (this.selectionRows == null ? 0 : this.selectionRows.length)));
            if (log.isDebugEnabled()) {
                log.debug((Object)("selected rows = " + Arrays.toString(this.selectionRows)));
            }
        }
        ArrayList obsoleteSelection = new ArrayList(oldSelection);
        obsoleteSelection.removeAll(newSelection);
        ArrayList<TreePath> changedPaths = new ArrayList<TreePath>(oldSelection);
        changedPaths.addAll(newSelection);
        TreePath[] treePaths = changedPaths.toArray(new TreePath[changedPaths.size()]);
        TreeSelectionEvent event = new TreeSelectionEvent((Object)this, treePaths, new boolean[treePaths.length], oldLeadPath, this.leadPath);
        this.fireValueChanged(event);
    }
}

