/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.tree.ObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveTreeModelBuilder;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.DataContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import jaxx.runtime.swing.navigation.handler.NavigationTreeHandlerWithCardLayout;
import jaxx.runtime.swing.navigation.tree.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class ObserveTreeHelper
extends NavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ObserveTreeHelper.class);
    protected ObserveTreeModelBuilder builder;

    public ObserveTreeHelper(String contextPrefix) {
        super(contextPrefix);
    }

    public ObserveTreeHelper() {
        super("navigation");
    }

    public ObserveTreeModelBuilder getBuilder() {
        return this.builder;
    }

    public NavigationTreeModel createTreeModel(JAXXContext context, SelectDataModel dataModel) {
        return this.createTreeModel(context, dataModel, false);
    }

    public NavigationTreeModel createTreeModel(JAXXContext context, SelectDataModel dataModel, boolean valueAdjusting) {
        if (this.builder == null) {
            this.builder = new ObserveTreeModelBuilder(context, true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("create tree model " + (Object)((Object)this)));
        }
        this.builder.createInitialModel(dataModel, valueAdjusting);
        NavigationTreeModel model = this.builder.getModel();
        if (log.isDebugEnabled()) {
            this.builder.printModel(model.getRoot());
        }
        context.setContextValue((Object)dataModel);
        return model;
    }

    public NavigationTreeModel createTreeModel(JAXXContext context) {
        if (this.builder == null) {
            this.builder = new ObserveTreeModelBuilder(context);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("create tree model " + (Object)((Object)this)));
        }
        try {
            ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
            dataContext.reloadData();
            Map datas = dataContext.getData();
            if (log.isDebugEnabled()) {
                log.debug((Object)("datas to build : " + datas));
            }
            this.builder.createInitialModel(datas);
        }
        catch (IllegalArgumentException e) {
            this.builder.createEmptyModel();
        }
        NavigationTreeModel model = this.builder.getModel();
        if (log.isDebugEnabled()) {
            this.builder.printModel(model.getRoot());
        }
        this.setModel(context, (NavigationModel)model);
        return model;
    }

    public ObserveTreeCellRenderer getTreeCellRenderer(JAXXContext context) {
        JTree t = this.getTree(context);
        TreeCellRenderer r = t.getCellRenderer();
        return (ObserveTreeCellRenderer)(r instanceof ObserveTreeCellRenderer ? r : null);
    }

    public void selectOpenNode(JAXXContext context, Class<? extends TopiaEntity> type) {
        ObserveDataContext.ObserveDataContextEntry entry;
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        TopiaEntity openData = dataContext.getOpenData(entry = dataContext.getEntry(type));
        if (openData == null) {
            return;
        }
        ArrayList<TopiaEntity> datas = new ArrayList<TopiaEntity>();
        for (ObserveDataContext.ObserveDataContextEntry e : dataContext.iterateToLevel(entry.getLevel())) {
            TopiaEntity data = dataContext.getOpenData(e);
            if (data == null) continue;
            datas.add(data);
        }
        String path = entry.getContextPath(datas.toArray());
        NavigationTreeNode node = (NavigationTreeNode)this.findNode(context, path, entry.getPattern());
        this.selectNode(context, (NavigationNode)node);
    }

    public void selectInitialNode(ObserveMainUI ui) {
        String path;
        ObserveDataContext dataContext = ui.getDataContext();
        Programme programme = dataContext.getOpenProgramme();
        Maree maree = dataContext.getOpenMaree();
        if (maree != null && programme != null) {
            path = dataContext.getContextPath(new Object[]{programme});
        } else {
            NavigationTreeNode node = (NavigationTreeNode)this.findNode((JAXXContext)ui, "$root");
            if (!node.isLeaf()) {
                node = node.getChildAt(0);
            }
            path = node.getFullPath();
        }
        this.selectNode((JAXXContext)ui, path);
        ui.getNavigation().requestFocus();
    }

    public void cleanNavigationUI(ObserveMainUI mainUI) {
        mainUI.getContentLayout().reset((Container)mainUI.getContent());
        mainUI.getContextValue(SwingValidatorMessageTableModel.class).clear();
        NavigationTreeModel treeModel = (NavigationTreeModel)this.getSafeModel((JAXXContext)mainUI);
        NavigationTreeNode root = (NavigationTreeNode)treeModel.getRoot();
        root.removeAllChildren();
        treeModel.nodeStructureChanged(root);
        mainUI.getNavigation().setVisible(false);
    }

    public void loadNavigationUI(ObserveMainUI mainUI) {
        NavigationTreeModel model = this.createTreeModel((JAXXContext)mainUI);
        model.nodeStructureChanged((NavigationTreeNode)model.getRoot());
        this.selectInitialNode(mainUI);
        mainUI.getNavigation().setVisible(true);
    }

    public NavigationHandler<NavigationTreeNode> createTreeHandler(JAXXObject context) {
        NavigationTreeHandlerWithCardLayout<NavigationTreeNode> handler = new NavigationTreeHandlerWithCardLayout<NavigationTreeNode>(this.getPrefix(), context, NavigationHandler.Strategy.PER_UI_TYPE){
            private static final long serialVersionUID = 1L;

            public NavigationTreeModel getNavigationTreeModel() {
                return (NavigationTreeModel)ObserveTreeHelper.this.getSafeModel((JAXXContext)this.getContext());
            }

            protected JPanel getContentContainer() {
                return this.getContext().getContent();
            }

            protected CardLayout2 getContentLayout() {
                return this.getContext().getContentLayout();
            }

            public ObserveMainUI getContext() {
                return (ObserveMainUI)this.context;
            }

            protected JTree getNavigationTree() {
                return this.getContext().getNavigation();
            }

            public Component createUI(NavigationTreeNode node) throws Exception {
                Component component;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will createUI " + node.getUIClass()));
                }
                if ((component = super.createUI((NavigationNode)node)) != null && component instanceof ObserveContent) {
                    ((ObserveContent)((Object)component)).init();
                }
                return component;
            }

            public boolean closeUI(Component component) throws Exception {
                return component == null || !(component instanceof ObserveContent) || ((ObserveContent)((Object)component)).close();
            }

            public void openUI(final Component newUI, NavigationTreeNode node) throws Exception {
                if (newUI instanceof ObserveContent) {
                    ((ObserveContent)((Object)newUI)).open();
                }
                super.openUI(newUI, (NavigationNode)node);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.getContentLayout().invalidateLayout((Container)this.getContentContainer());
                        ((JComponent)newUI).revalidate();
                    }
                });
                if (!node.isLeaf()) {
                    TreePath path = new TreePath(this.getNavigationTreeModel().getPathToRoot(node));
                    if (!this.getNavigationTree().isExpanded(path)) {
                        this.getNavigationTree().expandPath(path);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setSelectionPath(TreePath path) {
                ObserveMainUI mainUI = ObserveContext.getObserveMainUI();
                try {
                    if (mainUI != null) {
                        mainUI.setBusy(true);
                    }
                    super.setSelectionPath(path);
                }
                finally {
                    if (mainUI != null) {
                        mainUI.setBusy(false);
                    }
                }
            }

            protected void addSelectedBeanInContext(NavigationTreeNode node, Object data) {
                Object userObject = node.getUserObject();
                String label = userObject.toString();
                UIHelper.displayInfo(I18n._((String)"observe.message.loading.node", (Object[])new Object[]{label}));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"---------------------------------------------------------------------------------------------------------");
                    log.debug((Object)("contextPath <" + node.getFullPath() + '>'));
                    log.debug((Object)("data        <" + (data == null ? null : data.getClass()) + '>'));
                }
                ObserveDataContext dataContext = this.getContext().getContextValue(ObserveDataContext.class);
                dataContext.updateSelectedData(node.getFullPath(), data, (DataContext.UpdateDataContext)new DataContext.UpdateDataContext<ObserveDataContext>(){

                    public void onAddingData(ObserveDataContext context, DataContext.DataContextEntry<ObserveDataContext> entry, String path) {
                        NavigationTreeNode node = (NavigationTreeNode)ObserveTreeHelper.this.findNode((JAXXContext)this.getContext(), path, entry.getPattern(), null);
                        if (node != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("node path      <" + node.getFullPath() + "> for entry " + entry));
                            }
                            context.setContextValue(entry, (Object)node, "node");
                            Object bean = node.getBean((JAXXContext)context.getDelegate());
                            if (bean != null) {
                                context.getDelegate().setContextValue(bean);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("data           <" + bean.getClass().getName() + '>'));
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug((Object)"data           <null>");
                            }
                        }
                    }

                    public void onRemovingData(ObserveDataContext context, DataContext.DataContextEntry<ObserveDataContext> entry) {
                        Object oldBean;
                        context.removeContextValue(entry, NavigationTreeNode.class, "node");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("entry          " + entry));
                        }
                        if ((oldBean = context.getContextValue(entry, null)) != null) {
                            context.removeContextValue(entry, null);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("data           <" + oldBean.getClass().getName() + '>'));
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)"data           <null>");
                        }
                    }
                });
                if (log.isDebugEnabled()) {
                    log.debug((Object)("new scope   <" + dataContext.getCurrentEntry() + ">, new data    <" + (data == null ? null : data.getClass().getName()) + '>'));
                }
                if (data != null) {
                    this.context.setContextValue(data);
                }
            }

            public void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)e);
            }
        };
        handler.setSelectionMode(1);
        this.setTreeHandler((JAXXContext)context, (NavigationHandler)handler);
        return handler;
    }
}

