/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.tabs.AbstractStorageTabPanelUI;
import fr.ird.observe.ui.storage.tabs.BackupPanelUI;
import fr.ird.observe.ui.storage.tabs.ChooseCreationModePanelUI;
import fr.ird.observe.ui.storage.tabs.ChooseDbModePanelUI;
import fr.ird.observe.ui.storage.tabs.ConfigStoragePanelUI;
import fr.ird.observe.ui.storage.tabs.ConfirmPanelUI;
import fr.ird.observe.ui.storage.tabs.SelectDataPanelUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class StorageUI
extends JDialog
implements WizardUI<StorageStep, StorageUIModel>,
JAXXObject {
    public static final String BINDING_APPLY_ACTION_ENABLED = "applyAction.enabled";
    public static final String BINDING_APPLY_ACTION_VISIBLE = "applyAction.visible";
    public static final String BINDING_NEXT_ACTION_ENABLED = "nextAction.enabled";
    public static final String BINDING_NEXT_ACTION_VISIBLE = "nextAction.visible";
    public static final String BINDING_PREVIOUS_ACTION_ENABLED = "previousAction.enabled";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuLGD47SUhpYCATkhqhLUbioQCBQKddZO6+LEUeygihzMeHdiTxnvDLOziUMUxJkTfwLcuSBx44Q4cObABfEvIMSBK+LN7K5/ZY0thOOsvfPmfe+9b9771t/8jtK+RMtPcLdrycBTtEOsR4XHj6vNJ8RRReI7kgrFJQpfMymUOkQ5t7fuK/TKYUW7b0TuGzbvCO4Rb8B7s4LmfXXKiN8mRCn00rCH4/sbtZ55sysCGaP2kkpC/erPP1Jfup9/nUKoKyC7K1BKfpJXv5LZCkpRV6FrEOkYbzDstSANSb0W5HtZr9kM+/4u7pBP0GdoroIyAksAU2hl+pINhvHvCoVyPthwi+xg6gF1R9Ki0rV40yfymFgBtSK7VQs/D8pCGO+MQgurNpZuBZ/yQN1VaFFnaOETZfWX+5uv2A+r1VqpUdxq7FSLJYVeGx9L4aZv2W3OfVJs7nCX7GGPsIOyhsr2EJ+NEO39UqFeru5GuG9NhWtLghXl3lj0jF3d3S4/UOj1SXjcO6KtiJ5kqK2C/f7BnkK3J0BtYefjQCRi5GqlSsmuN4qFekGhuxOAaoTpacEKJ4LNmdr2dxS6M01xspOIMqt3KPScPvau5Z9An1qP6rjZJK7ePxJyFSyMQJvcHBqI0M3Yhh0WHOw5hBUcfUpRc/WibAVKcU/vXO03mJDkmPLAD1306vrwjnmPdNVYaw4LwU4vmiV6cShjEAerLw796Z05RGkZwDKUeHhRT/bBFCrJzREl0YDG+veNxV++/+277Vg+shD7euLWAfWDsRaSCyIV1aGfDrUjUJRt7GCxeQgophmMNC4lJFaLzJAcxHvGDLF2tx5ivw0Q6blff/jxxkc/X0KpbTTPOHa3sd5fRlnVlsACZ25XvHffZLRw8hRcr8J/WsGbKgYULcXdZe4tpw3CRuI+U+i6S45wwJTNYC6rUAkOj/yqS30BSw3uNRxtg0liRlVg9s88cpLf4tIlMlSatfVzhbKQD/1UN5NuTxnAR7rDXcyi2y7Qv5RAf4+DZvanvxZr396Pj2AGKHl+7Pb+MaQ/RBnqMeoRo+GRPCdqdk74JHB5X4aThBkNK7OIdPQNc337AtkzQE3TkKHQq2chLeEpnVqOVjpS6gh1GhrW3rxt/tbPu4GGK5k69bcHKJrqSfEu6X0wTHB48dliMzhWOLUwa+F92dEnmYlXc4pzVqeibnyXR3xj5Ql3Q7eIpASHhGFSorOgPMTTDQHP1Vtn0G5a8NnaugVf9yLBqCki1tbzy/fyXsDYea+2lZH8WlxxK1YZyNZ071Chl2PrHR8wR+u9NRlvXNEj4jap7PRg2S8Mlk39DzCjblhyv9SXk1LTchmXOXdMfWrmamWExV3YdYHBIVayGiiRkUSG+2HHsTEg5P87E0tjmtI8Habk4V4yDxnsOMDBKAn5f4s4joLBp9UU6jBOY6+9E6pWHiv4odkMFHn3QrQZfZ2fRoLahLbaStu/+O8o6RP4DdyeAPIPxoV9DygMAAA=";
    protected static final Log log = LogFactory.getLog(StorageUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected BackupPanelUI BACKUP;
    protected ChooseCreationModePanelUI CHOOSE_CREATION_MODE;
    protected ChooseDbModePanelUI CHOOSE_DB_MODE;
    protected ConfigStoragePanelUI CONFIG;
    protected ConfirmPanelUI CONFIRM;
    protected SelectDataPanelUI SELECT_DATA;
    protected JButton applyAction;
    protected JButton cancelAction;
    protected JButton nextAction;
    protected JButton previousAction;
    protected StorageUI storageMain = this;
    protected JTabbedPane tabs;
    private CardLayout $CardLayout0;
    private Table $Table0;
    private boolean contextInitialized;

    public StorageUI(Window owner, JAXXContext parentContext) {
        super(owner);
        this.$initialize();
        UIHelper.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)UIHelper.newContextEntryDef(StorageUIModel.class));
        UIHelper.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)UIHelper.newContextEntryDef((String)"apply", Runnable.class));
        UIHelper.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)UIHelper.newContextEntryDef((String)"cancel", Runnable.class));
        if (owner != null) {
            this.setContextValue(owner, "parent");
        }
        UIHelper.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.contextInitialized = true;
        JAXXUtil.assignment((boolean)true, (String)"contextInitialized", (JAXXObject)this);
        this.$initialize();
    }

    public void destroy() {
        this.getModel().destroy();
        log.debug((Object)("destroy ui " + this.getName()));
        SwingUtil.TabbedPaneIterator itr = UIHelper.newTabbedPaneIterator((JTabbedPane)this.getTabs());
        while (itr.hasNext()) {
            AbstractStorageTabPanelUI tab = (AbstractStorageTabPanelUI)itr.next();
            log.debug((Object)("destroy ui " + tab.getName()));
            tab.destroy();
        }
        UIHelper.destroy((Component)this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public StorageUIModel getModel() {
        return this.getContextValue(StorageUIModel.class);
    }

    public void start() {
        this.getModel().start();
        UIHelper.center((Component)this.getContextValue(Window.class, "parent"), (Component)this);
        this.setVisible(true);
    }

    public StorageStep getSelectedStep() {
        int index = this.tabs.getSelectedIndex();
        AbstractStorageTabPanelUI c = null;
        if (index > -1) {
            c = (AbstractStorageTabPanelUI)this.tabs.getComponentAt(index);
        }
        StorageStep result = c == null ? null : c.getStep();
        return result;
    }

    public AbstractStorageTabPanelUI getStepUI(StorageStep step) {
        if (step != null) {
            return (AbstractStorageTabPanelUI)this.getObjectById(step.name());
        }
        return null;
    }

    public AbstractStorageTabPanelUI getStepUI(int stepIndex) {
        if (stepIndex > this.tabs.getTabCount()) {
            return null;
        }
        return (AbstractStorageTabPanelUI)this.tabs.getComponentAt(stepIndex);
    }

    public AbstractStorageTabPanelUI getSelectedStepUI() {
        StorageStep step = this.getSelectedStep();
        AbstractStorageTabPanelUI ui = this.getStepUI(step);
        return ui;
    }

    public void onWasStarted() {
        this.getTabs().setTitleAt(0, I18n._((String)"observe.synchro.step.progression"));
    }

    public void onModelStateChanged(WizardOperationState newState) {
    }

    public void onOperationStateChanged(StorageStep step, WizardOperationState newState) {
    }

    public void onStepChanged(StorageStep newStep) {
    }

    public void onStepsChanged(StorageStep[] steps) {
    }

    public StorageUIHandler getHandler() {
        return this.getContextValue(StorageUIHandler.class);
    }

    public void apply() {
        ObserveContext.runAction("apply action", this.getHandler(), "launchApply", this);
    }

    public void cancel() {
        ObserveContext.runAction("cancel action", this.getHandler(), "launchCancel", this);
    }

    @Override
    public void dispose() {
        log.info((Object)("dispose storage ui " + this));
        this.destroy();
        super.dispose();
    }

    void $afterCompleteSetup() {
        this.getModel().addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                StorageStep oldStep = (StorageStep)((Object)evt.getOldValue());
                StorageStep newStep = (StorageStep)((Object)evt.getNewValue());
                log.debug((Object)("step has changed <old:" + (Object)((Object)oldStep) + ", new:" + (Object)((Object)newStep) + ">"));
                int oldStepIndex = oldStep == null ? -1 : model.getStepIndex(oldStep);
                int newStepIndex = model.getStepIndex(newStep);
                if (oldStepIndex + 1 == newStepIndex) {
                    AbstractStorageTabPanelUI c = (AbstractStorageTabPanelUI)StorageUI.this.getObjectById(newStep.name());
                    String title = I18n._((String)newStep.getLabel());
                    String tip = I18n._((String)newStep.getDescription());
                    StorageUI.this.tabs.addTab(title, null, c, tip);
                    int index = StorageUI.this.tabs.indexOfComponent(c);
                    if (index > -1) {
                        StorageUI.this.tabs.setSelectedIndex(index);
                    }
                } else if (oldStepIndex > newStepIndex) {
                    int index = newStepIndex + 1;
                    while (StorageUI.this.tabs.getTabCount() > index) {
                        log.trace((Object)("remove tab : " + index));
                        StorageUI.this.tabs.remove(index);
                    }
                } else {
                    throw new IllegalStateException("can not go from " + (Object)((Object)oldStep) + " to " + (Object)((Object)newStep));
                }
            }
        });
        this.getModel().init((JAXXContext)this);
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public StorageUI() {
        this.$initialize();
    }

    public StorageUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__applyAction(ActionEvent event) {
        this.apply();
    }

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        this.cancel();
    }

    public void doActionPerformed__on__nextAction(ActionEvent event) {
        this.getModel().gotoNextStep();
    }

    public void doActionPerformed__on__previousAction(ActionEvent event) {
        this.getModel().gotoPreviousStep();
    }

    public void doStateChanged__on__tabs(ChangeEvent event) {
        this.getModel().gotoStep(this.getSelectedStep());
    }

    public JButton getApplyAction() {
        return this.applyAction;
    }

    public BackupPanelUI getBACKUP() {
        return this.BACKUP;
    }

    public ChooseCreationModePanelUI getCHOOSE_CREATION_MODE() {
        return this.CHOOSE_CREATION_MODE;
    }

    public ChooseDbModePanelUI getCHOOSE_DB_MODE() {
        return this.CHOOSE_DB_MODE;
    }

    public ConfigStoragePanelUI getCONFIG() {
        return this.CONFIG;
    }

    public ConfirmPanelUI getCONFIRM() {
        return this.CONFIRM;
    }

    public JButton getCancelAction() {
        return this.cancelAction;
    }

    public JButton getNextAction() {
        return this.nextAction;
    }

    public JButton getPreviousAction() {
        return this.previousAction;
    }

    public SelectDataPanelUI getSELECT_DATA() {
        return this.SELECT_DATA;
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    protected CardLayout get$CardLayout0() {
        return this.$CardLayout0;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected void addChildrenToStorageMain() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.add(this.CHOOSE_DB_MODE);
        this.add(this.CHOOSE_CREATION_MODE);
        this.add(this.CONFIG);
        this.add(this.BACKUP);
        this.add(this.SELECT_DATA);
        this.add(this.CONFIRM);
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.$Table0, "South");
    }

    protected void createApplyAction() {
        this.applyAction = new JButton();
        this.$objectMap.put("applyAction", this.applyAction);
        this.applyAction.setName("applyAction");
        this.applyAction.setText(I18n._((String)"observe.action.storage.apply"));
        this.applyAction.setToolTipText(I18n._((String)"observe.action.storage.apply.tip"));
        this.applyAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__applyAction"));
    }

    protected void createBACKUP() {
        this.BACKUP = new BackupPanelUI((JAXXContext)this);
        this.$objectMap.put("BACKUP", this.BACKUP);
        this.BACKUP.setName("BACKUP");
    }

    protected void createCHOOSE_CREATION_MODE() {
        this.CHOOSE_CREATION_MODE = new ChooseCreationModePanelUI((JAXXContext)this);
        this.$objectMap.put("CHOOSE_CREATION_MODE", this.CHOOSE_CREATION_MODE);
        this.CHOOSE_CREATION_MODE.setName("CHOOSE_CREATION_MODE");
    }

    protected void createCHOOSE_DB_MODE() {
        this.CHOOSE_DB_MODE = new ChooseDbModePanelUI((JAXXContext)this);
        this.$objectMap.put("CHOOSE_DB_MODE", this.CHOOSE_DB_MODE);
        this.CHOOSE_DB_MODE.setName("CHOOSE_DB_MODE");
    }

    protected void createCONFIG() {
        this.CONFIG = new ConfigStoragePanelUI((JAXXContext)this);
        this.$objectMap.put("CONFIG", this.CONFIG);
        this.CONFIG.setName("CONFIG");
    }

    protected void createCONFIRM() {
        this.CONFIRM = new ConfirmPanelUI((JAXXContext)this);
        this.$objectMap.put("CONFIRM", this.CONFIRM);
        this.CONFIRM.setName("CONFIRM");
    }

    protected void createCancelAction() {
        this.cancelAction = new JButton();
        this.$objectMap.put("cancelAction", this.cancelAction);
        this.cancelAction.setName("cancelAction");
        this.cancelAction.setText(I18n._((String)"observe.action.cancel"));
        this.cancelAction.setToolTipText(I18n._((String)"observe.action.storage.cancel.tip"));
        this.cancelAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancelAction"));
    }

    protected void createNextAction() {
        this.nextAction = new JButton();
        this.$objectMap.put("nextAction", this.nextAction);
        this.nextAction.setName("nextAction");
        this.nextAction.setText(I18n._((String)"observe.action.goto.next.stage"));
        this.nextAction.setToolTipText(I18n._((String)"observe.action.goto.next.stage.tip"));
        this.nextAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__nextAction"));
    }

    protected void createPreviousAction() {
        this.previousAction = new JButton();
        this.$objectMap.put("previousAction", this.previousAction);
        this.previousAction.setName("previousAction");
        this.previousAction.setText(I18n._((String)"observe.action.goto.previous.stage"));
        this.previousAction.setToolTipText(I18n._((String)"observe.action.goto.previous.stage.tip"));
        this.previousAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__previousAction"));
    }

    protected void createSELECT_DATA() {
        this.SELECT_DATA = new SelectDataPanelUI((JAXXContext)this);
        this.$objectMap.put("SELECT_DATA", this.SELECT_DATA);
        this.SELECT_DATA.setName("SELECT_DATA");
    }

    protected void createTabs() {
        this.tabs = new JTabbedPane();
        this.$objectMap.put("tabs", this.tabs);
        this.tabs.setName("tabs");
        this.tabs.addChangeListener((ChangeListener)JAXXUtil.getEventListener(ChangeListener.class, (String)"stateChanged", (Object)this, (String)"doStateChanged__on__tabs"));
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToStorageMain();
        this.$Table0.add((Component)this.cancelAction, (Object)new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.previousAction, (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.nextAction, (Object)new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.applyAction, (Object)new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.tabs.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.cancelAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"cancel"));
        this.previousAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"previous-step"));
        this.nextAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"next-step"));
        this.applyAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"accept"));
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$registerDefaultBindings();
        this.$objectMap.put("storageMain", this);
        this.$CardLayout0 = new CardLayout();
        this.$objectMap.put("$CardLayout0", this.$CardLayout0);
        this.createCHOOSE_DB_MODE();
        this.createCHOOSE_CREATION_MODE();
        this.createCONFIG();
        this.createBACKUP();
        this.createSELECT_DATA();
        this.createCONFIRM();
        this.createTabs();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.createCancelAction();
        this.createPreviousAction();
        this.createNextAction();
        this.createApplyAction();
        this.setName("storageMain");
        this.setDefaultCloseOperation(2);
        SwingUtil.setComponentHeight((Component)this.storageMain, (int)600);
        SwingUtil.setComponentWidth((Component)this.storageMain, (int)550);
        this.setTitle(I18n._((String)"observe.title.change.storage"));
        this.storageMain.getContentPane().setLayout(new BorderLayout());
        this.setResizable(true);
        this.setModal(true);
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_PREVIOUS_ACTION_ENABLED, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.previousAction.setEnabled(StorageUI.this.getModel().getPreviousStep() != null);
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_ENABLED, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.nextAction.setEnabled(StorageUI.this.getModel().isValidStep());
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.nextAction.setVisible(StorageUI.this.getModel().getNextStep() != null);
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_APPLY_ACTION_ENABLED, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.applyAction.setEnabled(StorageUI.this.getModel().isValidStep());
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_APPLY_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.applyAction.setVisible(StorageUI.this.getModel().getNextStep() == null);
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

