/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.ProgrammeImpl;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ProgrammeUI;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ProgrammeHandler
extends ObserveContentHandler<Void, Programme, ProgrammeUI> {
    private static final Log log = LogFactory.getLog(ProgrammeHandler.class);

    public ProgrammeHandler() {
        super(Void.class, Programme.class, new String[0]);
    }

    public void addMaree(ProgrammeUI context) {
        NavigationTreeNode parentNode = ProgrammeHandler.getSelectedNode(context);
        NavigationTreeNode node = ProgrammeHandler.getTreeBuilder((JAXXContext)context).addMaree(parentNode, null);
        ProgrammeHandler.repaintNode((JAXXContext)context, parentNode, true);
        ProgrammeHandler.selectNode((JAXXContext)context, node);
    }

    public void gotoMaree(ProgrammeUI context, Maree selectedMaree) {
        if (selectedMaree == null) {
            return;
        }
        NavigationTreeNode parentNode = ProgrammeHandler.getSelectedNode(context);
        NavigationTreeNode node = parentNode.getChild(selectedMaree.getTopiaId());
        ProgrammeHandler.selectNode((JAXXContext)context, node);
    }

    @Override
    public void openUI(ProgrammeUI context) throws Exception {
        ObserveDataContext dataContext;
        List<Maree> marees;
        super.openUI(context);
        Programme programme = ProgrammeHandler.getData((JAXXContext)context, Programme.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        ProgrammeImpl editBean = context.getEditBean();
        this.loador.load((Object)programme, (Object)editBean, true, new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("programme to load " + programme));
        }
        if ((marees = (List<Maree>)(dataContext = ProgrammeHandler.getDataContext((JAXXContext)context)).getData().get(programme)) == null) {
            marees = Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("marres of programme " + marees));
        }
        context.setMarees(marees);
        context.setMode(mode);
        Decorator decorator = this.getDecoratorService().getDecorator(Programme.class);
        context.setContentTitle(decorator.toString((Object)programme));
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ProgrammeUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        Programme programme = ProgrammeHandler.getData((JAXXContext)context, Programme.class);
        ObserveDataContext dataContext = ProgrammeHandler.getDataContext((JAXXContext)context);
        Maree openMaree = dataContext.getOpenMaree();
        if (mode == null) {
            if (openMaree == null) {
                mode = ObserveContentMode.CREATE;
                ProgrammeHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Programme.class), I18n._((String)"observe.message.no.active.maree.found"));
            } else if (programme.equals(openMaree.getProgramme())) {
                mode = ObserveContentMode.UPDATE;
                ProgrammeHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Programme.class), I18n._((String)"observe.message.active.maree.found"));
            } else {
                mode = ObserveContentMode.READ;
                ProgrammeHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Programme.class), I18n._((String)"observe.message.active.maree.found.for.other.programme"));
            }
        }
        return mode;
    }
}

