/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EstimationBanc;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentTableHandler;
import fr.ird.observe.ui.content.ObserveContentTableModel;
import fr.ird.observe.ui.content.ObserveContentTableUI;
import fr.ird.observe.ui.content.data.EstimationBancUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.EntityComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EstimationBancHandler
extends ObserveContentTableHandler<Calee, EstimationBanc, EstimationBancUI> {
    private static Log log = LogFactory.getLog(EstimationBancHandler.class);
    JAXXContextEntryDef<List<EspeceThon>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");

    public EstimationBancHandler() {
        super("estimationBanc", Calee.class, EstimationBanc.class, new String[]{"commentaire", "estimationBanc"}, new String[]{"calee", "espece", "poids", "poidsIndividuel"});
    }

    @Override
    public ObserveContentTableModel<Calee, EstimationBanc> newTableModel(ObserveContentTableUI<Calee, EstimationBanc> context) {
        ArrayList metas = new ArrayList();
        metas.add(this.newTableMeta("espece", false));
        metas.add(this.newTableMeta("poids", false));
        metas.add(this.newTableMeta("poidsIndividuel", false));
        return new ObserveContentTableModel<Calee, EstimationBanc>(context, metas);
    }

    @Override
    protected Calee loadEditBean(EstimationBancUI ui, ObserveContentMode mode) {
        ObserveDataContext dataContext = EstimationBancHandler.getDataContext((JAXXContext)ui);
        ArrayList especeList = new ArrayList(dataContext.getEntityList(EspeceThon.class));
        UIHelper.filterReferentielList(especeList, null);
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)ui, especeList);
        return (Calee)super.loadEditBean(ui, mode);
    }

    @Override
    protected void onSelectedRowChanged(EstimationBancUI context, ObserveContentTableModel<Calee, EstimationBanc> model, int editingRow, EstimationBanc bean, boolean create) {
        EntityComboBox<EspeceThon> requestFocus;
        List<Object> availableEspeces;
        if (!model.isEditable()) {
            return;
        }
        if (create) {
            availableEspeces = new ArrayList((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)context));
            List list = model.getColumnValues(0);
            availableEspeces.removeAll(list);
            list.clear();
            requestFocus = context.getEspece();
        } else {
            EspeceThon espece = bean.getEspece();
            availableEspeces = Arrays.asList(espece);
            requestFocus = context.getPoids();
        }
        context.getEspece().setData(availableEspeces);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(EstimationBancUI context, DefaultTableCellRenderer renderer) {
        JTable table = context.getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.estimationBanc.especeThon"), I18n.n_((String)"observe.table.estimationBanc.especeThon.tip"), I18n.n_((String)"observe.table.estimationBanc.poids"), I18n.n_((String)"observe.table.estimationBanc.poids.tip"), I18n.n_((String)"observe.table.estimationBanc.poidsIndividuel"), I18n.n_((String)"observe.table.estimationBanc.poidsIndividuel.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected boolean prepareSave(EstimationBancUI context, Calee toSave, Calee editBean, List<EstimationBanc> objets) {
        for (EstimationBanc estimationBanc : objets) {
            estimationBanc.setCalee(toSave);
        }
        return super.prepareSave(context, toSave, editBean, objets);
    }
}

