/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureThon;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentTableHandler;
import fr.ird.observe.ui.content.ObserveContentTableModel;
import fr.ird.observe.ui.content.ObserveContentTableUI;
import fr.ird.observe.ui.content.data.EchantillonThonUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EchantillonThonHandler
extends ObserveContentTableHandler<EchantillonThon, TailleThon, EchantillonThonUI> {
    private static Log log = LogFactory.getLog(EchantillonThonHandler.class);

    public EchantillonThonHandler() {
        super("tailleThon", EchantillonThon.class, TailleThon.class, new String[]{"commentaire", "tailleThon"}, new String[]{"echantillonThon", "espece", "longueur", "effectif"});
    }

    @Override
    public ObserveContentTableModel<EchantillonThon, TailleThon> newTableModel(ObserveContentTableUI<EchantillonThon, TailleThon> context) {
        ArrayList metas = new ArrayList();
        metas.add(this.newTableMeta("espece", true));
        metas.add(this.newTableMeta("longueur", true));
        metas.add(this.newTableMeta("effectif", false));
        return new ObserveContentTableModel<EchantillonThon, TailleThon>(context, metas);
    }

    @Override
    protected boolean prepareSave(EchantillonThonUI context, EchantillonThon toSave, EchantillonThon editBean, List<TailleThon> objets) {
        for (TailleThon tailleThon : objets) {
            tailleThon.setEchantillonThon(toSave);
        }
        return super.prepareSave(context, toSave, editBean, objets);
    }

    @Override
    protected EchantillonThon loadEditBean(EchantillonThonUI ui, ObserveContentMode mode) {
        ArrayList<EspeceThon> especes = new ArrayList<EspeceThon>();
        Calee calee = EchantillonThonHandler.getData((JAXXContext)ui, Calee.class);
        Collection captures = calee.getCaptureThon();
        if (captures != null) {
            for (CaptureThon capture : captures) {
                if (!capture.getSurLePont() || !capture.getRejete() || especes.contains(capture.getCategoriePoids().getEspece())) continue;
                especes.add(capture.getCategoriePoids().getEspece());
            }
        }
        ui.getEspece().setData(especes);
        return (EchantillonThon)super.loadEditBean(ui, mode);
    }

    @Override
    protected void onSelectedRowChanged(EchantillonThonUI context, ObserveContentTableModel<EchantillonThon, TailleThon> model, int editingRow, TailleThon bean, boolean create) {
        EntityComboBox<EspeceThon> requestFocus;
        if (!model.isEditable()) {
            return;
        }
        EspeceThon espece = bean.getEspece();
        if (create) {
            if (model.isCreate() && editingRow > 0) {
                model.getValueAt(editingRow - 1);
                espece = model.getValueAt(editingRow - 1).getEspece();
            }
            requestFocus = context.getEspece();
        } else {
            requestFocus = context.getEffectif();
        }
        context.getEspece().setSelectedItem(null);
        if (espece != null) {
            log.debug((Object)("espece to use " + espece));
            context.getEspece().setSelectedItem((Object)espece);
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(EchantillonThonUI context, DefaultTableCellRenderer renderer) {
        JTable table = context.getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonThon.especeThon"), I18n.n_((String)"observe.table.echantillonThon.especeThon.tip"), I18n.n_((String)"observe.table.echantillonThon.longueur"), I18n.n_((String)"observe.table.echantillonThon.longueur.tip"), I18n.n_((String)"observe.table.echantillonThon.effectif"), I18n.n_((String)"observe.table.echantillonThon.effectif.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected ObserveContentMode getObserveContentMode(EchantillonThonUI context) {
        Calee calee;
        boolean canEdit;
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == ObserveContentMode.UPDATE && !(canEdit = (calee = EchantillonThonHandler.getData((JAXXContext)context, Calee.class)).canUseEchantillonThon())) {
            mode = ObserveContentMode.READ;
            EchantillonThonHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Calee.class), I18n._((String)"observe.message.calee.no.rejetThon"));
        }
        return mode;
    }
}

