/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureFaune;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.SexeEnum;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentTableHandler;
import fr.ird.observe.ui.content.ObserveContentTableMeta;
import fr.ird.observe.ui.content.ObserveContentTableModel;
import fr.ird.observe.ui.content.ObserveContentTableUI;
import fr.ird.observe.ui.content.data.EchantillonFauneUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EchantillonFauneHandler
extends ObserveContentTableHandler<EchantillonFaune, TailleFaune, EchantillonFauneUI> {
    private static Log log = LogFactory.getLog(EchantillonFauneHandler.class);
    JAXXContextEntryDef<List<EspeceFaune>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");

    public EchantillonFauneHandler() {
        super("tailleFaune", EchantillonFaune.class, TailleFaune.class, new String[]{"commentaire", "tailleFaune"}, new String[]{"espece", "longueur", "sexe", "referencePhoto"});
    }

    @Override
    public ObserveContentTableModel<EchantillonFaune, TailleFaune> newTableModel(ObserveContentTableUI<EchantillonFaune, TailleFaune> context) {
        ArrayList metas = new ArrayList();
        metas.add(this.newTableMeta("espece", false));
        metas.add(this.newTableMeta("longueur", false));
        metas.add(new ObserveContentTableMeta<TailleFaune>(TailleFaune.class, "sexe", false){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNullValue(ObserveContentTableModel m, TailleFaune bean, int row) {
                return bean.getSexe() == -1;
            }
        });
        metas.add(this.newTableMeta("referencePhoto", false));
        return new ObserveContentTableModel<EchantillonFaune, TailleFaune>(context, metas);
    }

    @Override
    protected EchantillonFaune loadEditBean(EchantillonFauneUI ui, ObserveContentMode mode) {
        Collection captures;
        ArrayList<EspeceFaune> especes = new ArrayList<EspeceFaune>();
        Calee calee = EchantillonFauneHandler.getData((JAXXContext)ui, Calee.class);
        if (mode == ObserveContentMode.UPDATE && (captures = calee.getCaptureFaune()) != null) {
            for (CaptureFaune capture : captures) {
                if (especes.contains(capture.getEspece())) continue;
                especes.add(capture.getEspece());
            }
        }
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)ui, especes);
        return (EchantillonFaune)super.loadEditBean(ui, mode);
    }

    @Override
    protected ObserveContentMode getObserveContentMode(EchantillonFauneUI context) {
        Calee calee;
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == ObserveContentMode.UPDATE && !(calee = EchantillonFauneHandler.getData((JAXXContext)context, Calee.class)).canUseEchantillonFaune()) {
            mode = ObserveContentMode.READ;
            EchantillonFauneHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Calee.class), I18n._((String)"observe.message.calee.no.rejetFaune"));
        }
        return mode;
    }

    @Override
    protected void onSelectedRowChanged(EchantillonFauneUI context, ObserveContentTableModel<EchantillonFaune, TailleFaune> model, int editingRow, TailleFaune bean, boolean create) {
        EntityComboBox<EspeceFaune> requestFocus;
        List<EspeceFaune> availableEspeces;
        EspeceFaune espece;
        EspeceFaune especeFaune = espece = bean == null ? null : bean.getEspece();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected espece " + espece));
        }
        if (create) {
            availableEspeces = new ArrayList<EspeceFaune>((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)context));
            requestFocus = context.getEspece();
        } else {
            availableEspeces = Arrays.asList(espece);
            requestFocus = context.getLongueur();
        }
        context.getEspece().setData(availableEspeces);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(EchantillonFauneUI context, DefaultTableCellRenderer renderer) {
        JTable table = context.getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonFaune.especeFaune"), I18n.n_((String)"observe.table.echantillonFaune.especeFaune.tip"), I18n.n_((String)"observe.table.echantillonFaune.longueur"), I18n.n_((String)"observe.table.echantillonFaune.longueur.tip"), I18n.n_((String)"observe.table.echantillonFaune.sexe"), I18n.n_((String)"observe.table.echantillonFaune.sexe.tip"), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto"), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, SexeEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)renderer);
    }
}

