/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.ui.content.ObserveContentTableModel;
import javax.swing.DefaultListSelectionModel;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveContentTableListSelectionModel
extends DefaultListSelectionModel {
    private static Log log = LogFactory.getLog(ObserveContentTableListSelectionModel.class);
    private static final long serialVersionUID = 1L;
    protected JAXXContext context;
    protected ObserveContentTableModel<?, ?> tableModel;

    public ObserveContentTableListSelectionModel(JAXXContext context) {
        this.context = context;
    }

    public ObserveContentTableModel<?, ?> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = (ObserveContentTableModel)this.context.getContextValue(ObserveContentTableModel.class);
        }
        return this.tableModel;
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(index0 + " - " + index1));
        }
        ObserveContentTableModel<?, ?> model = this.getTableModel();
        boolean canContinue = this.canContinue(model, index0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("can continue  for row " + index0 + " : " + canContinue));
        }
        if (canContinue) {
            super.setSelectionInterval(index0, index1);
        }
    }

    protected boolean canContinue(ObserveContentTableModel<?, ?> model, int newIndex) {
        if (model == null) {
            return false;
        }
        if (!model.isEditable()) {
            return true;
        }
        if (model.isValueAdjusting()) {
            return true;
        }
        int editingRow = model.getSelectedRow();
        if (this.isSelectionEmpty() || editingRow == -1) {
            return true;
        }
        if (editingRow == newIndex) {
            return true;
        }
        boolean canContinue = model.isCanQuitEditingRow();
        return canContinue;
    }
}

