/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveBinderHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.services.DecoratorService;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.services.storage.StorageServiceImplementor;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.content.ObserveContentActions;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.tree.ObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.tree.ObserveTreeModelBuilder;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.Creator;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.Loador;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public class ObserveContentHandler<P, E extends TopiaEntity, UI extends ObserveContentUI<E>>
implements JAXXAction {
    private static final Log log = LogFactory.getLog(ObserveContentHandler.class);
    protected Class<P> parentEntityClass;
    protected Class<E> mainEntityClass;
    protected String[] properties;
    protected Creator<P, E> preCreator;
    protected Creator<P, E> creator;
    protected Deletor<P, E> deletator;
    protected Loador<E> loador;

    public ObserveContentHandler() {
    }

    public ObserveContentHandler(Class<P> parentEntityClass, Class<E> mainEntityClass, String ... properties) {
        this.parentEntityClass = parentEntityClass;
        this.mainEntityClass = mainEntityClass;
        this.properties = properties;
        this.loador = this.getBinder();
        this.preCreator = new Creator<P, E>(){

            public E create(P parent, E from) throws TopiaException {
                return ObserveContentHandler.this.onPreCreate(parent, from);
            }
        };
        this.creator = new Creator<P, E>(){

            public E create(P parent, E from) throws TopiaException {
                return ObserveContentHandler.this.onCreate(parent, from);
            }
        };
        this.deletator = new Deletor<P, E>(){

            public void delete(P parent, E from) {
                ObserveContentHandler.this.onDelete(parent, from);
            }
        };
    }

    public JAXXInitialContext init(JAXXContext parentContext, Object ... datas) {
        return new JAXXInitialContext().add((Object)parentContext).add((Object)this);
    }

    public DecoratorService getDecoratorService() {
        DecoratorService result = ObserveContext.get().getDecoratorService();
        return result;
    }

    public static void addMessage(ObserveContent<?> ui, BeanValidatorScope scope, String fieldName, String message) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.addMessages((JComponent)((Object)ui), fieldName, scope, new String[]{message});
    }

    public static void removeAllMessages(ObserveContent<?> ui, BeanValidatorScope scope, String fieldName) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages((JComponent)((Object)ui), fieldName, scope);
    }

    public static void removeAllMessages(ObserveContent<?> ui) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages((JComponent)((Object)ui), null);
    }

    protected static ObserveDataContext getDataContext(JAXXContext context) {
        return (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
    }

    protected static <E extends TopiaEntity> E getData(JAXXContext context, Class<E> entityClass) {
        ObserveDataContext dataContext = ObserveContentHandler.getDataContext(context);
        return (E)dataContext.getEntity(entityClass);
    }

    public static ObserveTreeHelper getTreeHelper(JAXXContext context) {
        return (ObserveTreeHelper)((Object)context.getContextValue(ObserveTreeHelper.class));
    }

    public static ObserveTreeModelBuilder getTreeBuilder(JAXXContext context) {
        return ObserveContentHandler.getTreeHelper(context).getBuilder();
    }

    protected String getValidatorContextName(ObserveContentMode mode) {
        String contextName = mode == ObserveContentMode.CREATE ? "n1-create" : "n1-update";
        return contextName;
    }

    public void initUI(UI ui) throws Exception {
        if (ObserveContentUI.log.isDebugEnabled()) {
            ObserveContentUI.log.debug((Object)("ui " + this.getClass()));
        }
        ObserveMainUI mainUI = ((ObserveContentUI)ui).getParentContainer(ObserveMainUI.class);
        ActionMap actionMap = mainUI.getRootPane().getActionMap();
        StorageService<?> service = ObserveContentHandler.getStorageService(ui);
        for (String name : ((ObserveContentUI)ui).get$objectMap().keySet()) {
            Object o = ((ObserveContentUI)ui).getObjectById(name);
            if (o == null) continue;
            if (o instanceof TopiaEntity) {
                this.init(service, ui, (TopiaEntity)o);
                continue;
            }
            if (o instanceof AbstractButton) {
                this.init(service, ui, mainUI, actionMap, (AbstractButton)o);
                continue;
            }
            if (o instanceof NumberEditor) {
                this.init(service, ui, (NumberEditor)o);
                continue;
            }
            if (o instanceof EntityComboBox) {
                this.init(service, ui, (EntityComboBox)o);
                continue;
            }
            if (o instanceof JList) {
                this.init(service, ui, (JList)o);
                continue;
            }
            if (o instanceof JXDatePicker) {
                this.init(service, ui, (JXDatePicker)o);
                continue;
            }
            if (!(o instanceof TimeEditor)) continue;
            this.init(service, ui, (TimeEditor)o);
        }
    }

    public void openUI(UI ui) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ui " + ui.getClass()));
        }
        ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.setContextValue((JAXXContext)ObserveContext.get(), ui);
        ObserveTreeHelper treeHelper = ObserveContentHandler.getTreeHelper(ui);
        ObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer((JAXXContext)ui);
        NavigationTreeNode node = (NavigationTreeNode)treeHelper.getSelectedNode((JAXXContext)ui);
        ((ObserveContentUI)ui).setContentIcon(render.getNavigationIcon(node));
        this.updateActions(ui);
    }

    public void startEditUI(UI ui, E o, E editBean, String ... binding) {
        BeanValidatorUtil.setValidatorBean(ui, null, (String[])new String[0]);
        ((ObserveContentUI)ui).setEditing(true);
        if (o != null) {
            ((ObserveContentUI)ui).setContextValue(o, "edit");
        }
        BeanValidatorUtil.setValidatorBean(ui, editBean, (String[])new String[0]);
        if (binding.length > 0) {
            UIHelper.processDataBinding(ui, (String[])binding);
        }
        UIHelper.processDataBinding(ui, (String[])new String[]{"reset.enabled", "save.enabled"});
    }

    public void resetEditUI(UI context) {
        this.stopEditUI(context);
        ObserveContentHandler.removeAllMessages(context);
        try {
            this.openUI(context);
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
            log.error((Object)ex.getMessage(), (Throwable)ex);
            this.stopEditUI(context);
        }
    }

    public void restartEditUI(UI context) {
        if (((ObserveContentUI)context).isEditable().booleanValue()) {
            NavigationTreeNode node = ObserveContentHandler.getSelectedNode(context);
            ObserveContentHandler.removeAllMessages(context);
            ObserveContentHandler.repaintNode(context, node, true);
            ((ObserveContentUI)context).setMode(ObserveContentMode.UPDATE);
            TopiaEntity b = (TopiaEntity)node.getBean(context);
            ((ObserveContentUI)context).startEdit((TopiaEntity)b);
            this.updateActions(context);
        }
    }

    public void stopEditUI(UI ui) {
        ((ObserveContentUI)ui).setEditing(false);
        ((ObserveContentUI)ui).setEditionValid(true);
        ((ObserveContentUI)ui).setModified(false);
        ((ObserveContentUI)ui).removeContextValue(((ObserveContentUI)ui).getInternalClass(), "edit");
        BeanValidatorUtil.setValidatorBean(ui, null, (String[])new String[0]);
    }

    public boolean closeUI(UI ui) throws Exception {
        boolean b = ObserveContentHandler.checkEdit(ui);
        if (b) {
            ObserveTreeHelper treehelper;
            NavigationTreeNode node;
            ObserveContentHandler.removeAllMessages(ui);
            ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.removeContextValue((JAXXContext)ObserveContext.get());
            boolean create = ((ObserveContentUI)ui).isCreatingMode();
            if (create && ((ObserveContentUI)ui).isEditable().booleanValue() && (node = (NavigationTreeNode)(treehelper = ((ObserveContentUI)ui).getContextValue(ObserveTreeHelper.class)).getSelectedNode((JAXXContext)ui)).getParent() != null) {
                treehelper.getBuilder().removeChildNode((NavigationNode)node);
            }
        }
        return b;
    }

    protected E onPreCreate(P parentBean, E bean) throws TopiaException {
        return bean;
    }

    protected E onCreate(P parentBean, E bean) throws TopiaException {
        TopiaEntity beanToSave = this.getDAO(bean).create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        return (E)beanToSave;
    }

    protected void onDelete(P parentBean, E bean) {
    }

    protected <D extends TopiaDAO<E>> TopiaDAO<E> getDAO(E bean) throws TopiaException {
        TopiaContext ctx = bean.getTopiaContext();
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)ctx, bean);
        return dao;
    }

    protected TopiaEntityBinder<E> getBinder() {
        TopiaEntityBinder<E> binder = this.getBinder(this.mainEntityClass);
        if (binder == null) {
            BinderBuilder builder = new BinderBuilder(this.mainEntityClass, this.properties);
            binder = this.registerBinder(this.mainEntityClass, builder);
            binder.setEmpty(this.getImplementationInstance());
        }
        return binder;
    }

    protected <X extends TopiaEntity> TopiaEntityBinder<X> getBinder(Class<X> entityclass) {
        return ObserveContentHandler.getBinder(entityclass, this.getClass().getName());
    }

    protected <X extends TopiaEntity> TopiaEntityBinder<X> registerBinder(Class<X> entityclass, BinderBuilder builder) {
        ObserveBinderHelper.registerTopiaBinder((BinderBuilder)builder, (String)this.getClass().getName());
        return ObserveContentHandler.getBinder(entityclass, this.getClass().getName());
    }

    public static <X extends TopiaEntity> TopiaEntityBinder<X> getBinder(Class<X> entityclass, String contextName) {
        TopiaEntityBinder binder = ObserveBinderHelper.getTopiaBinder(entityclass, (String)contextName);
        return binder;
    }

    public static <X extends TopiaEntity> TopiaEntityBinder<X> getSimpleBinder(Class<X> entityclass) {
        TopiaEntityBinder binder = ObserveBinderHelper.getSimpleTopiaBinder(entityclass);
        return binder;
    }

    protected static <X extends TopiaEntity> TopiaEntityBinder<X> registerBinder(Class<X> entityclass, BinderBuilder builder, String contextName) {
        ObserveBinderHelper.registerTopiaBinder((BinderBuilder)builder, (String)contextName);
        return ObserveContentHandler.getBinder(entityclass, contextName);
    }

    protected E getImplementationInstance() {
        ObserveDAOHelper.ObserveEntityEnum constant = ObserveDAOHelper.ObserveEntityEnum.valueOf(this.mainEntityClass);
        Class impl = constant.getImplementation();
        try {
            TopiaEntity beanInstance = (TopiaEntity)impl.newInstance();
            return (E)beanInstance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not instanciate constant " + constant + " : " + impl, e);
        }
    }

    protected static NavigationTreeNode getSelectedNode(ObserveContent<?> context) {
        ObserveTreeHelper treehelper = ObserveContentHandler.getTreeHelper(context);
        return (NavigationTreeNode)treehelper.getSelectedNode((JAXXContext)context);
    }

    public static void selectNode(JAXXContext context, NavigationTreeNode node) {
        ObserveTreeHelper treeBuilder = ObserveContentHandler.getTreeHelper(context);
        treeBuilder.selectNode(context, (NavigationNode)node);
    }

    public static void repaintNode(JAXXContext context, NavigationTreeNode node, boolean deep) {
        ObserveTreeHelper treeBuilder = ObserveContentHandler.getTreeHelper(context);
        treeBuilder.repaintNode(context, (NavigationNode)node, deep);
    }

    public static void repaintNode(JAXXContext context, NavigationTreeNode node) {
        ObserveTreeHelper treeBuilder = ObserveContentHandler.getTreeHelper(context);
        treeBuilder.repaintNode(context, (NavigationNode)node);
    }

    protected String getEntityLabel(Class<?> klass) {
        String result = this.getDecoratorService().getEntityLabel(klass);
        return result;
    }

    protected void closeOpenable(UI context, Openable bean, String message) {
        ((ObserveContentUI)context).stopEdit();
        ((ObserveContentUI)context).setMode(ObserveContentMode.READ);
        ObserveContentHandler.removeAllMessages(context);
        ObserveContentHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(bean.getClass()), message);
        NavigationTreeNode selectedNode = ObserveContentHandler.getSelectedNode(context);
        if (bean instanceof Maree) {
            selectedNode = selectedNode.getParent();
        }
        ObserveContentHandler.repaintNode(context, selectedNode, true);
        this.updateActions(context);
    }

    protected static void closeOpenable(Openable o) {
        o.setOpen(false);
        Openable openChild = o.getOpenChild();
        if (openChild != null) {
            ObserveContentHandler.closeOpenable(openChild);
        }
    }

    public void createUI(UI context) {
    }

    public void modifyUI(UI context) {
    }

    public void saveUI(UI context, boolean refresh) {
    }

    public void deleteUI(UI context) {
    }

    public void openOpenable(UI context) {
    }

    public void closeOpenable(UI context) {
    }

    public static boolean checkEdit(ObserveContent<?> content) {
        if (!(content.isEnabled() && content.isEditing().booleanValue() && content.isModified().booleanValue())) {
            if (content.isEditing().booleanValue()) {
                content.stopEdit();
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"previousUI is in edit mode");
        }
        boolean wasClosed = true;
        if (content.isEditionValid().booleanValue()) {
            int reponse = UIHelper.askUser((Component)((Object)content), I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.quit.valid.edit"), 2, new Object[]{I18n._((String)"observe.choice.save"), I18n._((String)"observe.choice.doNotSave"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 2: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    content.save(false);
                    break;
                }
                case 1: {
                    content.resetEdit();
                }
            }
        } else {
            int reponse = UIHelper.askUser((Component)((Object)content), I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.quit.invalid.edit"), 0, new Object[]{I18n._((String)"observe.choice.continue"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 1: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    content.resetEdit();
                }
            }
        }
        if (wasClosed) {
            content.stopEdit();
        }
        return wasClosed;
    }

    public static StorageService<?> getStorageService(JAXXContext context) {
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        return dataContext.getStorage();
    }

    protected static void attachTopiaContext(StorageService<?> service, TopiaEntityAbstract entity) {
        DBHelper.attachTopiaContext((TopiaContext)((StorageServiceImplementor)service).getRootCtxt(), (TopiaEntityAbstract)entity);
    }

    protected void updateActions(UI ui) {
        ObserveMainUI mainUI = ((ObserveContentUI)ui).getParentContainer(ObserveMainUI.class);
        for (ObserveContentActions actionDef : ObserveContentActions.values()) {
            AbstractButton upButton = (AbstractButton)((ObserveContentUI)ui).getObjectById(actionDef.name());
            if (upButton == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("update action " + (Object)((Object)actionDef)));
            }
            actionDef.updateAction(mainUI, (ObserveContentUI<?>)ui, upButton);
        }
    }

    protected void init(StorageService<?> service, UI ui, TopiaEntity entity) throws StorageServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init entity " + entity.getClass()));
        }
        ObserveContentHandler.attachTopiaContext(service, (TopiaEntityAbstract)entity);
    }

    protected void init(StorageService<?> service, UI ui, ObserveMainUI mainUI, ActionMap actionMap, AbstractButton editor) throws StorageServiceException {
        String id = editor.getName();
        if (!ObserveContentActions.accept(id)) {
            return;
        }
        ObserveContentActions actionDef = ObserveContentActions.valueOf(id);
        Action action = actionMap.get((Object)actionDef);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init common action " + (Object)((Object)actionDef)));
        }
        actionDef.initAction(mainUI, (ObserveContentUI<?>)ui, editor, action);
    }

    protected void init(StorageService<?> service, UI ui, NumberEditor editor) throws StorageServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(StorageService<?> service, UI ui, EntityComboBox entityComboBox) throws StorageServiceException {
        Class klass = entityComboBox.getHandler().getTargetClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("init combobox for " + klass));
        }
        entityComboBox.setI18nPrefix("observe.common.");
        UIHelper.prepareEntityComboBox(service, klass, entityComboBox);
    }

    protected void init(StorageService<?> service, UI ui, JList jlist) throws StorageServiceException {
        Class klass;
        Object init = jlist.getClientProperty("doInit");
        if (init != null) {
            klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("init list for " + klass));
            }
            UIHelper.prepareEntityList(service, klass, jlist, false);
        }
        if ((init = jlist.getClientProperty("addDecorator")) != null) {
            klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            Decorator decorator = this.getDecoratorService().getDecorator(klass);
            jlist.putClientProperty("decorator", decorator);
            jlist.setCellRenderer(new DecoratorListCellRenderer(decorator));
        }
        if ((init = jlist.getClientProperty("addToogleListSelectionModel")) != null && init instanceof Boolean && ((Boolean)init).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            UIHelper.prepareToogleListSelectionModel(jlist);
        }
    }

    protected void init(StorageService<?> service, UI ui, TimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getProperty()));
        }
        editor.init();
    }

    protected void init(StorageService<?> service, UI ui, JXDatePicker picker) {
        log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        picker.getEditor().setEditable(false);
    }

    protected ObserveContentMode getObserveContentMode(UI context) {
        ObserveContentMode mode = null;
        if (!this.canWriteData(context)) {
            ObserveContentHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(((ObserveContentUI)context).getInternalClass()), I18n._((String)"observe.message.can.not.write.data"));
            mode = ObserveContentMode.READ;
        }
        return mode;
    }

    protected boolean canWriteData(UI context) {
        return ObserveContentHandler.getStorageService(context).canWriteData();
    }
}

