/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.services.DecoratorService;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.impl.AbstractStorageService;
import fr.ird.observe.services.validation.ValidationMessageDetector;
import fr.ird.observe.services.validation.ValidationModel;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.ValidatorsMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class ValidateAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(ValidateAction.class);

    public ValidateAction() {
        super(SynchroStep.VALIDATE);
    }

    public AbstractStorageService<?> getStorage(SynchroUIModel model) {
        if (model.getSynchroService() != null) {
            return (AbstractStorageService)model.getSynchroService();
        }
        return (AbstractStorageService)model.getLocalService();
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        StorageUIModel localServiceModel = model.getLocalServiceModel();
        AbstractStorageService<?> service = this.getStorage(model);
        if (service == null) {
            model.setLocalService(this.createLocalService(localServiceModel, model.getPreviousService()));
        }
    }

    protected WizardOperationState initDB(SynchroUIModel model) throws Exception {
        AbstractStorageService<?> sourceService = this.getStorage(model);
        this.openService((StorageService<?>)sourceService);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        DecoratorService decoratorService = this.getDecoratorService();
        ValidationModel validationModel = this.getModel().getValidationModel();
        ValidatorsMap validators = validationModel.getValidators();
        this.sendMessage(I18n._((String)"observe.message.validation.prepare.validators"));
        if (!validators.isEmpty()) {
            for (BeanValidator v : validators.values()) {
                String label = I18n._((String)decoratorService.getEntityLabel(v.getBeanClass()));
                this.sendMessage(I18n._((String)"observe.message.validation.detected", (Object[])new Object[]{label}));
            }
        } else {
            this.sendMessage(I18n._((String)"observe.message.no.validation.detected"));
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        WizardOperationState init = this.initDB(model);
        if (init != null) {
            return init;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.launchValidation(model);
        SortedMap refs = this.getModel().getValidationModel().getMessages();
        if (refs == null || refs.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.validation.nothing.to.do"));
            this.sendMessage(I18n._((String)"observe.message.validation.operation.done", (Object[])new Object[]{new Date()}));
            return WizardOperationState.SUCCESSED;
        }
        this.sendMessage(I18n._((String)"observe.message.validation.operation.needFix", (Object[])new Object[]{new Date()}));
        return WizardOperationState.NEED_FIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchValidation(SynchroUIModel model) throws Exception {
        this.getModel().getValidationModel().setMessages(null);
        ValidatorsMap validators = model.getValidationModel().getValidators();
        ValidationMessageDetector detector = new ValidationMessageDetector(validators);
        AbstractStorageService<?> service = this.getStorage(model);
        TopiaContext ctxt = service.newCtxt();
        try {
            SelectDataModel dataModel = this.getModel().getSelectDataModel();
            DecoratorService decoratorService = this.getDecoratorService();
            if (dataModel.isUseReferentiel()) {
                Set classes = dataModel.getSelectedReferentiel();
                Iterator i$ = classes.iterator();
                while (i$.hasNext()) {
                    Class klass;
                    Class refClass = klass = (Class)i$.next();
                    List ids = service.getEntityIds(refClass);
                    String entityLabel = I18n._((String)decoratorService.getEntityLabel(klass));
                    this.sendMessage(I18n._((String)"observe.message.validation.start.referentiel", (Object[])new Object[]{entityLabel, ids.size()}));
                    for (String id : ids) {
                        TopiaEntity e = ctxt.findByTopiaId(id);
                        detector.detectMessages(new TopiaEntity[]{e});
                    }
                    ids.clear();
                }
            }
            if (dataModel.isUseData()) {
                Set data = dataModel.getSelectedData();
                Decorator dMaree = decoratorService.getDecorator(Maree.class);
                Decorator dProgramme = decoratorService.getDecorator(Programme.class);
                for (Maree m : data) {
                    Programme p = m.getProgramme();
                    this.sendMessage(I18n._((String)"observe.message.validation.start.maree", (Object[])new Object[]{dMaree.toString((Object)m), dProgramme.toString((Object)p)}));
                    Maree e = (Maree)ctxt.findByTopiaId(m.getTopiaId());
                    detector.detectMessages(new TopiaEntity[]{e});
                }
            }
        }
        finally {
            SortedMap refs = detector.getRefs();
            this.getModel().getValidationModel().setMessages(refs);
            detector.clear();
            ctxt.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReport() {
        WizardOperationState finalState = null;
        try {
            if (this.getModel().getValidationModel().isGenerateReport()) {
                File reportFile = this.getModel().getValidationModel().getReportFile();
                if (log.isInfoEnabled()) {
                    log.info((Object)("save report in " + reportFile));
                }
                this.sendMessage(I18n._((String)"observe.message.validation.save.report", (Object[])new Object[]{reportFile}));
            } else {
                this.sendMessage(I18n._((String)"observe.message.validation.not.save.report"));
            }
            finalState = WizardOperationState.SUCCESSED;
        }
        catch (Exception e) {
            try {
                this.setError(e);
                finalState = WizardOperationState.FAILED;
            }
            catch (Throwable throwable) {
                this.getModel().setOperationState(SynchroStep.VALIDATE, finalState);
                throw throwable;
            }
            this.getModel().setOperationState(SynchroStep.VALIDATE, finalState);
        }
        this.getModel().setOperationState(SynchroStep.VALIDATE, finalState);
    }
}

