/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.admin.SynchroUIThread;
import fr.ird.observe.ui.admin.tabs.AbstractSynchroTabPanelUI;
import fr.ird.observe.ui.admin.tabs.ConfigSynchroPanelUI;
import fr.ird.observe.ui.admin.tabs.ExportDataPanelUI;
import fr.ird.observe.ui.admin.tabs.ImportGPSPanelUI;
import fr.ird.observe.ui.admin.tabs.SaveLocalPanelUI;
import fr.ird.observe.ui.admin.tabs.SelectExportDataPanelUI;
import fr.ird.observe.ui.admin.tabs.SelectPanelUI;
import fr.ird.observe.ui.admin.tabs.ShowResumePanelUI;
import fr.ird.observe.ui.admin.tabs.SynchronizeReferentielPanelUI;
import fr.ird.observe.ui.admin.tabs.ValidatePanelUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;

public class SynchroPanelUI
extends JPanel
implements JAXXHelpUI<JAXXHelpBroker>,
WizardUI<SynchroStep, SynchroUIModel>,
JAXXObject {
    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCK = "busyBlockLayerUI.block";
    public static final String BINDING_CANCEL_ACTION_VISIBLE = "cancelAction.visible";
    public static final String BINDING_CLOSE_ACTION_VISIBLE = "closeAction.visible";
    public static final String BINDING_CLOSE_ON_CANCELED_OR_FAILED_ACTION_VISIBLE = "closeOnCanceledOrFailedAction.visible";
    public static final String BINDING_CONFIG_BLOCK_LAYER_UI_BLOCK = "configBlockLayerUI.block";
    public static final String BINDING_NEXT_ACTION_ENABLED = "nextAction.enabled";
    public static final String BINDING_NEXT_ACTION_VISIBLE = "nextAction.visible";
    public static final String BINDING_OPERATION_BLOCK_LAYER_UI_BLOCK = "operationBlockLayerUI.block";
    public static final String BINDING_PREVIOUS_ACTION_ENABLED = "previousAction.enabled";
    public static final String BINDING_PREVIOUS_ACTION_VISIBLE = "previousAction.visible";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAM1XzW8bRRSfuHHSxCn9/kC04IQSXNRuqFRAoiDqOut2K8eOvHZamkMY707sLeudZWc2tusW8Qdw4E+AK+KCxI0T4sCZAxfEv4AQB66IN7Prj3XWdpBCSz6tmfd+897vzbzfzDe/oyTz0PIj3G4rnu9wq0mUe9kHD0q1R8Tg64QZnuVy6qHgayaBEtsoZfbHGUevbheE+1rovpajTZc6xBnyvllAi4x3bMIahHCOLkU9DMbW9P70zbbrez3UflBxqF/++UfiC/OzrxIItV2I7hykkp7mNchktoASlsnRKVhpD6/Z2KlDGJ7l1CHeY2IsZ2PGirhJPkGfovkCmnOxB2AcrRw8ZYkh/dsuR0us4xgNj25ih9gcre56iuWZCq0x4u0RxbcUbDYtR9GHzKqa60qEOQ4/DY9gCPr1KZ5VrSItB64naj7r3Lap8XEBd4hX1SCNCFmsBakr0gI+hEYD/7PUJR7mFnWGQcTkyYHRKYM6u1Z9gsXS5Rz2TJijPn+To9OCZwW3uDIYHko3VyrmtTscXR+XLsc1BmUWi0Y5EwgLfaDz+ofF3N1yqag9VHfKal4tq8WKphY4encicojpWI9JmewSUX2L2LFLzOlqQc1VOHpjMiKx4WTFIpwKEHbUB5ulcmVnPVvJcnTjAGhq26UeX8ccx+Ie3coWNEBTObo6EW0L25aJOYlFWdQ2ZFh3NnWOrk3E0ZoiHjCMB9KzW+pOoZTLFqYB6XiPFKiB4xlPRYhSJiJNoSil3y3dh42hVzfUaVB6g7bKhPnNeJ5mhRHsOLGx2+GhulfBtRoxhX3UeB4b4kSB/YWYswhe9ojDkoEdg9hZ6RYen/4qt33OqSMs3+k7XDJsykjJyUk/Ypa8PLbgf4AgjN6LOqSkw9jpF1yP7FnUZ2MtFh3S5vtnPfRSJEXo+sqg6w/a8sw2Sno+DAMn2/uFogxTgURcGJEIAShn/z53+pfvf/su39OFFKx9NtZ0SNagX7ueaHFwwGHp44Eo+Nyy1zawe3MbLTB51qTmXYwJTA+nIThY76Tsa8JduYtZAyCS87/+8OO5j34+ghJ5tGhTbOaxsNfQgmjqrEFts+1+cEtGtNQ6Cn9PwG8COost2yJHZ7oOaaVvU88kXtAqM1eecpTcaRAbxOVCdwV2ahPDRq1Rs6OEWrPytA1sXYxhqx9ybeGnv07r397qMTYDGbw41nzAWvIhmrMc23KI1NJQJmO1M+Uy4pt0IIdxAolGFNINpeCe/FvcR84Rjo7VQsHKURtOOHqrW9U2sIPrxFPqhMvRzMqIqikRpxVJohzi6PPufesxSFFVlA4bBnG5zqEnskyTmsQWmBvigxzMXLmaDsxLPXGU40ouW8xBM18fM61XczlV18fO57MaOIuw5n1GNEMc9eQuthlp+4KJiqyR+LSFYpT9OdB2vrsc8GOx+5hBFh4nZuagGcTfLZ5DGvVuXBbpJ0/Sh7krDkpLzG1qGieiXdRkg4CLSDdoFUGf6SgGXAg5UZsu7wQTmbevyu/hJnIpvokojBNXdJL9UUrBO0Ct5lvEqjd4m6OZ6+C1a9lwA56tUd4YrP7KmNUDmYxfv6eh00JIilBBmsR2C4U98FQCTQWkPYtZILkjXcAj4jH0PLvAYhBosF/meuGmOKV2xXIrMqnlkaR61AXWCodnSZ/m1Yk0hy7xbEcuIAen/Mwo5eKSMcy4/Sz67hhGZ0nb4qN8puMi7jMVofO1KXQKz3g2J9/ODpHezUOht79j/0cUDt9XpxEmbtzEEbdqeEIvd/upb4Z3Wh2aHLT75ffTjm/bT/v0rowkUqecKr2LMLRG0Jthsr9+Ft2jXC0WteKdw+0tx1vS+Fovt9GKrk4nIlrXzOS69lzjSzvy1vhX1b0xqG4RQo9WNr26mu4JvXz0BtODgr8cl6d41/xXxZ5czf9GSFJhsR2ZcrTQsTt+QEC0yJcnF1m4xRd46KkIxf0HaypUtY4UAAA=";
    protected static final Log log = LogFactory.getLog(SynchroPanelUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected ConfigSynchroPanelUI CONFIG;
    protected ExportDataPanelUI EXPORT_DATA;
    protected ImportGPSPanelUI IMPORT_GPS;
    protected SaveLocalPanelUI SAVE_LOCAL;
    protected SelectPanelUI SELECT;
    protected SelectExportDataPanelUI SELECT_EXPORT_DATA;
    protected ShowResumePanelUI SHOW_RESUME;
    protected SynchronizeReferentielPanelUI SYNCHRONIZE_REFERENTIEL;
    protected ValidatePanelUI VALIDATE;
    protected Table actions;
    protected BlockingLayerUI busyBlockLayerUI;
    protected JButton cancelAction;
    protected JButton closeAction;
    protected JButton closeOnCanceledOrFailedAction;
    protected BlockingLayerUI configBlockLayerUI;
    protected JButton nextAction;
    protected BlockingLayerUI operationBlockLayerUI;
    protected JButton previousAction;
    protected SynchroPanelUI synchroPanel = this;
    protected JTabbedPane tabs;
    protected SynchroUIThread thread;
    private CardLayout $CardLayout0;
    private SynchroUIModel model;
    private boolean contextInitialized;

    public SynchroPanelUI(JAXXContext parentContext, String title, String tip, ImageIcon icon) {
        this.$initialize();
        this.putClientProperty("title", title);
        this.putClientProperty("tip", tip);
        this.putClientProperty("imageIcon", icon);
        UIHelper.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)UIHelper.newContextEntryDef(SynchroUIModel.class));
        UIHelper.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.model = this.getContextValue(SynchroUIModel.class);
        JAXXUtil.assignment((Object)((Object)this.model), (String)"model", (JAXXObject)this);
        this.contextInitialized = true;
        JAXXUtil.assignment((boolean)true, (String)"contextInitialized", (JAXXObject)this);
        this.$initialize();
    }

    public void destroy() {
        this.getModel().destroy();
        log.debug((Object)("destroy ui " + this.getName()));
        SwingUtil.TabbedPaneIterator itr = UIHelper.newTabbedPaneIterator((JTabbedPane)this.getTabs());
        while (itr.hasNext()) {
            AbstractSynchroTabPanelUI tab = (AbstractSynchroTabPanelUI)itr.next();
            log.debug((Object)("destroy ui " + tab.getName()));
            tab.destroy();
        }
        UIHelper.destroy((Component)this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public void start() {
        this.getThread().start();
        this.model.start((JAXXContext)this);
        this.setVisible(true);
        ObserveMainUI mainUI = ObserveContext.getObserveMainUI();
        if (mainUI != null) {
            mainUI.setBusy(false);
        }
    }

    public void apply() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Runnable action = SynchroPanelUI.this.getContextValue(Runnable.class, "apply");
                    action.run();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    SynchroPanelUI.this.dispose();
                }
            }
        });
    }

    public void cancel() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Runnable action = SynchroPanelUI.this.getContextValue(Runnable.class, "cancel");
                    action.run();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    SynchroPanelUI.this.dispose();
                }
            }
        });
    }

    public void dispose() {
        if (this.thread.isAlive()) {
            this.thread.cancel();
        }
        this.destroy();
    }

    public SynchroUIModel getModel() {
        return this.model;
    }

    public SynchroStep getSelectedStep() {
        int index = this.tabs.getSelectedIndex();
        AbstractSynchroTabPanelUI c = null;
        if (index > -1) {
            c = (AbstractSynchroTabPanelUI)this.tabs.getComponentAt(index);
        }
        SynchroStep result = c == null ? null : c.getStep();
        return result;
    }

    public AbstractSynchroTabPanelUI getStepUI(SynchroStep step) {
        if (step != null) {
            return (AbstractSynchroTabPanelUI)this.getObjectById(step.name());
        }
        return null;
    }

    public AbstractSynchroTabPanelUI getStepUI(int stepIndex) {
        if (stepIndex > this.tabs.getTabCount()) {
            return null;
        }
        return (AbstractSynchroTabPanelUI)this.tabs.getComponentAt(stepIndex);
    }

    public AbstractSynchroTabPanelUI getSelectedStepUI() {
        SynchroStep step = this.getSelectedStep();
        AbstractSynchroTabPanelUI ui = this.getStepUI(step);
        return ui;
    }

    public void blockOperations() {
        this.model.setValueAdjusting(true);
        for (SynchroStep op : SynchroStep.values()) {
            JCheckBox comp = (JCheckBox)this.CONFIG.getObjectById(op.name());
            if (comp == null || this.model.getOperations().contains((Object)op)) continue;
            comp.setVisible(false);
        }
        this.operationBlockLayerUI.setBlock(true);
        this.model.setValueAdjusting(false);
    }

    public void onWasStarted() {
    }

    public void onModelStateChanged(WizardOperationState newState) {
        log.debug((Object)newState);
        AbstractSynchroTabPanelUI selected = this.getSelectedStepUI();
        boolean busy = WizardUtil.acceptStates((WizardOperationState)newState, (WizardOperationState[])new WizardOperationState[]{WizardOperationState.RUNNING});
        SwingUtil.TabbedPaneIterator itr = UIHelper.newTabbedPaneIterator((JTabbedPane)this.getTabs());
        if (busy) {
            while (itr.hasNext()) {
                Component tab = (Component)itr.next();
                this.tabs.setEnabledAt(itr.getIndex() - 1, tab == selected);
            }
            return;
        }
        if (selected != null && selected.getStep().isConfig()) {
            while (itr.hasNext()) {
                int index = itr.getIndex();
                Component tab = (Component)itr.next();
                AbstractSynchroTabPanelUI tabUI = (AbstractSynchroTabPanelUI)tab;
                SynchroStep synchroStep = tabUI.getStep();
                if (!synchroStep.isConfig()) continue;
                boolean valid = this.model.validate(synchroStep);
                if (valid) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("step " + (Object)((Object)synchroStep) + " is valid"));
                    }
                    this.tabs.setIconAt(index, tabUI.getTabIcon(WizardOperationState.SUCCESSED));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("step " + (Object)((Object)synchroStep) + " is not valid!"));
                }
                this.tabs.setIconAt(index, tabUI.getTabIcon(WizardOperationState.FAILED));
            }
            itr = UIHelper.newTabbedPaneIterator((JTabbedPane)this.getTabs());
        }
        if (selected == this.SHOW_RESUME) {
            return;
        }
        boolean[] accessibleSteps = this.model.getAccessibleSteps();
        while (itr.hasNext()) {
            int index = itr.getIndex();
            this.tabs.setEnabledAt(index, accessibleSteps[index]);
            itr.next();
        }
        if (this.model.isShowResume()) {
            this.tabs.setEnabledAt(accessibleSteps.length - 1, true);
        }
    }

    public void onOperationStateChanged(SynchroStep step, WizardOperationState newState) {
        log.debug((Object)((Object)((Object)step) + " - " + newState));
        AbstractSynchroTabPanelUI selected = this.getStepUI(step);
        int index = this.tabs.indexOfComponent(selected);
        if (index > -1 && !selected.getStep().isConfig()) {
            this.tabs.setIconAt(index, selected.getTabIcon(newState));
        }
        if (step == selected.getStep()) {
            selected.updateState(newState);
        }
    }

    public void onStepChanged(SynchroStep newStep) {
        int index;
        log.trace((Object)newStep);
        AbstractSynchroTabPanelUI c = this.getStepUI(newStep);
        if (c == this.SAVE_LOCAL) {
            this.SAVE_LOCAL.updateText();
        }
        if (c == this.SHOW_RESUME) {
            this.SHOW_RESUME.updateText();
        }
        if ((index = this.tabs.indexOfComponent(c)) > -1 && this.tabs.getSelectedIndex() != index) {
            this.tabs.setSelectedIndex(index);
        }
    }

    public void onStepsChanged(SynchroStep[] steps) {
        log.trace((Object)Arrays.toString((Object[])steps));
        this.model.setValueAdjusting(true);
        while (this.tabs.getTabCount() > 1) {
            this.tabs.remove(this.tabs.getTabCount() - 1);
        }
        int max = steps.length;
        for (int i = 0; i < max; ++i) {
            SynchroStep step = steps[i];
            AbstractSynchroTabPanelUI c = this.getStepUI(step);
            String title = I18n._((String)step.getLabel());
            String tip = I18n._((String)step.getDescription());
            this.tabs.addTab(title, null, c, tip);
            ((Component)c).setEnabled(i == 0);
        }
        this.model.setValueAdjusting(false);
    }

    public JAXXHelpBroker getBroker() {
        return this.getContextValue(JAXXHelpBroker.class);
    }

    void $afterCompleteSetup() {
        this.setContextValue(this.thread);
        WizardUtil.installWizardUIListeners((WizardUI)this);
        WizardUtil.addTraceLogListener((Log)log, (WizardModel)this.getModel());
        for (SynchroStep step : SynchroStep.values()) {
            AbstractSynchroTabPanelUI c = this.getStepUI(step);
            JPanel content = c.getContent();
            UIHelper.getLayer((JComponent)content).setUI((LayerUI)this.busyBlockLayerUI);
        }
        UIHelper.getLayer((JComponent)this.CONFIG.getOperations()).setUI((LayerUI)this.operationBlockLayerUI);
        UIHelper.getLayer((JComponent)this.CONFIG.getConfig()).setUI((LayerUI)this.configBlockLayerUI);
        UIHelper.getLayer((JComponent)this.SELECT.getContent()).setUI((LayerUI)this.configBlockLayerUI);
        UIHelper.getLayer((JComponent)this.CONFIG.getContent()).setUI(null);
        UIHelper.getLayer((JComponent)this.SHOW_RESUME.getContent()).setUI(null);
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public SynchroPanelUI() {
        this.$initialize();
    }

    public SynchroPanelUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        this.getThread().cancel();
    }

    public void doActionPerformed__on__closeAction(ActionEvent event) {
        this.apply();
    }

    public void doActionPerformed__on__closeOnCanceledOrFailedAction(ActionEvent event) {
        this.cancel();
    }

    public void doActionPerformed__on__nextAction(ActionEvent event) {
        this.model.gotoNextStep();
    }

    public void doActionPerformed__on__previousAction(ActionEvent event) {
        this.model.gotoPreviousStep();
    }

    public void doStateChanged__on__tabs(ChangeEvent event) {
        if (!this.model.isValueAdjusting()) {
            this.model.gotoStep((WizardStep)this.getSelectedStep());
        }
    }

    public Table getActions() {
        return this.actions;
    }

    public BlockingLayerUI getBusyBlockLayerUI() {
        return this.busyBlockLayerUI;
    }

    public ConfigSynchroPanelUI getCONFIG() {
        return this.CONFIG;
    }

    public JButton getCancelAction() {
        return this.cancelAction;
    }

    public JButton getCloseAction() {
        return this.closeAction;
    }

    public JButton getCloseOnCanceledOrFailedAction() {
        return this.closeOnCanceledOrFailedAction;
    }

    public BlockingLayerUI getConfigBlockLayerUI() {
        return this.configBlockLayerUI;
    }

    public ExportDataPanelUI getEXPORT_DATA() {
        return this.EXPORT_DATA;
    }

    public ImportGPSPanelUI getIMPORT_GPS() {
        return this.IMPORT_GPS;
    }

    public JButton getNextAction() {
        return this.nextAction;
    }

    public BlockingLayerUI getOperationBlockLayerUI() {
        return this.operationBlockLayerUI;
    }

    public JButton getPreviousAction() {
        return this.previousAction;
    }

    public SaveLocalPanelUI getSAVE_LOCAL() {
        return this.SAVE_LOCAL;
    }

    public SelectPanelUI getSELECT() {
        return this.SELECT;
    }

    public SelectExportDataPanelUI getSELECT_EXPORT_DATA() {
        return this.SELECT_EXPORT_DATA;
    }

    public ShowResumePanelUI getSHOW_RESUME() {
        return this.SHOW_RESUME;
    }

    public SynchronizeReferentielPanelUI getSYNCHRONIZE_REFERENTIEL() {
        return this.SYNCHRONIZE_REFERENTIEL;
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    public SynchroUIThread getThread() {
        return this.thread;
    }

    public ValidatePanelUI getVALIDATE() {
        return this.VALIDATE;
    }

    public void registerHelpId(JAXXHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    public void showHelp(String helpId) {
        this.getBroker().showHelp((JAXXContext)this, helpId);
    }

    protected CardLayout get$CardLayout0() {
        return this.$CardLayout0;
    }

    protected void addChildrenToActions() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.actions.add((Component)this.cancelAction, (Object)new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.closeOnCanceledOrFailedAction, (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.closeAction, (Object)new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.previousAction, (Object)new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.nextAction, (Object)new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSynchroPanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.add(this.CONFIG);
        this.add(this.SYNCHRONIZE_REFERENTIEL);
        this.add(this.SELECT);
        this.add(this.SELECT_EXPORT_DATA);
        this.add(this.VALIDATE);
        this.add(this.IMPORT_GPS);
        this.add(this.SAVE_LOCAL);
        this.add(this.EXPORT_DATA);
        this.add(this.SHOW_RESUME);
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.actions, "South");
    }

    protected void createActions() {
        this.actions = new Table();
        this.$objectMap.put("actions", this.actions);
        this.actions.setName("actions");
        this.actions.putClientProperty((Object)"help", (Object)"ui.main.body.synchro.action");
    }

    protected void createBusyBlockLayerUI() {
        this.busyBlockLayerUI = new BlockingLayerUI();
        this.$objectMap.put("busyBlockLayerUI", this.busyBlockLayerUI);
        this.busyBlockLayerUI.setUseIcon(false);
    }

    protected void createCONFIG() {
        this.CONFIG = new ConfigSynchroPanelUI(this);
        this.$objectMap.put("CONFIG", this.CONFIG);
        this.CONFIG.setName("CONFIG");
    }

    protected void createCancelAction() {
        this.cancelAction = new JButton();
        this.$objectMap.put("cancelAction", this.cancelAction);
        this.cancelAction.setName("cancelAction");
        this.cancelAction.setText(I18n._((String)"observe.action.cancel"));
        this.cancelAction.setToolTipText(I18n._((String)"observe.action.synchro.cancel.tip"));
        this.cancelAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancelAction"));
        this.cancelAction.putClientProperty("help", "ui.main.body.synchro.action.cancel");
    }

    protected void createCloseAction() {
        this.closeAction = new JButton();
        this.$objectMap.put("closeAction", this.closeAction);
        this.closeAction.setName("closeAction");
        this.closeAction.setText(I18n._((String)"observe.action.close"));
        this.closeAction.setToolTipText(I18n._((String)"observe.action.close.synchro.tip"));
        this.closeAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__closeAction"));
        this.closeAction.putClientProperty("help", "ui.main.body.synchro.action.close");
    }

    protected void createCloseOnCanceledOrFailedAction() {
        this.closeOnCanceledOrFailedAction = new JButton();
        this.$objectMap.put("closeOnCanceledOrFailedAction", this.closeOnCanceledOrFailedAction);
        this.closeOnCanceledOrFailedAction.setName("closeOnCanceledOrFailedAction");
        this.closeOnCanceledOrFailedAction.setText(I18n._((String)"observe.action.close"));
        this.closeOnCanceledOrFailedAction.setToolTipText(I18n._((String)"observe.action.close.synchro.tip"));
        this.closeOnCanceledOrFailedAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__closeOnCanceledOrFailedAction"));
        this.closeOnCanceledOrFailedAction.putClientProperty("help", "ui.main.body.synchro.action.close");
    }

    protected void createConfigBlockLayerUI() {
        this.configBlockLayerUI = new BlockingLayerUI();
        this.$objectMap.put("configBlockLayerUI", this.configBlockLayerUI);
        this.configBlockLayerUI.setUseIcon(false);
    }

    protected void createEXPORT_DATA() {
        this.EXPORT_DATA = new ExportDataPanelUI(this);
        this.$objectMap.put("EXPORT_DATA", this.EXPORT_DATA);
        this.EXPORT_DATA.setName("EXPORT_DATA");
    }

    protected void createIMPORT_GPS() {
        this.IMPORT_GPS = new ImportGPSPanelUI(this);
        this.$objectMap.put("IMPORT_GPS", this.IMPORT_GPS);
        this.IMPORT_GPS.setName("IMPORT_GPS");
    }

    protected void createNextAction() {
        this.nextAction = new JButton();
        this.$objectMap.put("nextAction", this.nextAction);
        this.nextAction.setName("nextAction");
        this.nextAction.setText(I18n._((String)"observe.action.goto.next.stage"));
        this.nextAction.setToolTipText(I18n._((String)"observe.action.goto.next.stage.tip"));
        this.nextAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__nextAction"));
        this.nextAction.putClientProperty("help", "ui.main.body.synchro.action.next");
    }

    protected void createOperationBlockLayerUI() {
        this.operationBlockLayerUI = new BlockingLayerUI();
        this.$objectMap.put("operationBlockLayerUI", this.operationBlockLayerUI);
        this.operationBlockLayerUI.setUseIcon(false);
    }

    protected void createPreviousAction() {
        this.previousAction = new JButton();
        this.$objectMap.put("previousAction", this.previousAction);
        this.previousAction.setName("previousAction");
        this.previousAction.setText(I18n._((String)"observe.action.goto.previous.stage"));
        this.previousAction.setToolTipText(I18n._((String)"observe.action.goto.previous.stage.tip"));
        this.previousAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__previousAction"));
        this.previousAction.putClientProperty("help", "ui.main.body.synchro.action.previous");
    }

    protected void createSAVE_LOCAL() {
        this.SAVE_LOCAL = new SaveLocalPanelUI(this);
        this.$objectMap.put("SAVE_LOCAL", this.SAVE_LOCAL);
        this.SAVE_LOCAL.setName("SAVE_LOCAL");
    }

    protected void createSELECT() {
        this.SELECT = new SelectPanelUI(this);
        this.$objectMap.put("SELECT", this.SELECT);
        this.SELECT.setName("SELECT");
    }

    protected void createSELECT_EXPORT_DATA() {
        this.SELECT_EXPORT_DATA = new SelectExportDataPanelUI(this);
        this.$objectMap.put("SELECT_EXPORT_DATA", this.SELECT_EXPORT_DATA);
        this.SELECT_EXPORT_DATA.setName("SELECT_EXPORT_DATA");
    }

    protected void createSHOW_RESUME() {
        this.SHOW_RESUME = new ShowResumePanelUI(this);
        this.$objectMap.put("SHOW_RESUME", this.SHOW_RESUME);
        this.SHOW_RESUME.setName("SHOW_RESUME");
    }

    protected void createSYNCHRONIZE_REFERENTIEL() {
        this.SYNCHRONIZE_REFERENTIEL = new SynchronizeReferentielPanelUI(this);
        this.$objectMap.put("SYNCHRONIZE_REFERENTIEL", this.SYNCHRONIZE_REFERENTIEL);
        this.SYNCHRONIZE_REFERENTIEL.setName("SYNCHRONIZE_REFERENTIEL");
    }

    protected void createTabs() {
        this.tabs = new JTabbedPane();
        this.$objectMap.put("tabs", this.tabs);
        this.tabs.setName("tabs");
        this.tabs.addChangeListener((ChangeListener)JAXXUtil.getEventListener(ChangeListener.class, (String)"stateChanged", (Object)this, (String)"doStateChanged__on__tabs"));
        this.tabs.putClientProperty("help", "ui.main.body.synchro.step");
    }

    protected void createThread() {
        this.thread = new SynchroUIThread((JAXXContext)this);
        this.$objectMap.put("thread", (Object)this.thread);
    }

    protected void createVALIDATE() {
        this.VALIDATE = new ValidatePanelUI(this);
        this.$objectMap.put("VALIDATE", this.VALIDATE);
        this.VALIDATE.setName("VALIDATE");
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToSynchroPanel();
        this.addChildrenToActions();
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.busyBlockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        this.operationBlockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        this.configBlockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        this.tabs.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.cancelAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"cancel"));
        this.closeOnCanceledOrFailedAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"exit"));
        this.closeAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"exit"));
        this.previousAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"wizard-previous"));
        this.nextAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"wizard-next"));
        JAXXHelpBroker _broker = this.getBroker();
        this.registerHelpId(_broker, this.synchroPanel, "ui.main.body.synchro");
        this.registerHelpId(_broker, this.tabs, "ui.main.body.synchro.step");
        this.registerHelpId(_broker, (Component)this.actions, "ui.main.body.synchro.action");
        this.registerHelpId(_broker, this.cancelAction, "ui.main.body.synchro.action.cancel");
        this.registerHelpId(_broker, this.closeOnCanceledOrFailedAction, "ui.main.body.synchro.action.close");
        this.registerHelpId(_broker, this.closeAction, "ui.main.body.synchro.action.close");
        this.registerHelpId(_broker, this.previousAction, "ui.main.body.synchro.action.previous");
        this.registerHelpId(_broker, this.nextAction, "ui.main.body.synchro.action.next");
        _broker.prepareUI((JAXXObject)this);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$registerDefaultBindings();
        this.$objectMap.put("synchroPanel", this);
        this.createThread();
        this.createBusyBlockLayerUI();
        this.createOperationBlockLayerUI();
        this.createConfigBlockLayerUI();
        this.$CardLayout0 = new CardLayout();
        this.$objectMap.put("$CardLayout0", this.$CardLayout0);
        this.createCONFIG();
        this.createSYNCHRONIZE_REFERENTIEL();
        this.createSELECT();
        this.createSELECT_EXPORT_DATA();
        this.createVALIDATE();
        this.createIMPORT_GPS();
        this.createSAVE_LOCAL();
        this.createEXPORT_DATA();
        this.createSHOW_RESUME();
        this.createTabs();
        this.createActions();
        this.createCancelAction();
        this.createCloseOnCanceledOrFailedAction();
        this.createCloseAction();
        this.createPreviousAction();
        this.createNextAction();
        this.setName("synchroPanel");
        this.setLayout(new BorderLayout());
        this.synchroPanel.putClientProperty("help", "ui.main.body.synchro");
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCK, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.busyBlockLayerUI.setBlock(WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_OPERATION_BLOCK_LAYER_UI_BLOCK, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.operationBlockLayerUI.setBlock(!SynchroPanelUI.this.model.isWasStarted());
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CONFIG_BLOCK_LAYER_UI_BLOCK, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.configBlockLayerUI.setBlock(SynchroPanelUI.this.model.isWasStarted() || WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CANCEL_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.cancelAction.setVisible(WizardUtil.rejectStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CLOSE_ON_CANCELED_OR_FAILED_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.closeOnCanceledOrFailedAction.setVisible(WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CLOSE_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.closeAction.setVisible(WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.SUCCESSED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_PREVIOUS_ACTION_ENABLED, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.previousAction.setEnabled(SynchroPanelUI.this.model.getPreviousStep() != null);
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_PREVIOUS_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.previousAction.setVisible(WizardUtil.rejectStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.RUNNING, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_ENABLED, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.nextAction.setEnabled(SynchroPanelUI.this.model.getNextStep() != null && SynchroPanelUI.this.model.isValidStep());
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.nextAction.setVisible(WizardUtil.rejectStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.RUNNING, WizardOperationState.CANCELED, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

