/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.services.DecoratorService;
import fr.ird.observe.services.ObserveServiceHelper;
import fr.ird.observe.services.gps.GPSService;
import fr.ird.observe.services.storage.ReplicationService;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.services.storage.StorageServiceImplementor;
import fr.ird.observe.services.storage.constants.CreationMode;
import fr.ird.observe.services.storage.constants.DbMode;
import fr.ird.observe.services.storage.event.StorageServiceAdapter;
import fr.ird.observe.services.storage.event.StorageServiceEvent;
import fr.ird.observe.services.storage.event.StorageServiceListener;
import fr.ird.observe.services.storage.impl.H2StorageService;
import fr.ird.observe.services.validation.ValidationService;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.io.IOException;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationAction;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class SynchroOperationAction
extends WizardOperationAction<SynchroStep, SynchroUIModel> {
    private static final Log log = LogFactory.getLog(SynchroOperationAction.class);
    JAXXContext context;
    private final ReplicationService replicationService = ObserveServiceHelper.newReplicationService();
    private final ValidationService validationService = ObserveServiceHelper.newValidationService();
    private final GPSService gpsService = ObserveServiceHelper.newGPSService();
    private DecoratorService decoratorService;
    protected final StorageServiceListener serviceLogger = new StorageServiceAdapter(){

        public void onNewMessage(StorageServiceEvent event) {
            StorageService service = event.getSource();
            if (event.getMessageLevel() == StorageServiceEvent.MessageLevel.INFO) {
                SynchroOperationAction.this.sendMessage(service.getShortLabel() + " : " + event.getMessage());
            }
        }
    };

    public SynchroOperationAction(SynchroStep operation) {
        super((WizardOperationStep)operation);
    }

    private ReplicationService getReplicationService() {
        return this.replicationService;
    }

    public ValidationService getValidationService() {
        return this.validationService;
    }

    public DecoratorService getDecoratorService() {
        if (this.decoratorService == null) {
            this.decoratorService = ObserveContext.get().getDecoratorService();
        }
        return this.decoratorService;
    }

    public GPSService getGpsService() {
        return this.gpsService;
    }

    public void start(JAXXContext context) {
        ObserveContext.getObserveMainUI().setBusy(true);
        log.trace((Object)this);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.start", (Object[])new Object[]{new Date()}));
        this.context = context;
        this.execute();
    }

    protected SynchroUIModel getModel() {
        SynchroUIModel model = (SynchroUIModel)((Object)this.context.getContextValue(SynchroUIModel.class));
        return model;
    }

    protected JAXXContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        try {
            super.done();
        }
        finally {
            ObserveContext.getObserveMainUI().setBusy(false);
        }
    }

    public WizardOperationState onCancel(SynchroUIModel model, Exception e) {
        log.trace((Object)this);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.canceled"));
        return WizardOperationState.CANCELED;
    }

    public WizardOperationState onError(SynchroUIModel model, Exception e) {
        this.setError(e);
        log.error((Object)e.getMessage(), (Throwable)e);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.failed"));
        return WizardOperationState.FAILED;
    }

    public void copyTo(SynchroOperationAction newAction) {
    }

    protected StorageService<?> createLocalService(StorageUIModel model, StorageService<?> previousService) throws Exception {
        if (model.isLocalStorageExist() && model.getDbMode() == DbMode.CREATE_LOCAL && model.getCreationMode() != CreationMode.USE_LOCAL_STORAGE) {
            StorageService<?> localService;
            this.sendMessage(I18n._((String)"observe.message.synchro.destroy.local.db"));
            log.debug((Object)("destroy previous local database (try to use " + previousService + ")"));
            if (previousService != null && previousService instanceof H2StorageService && previousService.isOpen()) {
                localService = previousService;
            } else {
                localService = ObserveContext.get().newLocalStorageService();
                this.addStorageServiceLogger(localService);
                localService.doOpen();
            }
            localService.doClose(true);
            this.removeStorageServiceLogger(localService);
            ObserveConfig config = ObserveContext.getConfig();
            config.setLocalStorageExist(false);
        }
        StorageUIHandler handler = (StorageUIHandler)this.getContext().getContextValue(StorageUIHandler.class);
        if (previousService != null && previousService instanceof H2StorageService && model.getDbMode() == DbMode.CREATE_LOCAL && previousService.isOpen()) {
            previousService.doClose(false);
            this.removeStorageServiceLogger(previousService);
        }
        StorageService<?> service = handler.newServiceFromModel(this.context, model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
        this.addStorageServiceLogger(service);
        return service;
    }

    protected StorageService<?> createReferentielService(StorageUIModel model) throws IOException {
        StorageUIHandler handler = (StorageUIHandler)this.getContext().getContextValue(StorageUIHandler.class);
        StorageService<?> service = handler.newServiceFromModel(this.context, model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
        this.addStorageServiceLogger(service);
        return service;
    }

    protected StorageService<?> createSynchroService() throws IOException {
        ObserveConfig mainConfig = ObserveContext.getConfig();
        StorageService service = ObserveServiceHelper.newEmptyTempStorage((IObserveConfig)mainConfig, (String)I18n.n_((String)"observe.storage.label.synchro"), (String)"synchrodb");
        ObserveContext.get().prepareMainStorage(service);
        service.getConfig().setUseCache(false);
        this.addStorageServiceLogger(service);
        return service;
    }

    protected void addStorageServiceLogger(StorageService<?> service) {
        ((StorageServiceImplementor)service).addStorageServiceListener(this.serviceLogger);
    }

    protected void removeStorageServiceLogger(StorageService<?> service) {
        ((StorageServiceImplementor)service).removeStorageServiceListener(this.serviceLogger);
    }

    protected void openService(StorageService<?> service) throws StorageServiceException {
        if (!service.isOpen()) {
            service.doOpen();
        }
    }

    protected void replicateData(StorageService<?> source, StorageService<?> target, String ... mareeIds) throws StorageServiceException {
        if (mareeIds == null || mareeIds.length == 0) {
            this.getReplicationService().replicateAllData(this.getDecoratorService(), source, target);
        } else {
            this.getReplicationService().replicateData(this.getDecoratorService(), source, target, mareeIds);
        }
    }

    protected void replicateReferentiel(StorageService<?> source, StorageService<?> target) throws StorageServiceException {
        this.getReplicationService().replicateReferentiel(this.getDecoratorService(), source, target);
    }

    protected abstract void destroy();

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

