/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.entities.referentiel.ReferentielEntity;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveReferentielListCellRenderer
extends DecoratorListCellRenderer {
    private static final Log log = LogFactory.getLog(ObserveReferentielListCellRenderer.class);
    protected Color normalColor;
    protected Color disableColor = Color.LIGHT_GRAY;

    public ObserveReferentielListCellRenderer(Decorator<?> decorator) {
        super(decorator);
    }

    public ObserveReferentielListCellRenderer(ListCellRenderer delegate, Decorator<?> decorator) {
        super(delegate, decorator);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent comp = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (this.normalColor == null) {
            this.normalColor = comp.getForeground();
        }
        Color col = this.normalColor;
        if (value != null && value instanceof ReferentielEntity) {
            ReferentielEntity e = (ReferentielEntity)value;
            int status = e.getStatus();
            if (status == 0) {
                col = this.disableColor;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use disabled color for entity " + e.getTopiaId() + " : " + this.decorator.toString((Object)e)));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("use normal color for entity " + e.getTopiaId() + " : " + this.decorator.toString((Object)e)));
            }
        }
        comp.setForeground(col);
        return comp;
    }
}

