/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureFaune;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.referentiel.DevenirFaune;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.entities.referentiel.RaisonRejet;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentTableHandler;
import fr.ird.observe.ui.content.ObserveContentTableModel;
import fr.ird.observe.ui.content.ObserveContentTableUI;
import fr.ird.observe.ui.content.data.CaptureFauneUI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CaptureFauneHandler
extends ObserveContentTableHandler<Calee, CaptureFaune, CaptureFauneUI> {
    private static Log log = LogFactory.getLog(CaptureFauneHandler.class);

    public CaptureFauneHandler() {
        super("captureFaune", Calee.class, CaptureFaune.class, new String[]{"captureFaune", "rejetFaune", "echantillonFaune"}, new String[]{"espece", "poidsEstime", "nombreEstime", "poidsMoyen", "tailleMoyenne", "raisonRejet", "devenirFaune", "nombreEstimeCalcule", "poidsMoyenCalcule", "poidsEstimeCalcule", "tailleMoyenneCalcule", "commentaire"});
    }

    @Override
    public ObserveContentTableModel<Calee, CaptureFaune> newTableModel(ObserveContentTableUI<Calee, CaptureFaune> context) {
        ArrayList metas = new ArrayList();
        metas.add(this.newTableMeta("espece", false));
        metas.add(this.newTableMeta("devenirFaune", false));
        metas.add(this.newTableMeta("raisonRejet", false));
        metas.add(this.newTableMeta("poidsEstime", false));
        metas.add(this.newTableMeta("nombreEstime", false));
        metas.add(this.newTableMeta("poidsMoyen", false));
        metas.add(this.newTableMeta("tailleMoyenne", false));
        metas.add(this.newTableMeta("commentaire", false));
        return new ObserveContentTableModel<Calee, CaptureFaune>(context, metas);
    }

    @Override
    protected void onSelectedRowChanged(CaptureFauneUI context, ObserveContentTableModel<Calee, CaptureFaune> model, int editingRow, CaptureFaune bean, boolean create) {
        if (model.isEditable()) {
            context.getEspece().requestFocus();
        } else {
            context.getTable().requestFocus();
        }
    }

    @Override
    protected void initTableUI(CaptureFauneUI context, DefaultTableCellRenderer renderer) {
        JTable table = context.getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)65);
        UIHelper.fixTableColumnWidth((JTable)table, (int)5, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table, (int)6, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)7, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.captureFaune.especeFaune"), I18n.n_((String)"observe.table.captureFaune.especeFaune.tip"), I18n.n_((String)"observe.table.captureFaune.devenirFaune"), I18n.n_((String)"observe.table.captureFaune.devenirFaune.tip"), I18n.n_((String)"observe.table.captureFaune.raisonRejet"), I18n.n_((String)"observe.table.captureFaune.raisonRejet.tip"), I18n.n_((String)"observe.table.captureFaune.poidsEstime"), I18n.n_((String)"observe.table.captureFaune.poidsEstime.tip"), I18n.n_((String)"observe.table.captureFaune.nombreEstime"), I18n.n_((String)"observe.table.captureFaune.nombreEstime.tip"), I18n.n_((String)"observe.table.captureFaune.poidsMoyen"), I18n.n_((String)"observe.table.captureFaune.poidsMoyen.tip"), I18n.n_((String)"observe.table.captureFaune.tailleMoyenne"), I18n.n_((String)"observe.table.captureFaune.tailleMoyenne.tip"), I18n.n_((String)"observe.table.captureFaune.commentaire"), I18n.n_((String)"observe.table.captureFaune.commentaire.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, DevenirFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, RaisonRejet.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)6, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)7, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    @Override
    protected boolean prepareSave(CaptureFauneUI context, Calee toSave, Calee editBean, List<CaptureFaune> objets) {
        super.prepareSave(context, toSave, editBean, objets);
        EchantillonFaune echantillon = (EchantillonFaune)editBean.getEchantillonFaune().get(0);
        List especesUsed = this.getTableModel(context).getColumnValues(0);
        HashSet<TailleFaune> tailleToDelete = new HashSet<TailleFaune>();
        HashSet<EspeceFaune> especesToDelete = new HashSet<EspeceFaune>();
        if (echantillon != null && echantillon.getTailleFaune() != null) {
            for (TailleFaune taille : echantillon.getTailleFaune()) {
                EspeceFaune tailleEspece = taille.getEspece();
                if (especesUsed.contains(tailleEspece)) continue;
                tailleToDelete.add(taille);
                especesToDelete.add(tailleEspece);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("remove obsolote echantillon " + taille + " for espece " + tailleEspece));
            }
        }
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            Decorator<EspeceFaune> decorator = ObserveContext.getDecorator(EspeceFaune.class);
            Decorator<TailleFaune> decorator2 = ObserveContext.getDecorator(TailleFaune.class);
            for (EspeceFaune e : especesToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (TailleFaune t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.table.captureFaune.will.delete.tailleFaune", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n._((String)"observe.choice.continue"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            echantillon.getTailleFaune().removeAll(tailleToDelete);
        }
        boolean hasRejet = false;
        for (CaptureFaune c : objets) {
            if (c.getRaisonRejet() == null) continue;
            hasRejet = true;
            break;
        }
        editBean.setRejetFaune(hasRejet);
        return true;
    }
}

