/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.ObserveDecoratorProvider;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.ProgrammeDAO;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.admin.actions.SaveLocalAction;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.validation.ValidatorDetector;
import fr.ird.observe.validation.ValidatorMessageDetector;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class ValidateDataAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(ValidateDataAction.class);
    protected boolean wasInit;
    protected boolean treeInit;
    protected int nbInvalidEntities;
    protected ValidatorMessageDetector messageDetector;
    protected List<String> programmeIds = new ArrayList<String>();
    protected SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> refs;

    public ValidateDataAction() {
        super(SynchroStep.VALIDATE_DATA);
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        StorageUIModel localServiceModel = model.getLocalServiceModel();
        if (model.getLocalService() == null) {
            model.setLocalService(this.createLocalService(localServiceModel, model.getPreviousService()));
        }
        if (model.getSynchroService() == null) {
            model.setSynchroService(this.createSynchroService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WizardOperationState initDB(SynchroUIModel model) throws Exception {
        StorageService<?> sourceService = model.getLocalService();
        StorageService<?> tmpService = model.getSynchroService();
        this.openService(sourceService);
        if (!tmpService.isOpen()) {
            this.sendMessage(I18n._((String)"observe.message.validation.create.synchro.from.source"));
            this.openService(tmpService);
            if (this.isCancelled()) {
                return this.onCancel(model, (Exception)null);
            }
            sourceService.replicateReferentiel(tmpService);
            if (this.isCancelled()) {
                return this.onCancel(model, (Exception)null);
            }
            sourceService.replicateAllData(tmpService);
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.sendMessage(I18n._((String)"observe.message.validation.prepare.programme.to.validate"));
        TopiaContext ctxt = tmpService.getCtxt();
        try {
            List progs = ObserveDAOHelper.getProgrammeDAO((TopiaContext)ctxt).findAll();
            for (Programme p : progs) {
                if (p.sizeMaree() == 0) {
                    this.sendMessage(I18n._((String)"observe.message.validation.skip.programme.to.validate.no.maree", (Object[])new Object[]{p.getLibelle2()}));
                    continue;
                }
                this.programmeIds.add(p.getTopiaId());
                this.sendMessage(I18n._((String)"observe.message.validation.detect.programme.to.validate", (Object[])new Object[]{p.getLibelle2(), p.sizeMaree()}));
            }
            this.sendMessage(I18n._((String)"observe.message.validation.programme.to.validate", (Object[])new Object[]{this.programmeIds.size()}));
            if (!progs.isEmpty()) {
                this.sendMessage(I18n._((String)"observe.message.validation.prepare.validators"));
                ValidatorDetector validatorDetector = new ValidatorDetector();
                Map validators = validatorDetector.detect("n1-update", (TopiaEntity[])progs.toArray(new Programme[progs.size()]));
                if (!validators.isEmpty()) {
                    this.messageDetector = new ValidatorMessageDetector("n1-update", validators);
                    for (BeanValidator v : validators.values()) {
                        String label = I18n._((String)DBHelper.getEntityLabel((Class)v.getBeanClass()));
                        this.sendMessage(I18n._((String)"observe.message.validation.detected", (Object[])new Object[]{label}));
                    }
                } else {
                    this.sendMessage(I18n._((String)"observe.message.no.validation.detected"));
                }
            }
            if (this.isCancelled()) {
                WizardOperationState wizardOperationState = this.onCancel(model, (Exception)null);
                return wizardOperationState;
            }
        }
        finally {
            this.wasInit = true;
        }
        return null;
    }

    protected void prepareTree(SynchroUIModel model) throws Exception {
        ObserveContext rootcontext = ObserveContext.get();
        ObserveDataContext dataContext = (ObserveDataContext)rootcontext.getContextValue(ObserveDataContext.class);
        ArrayList<Programme> progs = new ArrayList<Programme>(this.programmeIds.size());
        TopiaContext ctxt = model.getSynchroService().getCtxt();
        ProgrammeDAO dao = ObserveDAOHelper.getProgrammeDAO((TopiaContext)ctxt);
        for (String id : this.programmeIds) {
            Programme p = (Programme)dao.findByTopiaId(id);
            progs.add(p);
            p.update();
        }
        ctxt.commitTransaction();
        dataContext.getDelegate().setContextValue(progs, Programme.class.getSimpleName());
        dataContext.updateOpenables();
        ObserveMainUI mainUI = ObserveContext.getObserveMainUI();
        ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
        treeHelper.cleanNavigationUI(mainUI);
        treeHelper.loadNavigationUI(mainUI);
    }

    @Override
    public void copyTo(SynchroOperationAction newAction) {
        ValidateDataAction n = (ValidateDataAction)newAction;
        n.wasInit = this.wasInit;
        n.treeInit = this.treeInit;
        n.messageDetector = this.messageDetector;
        n.programmeIds = this.programmeIds;
        n.nbInvalidEntities = this.nbInvalidEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        WizardOperationState init = null;
        if (!this.wasInit) {
            init = this.initDB(model);
        }
        if (init != null) {
            return init;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.launchValidation(model);
        if (this.refs == null || this.refs.isEmpty()) {
            if (this.nbInvalidEntities > 0) {
                SaveLocalAction saveAction = (SaveLocalAction)model.getOperationAction(SynchroStep.SAVE_LOCAL);
                saveAction.addStepForSave(model, SynchroStep.VALIDATE_DATA);
            }
            this.sendMessage(I18n._((String)"observe.message.validation.nothing.to.do"));
            this.sendMessage(I18n._((String)"observe.message.validation.operation.done", (Object[])new Object[]{new Date()}));
            return WizardOperationState.SUCCESSED;
        }
        if (!this.treeInit) {
            try {
                this.prepareTree(model);
            }
            finally {
                this.treeInit = true;
            }
        }
        if (this.refs.size() > this.nbInvalidEntities) {
            this.nbInvalidEntities = this.refs.size();
        }
        this.sendMessage(I18n._((String)"observe.message.validation.operation.needFix", (Object[])new Object[]{new Date()}));
        return WizardOperationState.NEED_FIX;
    }

    public SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> getRefs() {
        return this.refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchValidation(SynchroUIModel model) throws TopiaException {
        if (this.messageDetector == null) {
            return;
        }
        if (this.refs != null) {
            this.refs.clear();
        }
        this.refs = null;
        ObserveDecoratorProvider decoratorProvider = (ObserveDecoratorProvider)this.getContext().getContextValue(ObserveDecoratorProvider.class);
        TopiaContext ctxt = model.getSynchroService().getCtxt();
        try {
            ProgrammeDAO dao = ObserveDAOHelper.getProgrammeDAO((TopiaContext)ctxt);
            for (String id : this.programmeIds) {
                Programme p = (Programme)dao.findByTopiaId(id);
                this.sendMessage(I18n._((String)"observe.message.validation.detects.error", (Object[])new Object[]{p.getLibelle2()}));
                SortedMap tmpRefs = this.messageDetector.detect(new TopiaEntity[]{p});
                if (tmpRefs.isEmpty()) {
                    this.sendMessage(I18n._((String)"observe.message.validation.detects.no.error", (Object[])new Object[]{p.getLibelle2()}));
                    continue;
                }
                this.sendMessage(I18n._((String)"observe.message.validation.detects.detected.error", (Object[])new Object[]{p.getLibelle2()}));
                if (this.refs == null) {
                    this.refs = new TreeMap();
                }
                for (TopiaEntityRef ref : tmpRefs.keySet()) {
                    TopiaEntity entityref = ref.getRef();
                    Decorator decorator = decoratorProvider.getDecorator((Object)entityref);
                    List messages = (List)tmpRefs.get(ref);
                    int nberrors = messages.size();
                    String label = I18n._((String)DBHelper.getEntityLabel(entityref.getClass()));
                    if (nberrors == 1) {
                        this.sendMessage(I18n._((String)"observe.message.validation.detects.detected.error.for.entity", (Object[])new Object[]{label, decorator.toString((Object)entityref)}));
                    } else {
                        this.sendMessage(I18n._((String)"observe.message.validation.detects.detected.errors.for.entity", (Object[])new Object[]{nberrors, label, decorator.toString((Object)entityref)}));
                    }
                    for (BeanValidatorMessage message : messages) {
                        this.sendMessage("\t- " + message.getMessage());
                    }
                    List oldMessages = (List)this.refs.get(ref);
                    if (oldMessages != null) {
                        oldMessages.addAll(messages);
                        this.refs.put(ref, oldMessages);
                        continue;
                    }
                    this.refs.put(ref, messages);
                }
            }
        }
        finally {
            ctxt.rollbackTransaction();
        }
    }
}

