/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.admin.actions.SaveLocalAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationState;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.DiffState;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class SynchronizeReferentielAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(SynchronizeReferentielAction.class);
    SortedMap<TopiaEntity, List<TopiaEntityRef>> obsoleteRefs = null;
    EnumMap<DiffState, List<String>> diff;

    public SynchronizeReferentielAction() {
        super(SynchroStep.SYNCHRONIZE_REFERENTIEL);
    }

    public SortedMap<TopiaEntity, List<TopiaEntityRef>> getObsoleteRefs() {
        return this.obsoleteRefs;
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (model.getLocalService() == null) {
            model.setLocalService(this.createLocalService(model.getLocalServiceModel(), model.getPreviousService()));
        }
        if (model.getReferentielService() == null) {
            model.setReferentielService(this.createReferentielService(model.getReferentielServiceModel()));
        }
        if (model.getSynchroService() == null) {
            model.setSynchroService(this.createSynchroService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        StorageService<?> sourceService = model.getLocalService();
        StorageService<?> referentielService = model.getReferentielService();
        StorageService<?> tmpService = model.getSynchroService();
        this.openService(sourceService);
        this.openService(referentielService);
        this.openService(tmpService);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        referentielService.replicateReferentiel(tmpService);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.diff = tmpService.buildReferentielDifferentiel(sourceService);
        List<String> removedList = this.diff.get(DiffState.REMOVED);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        TopiaContext sourceCtxt = sourceService.getCtxt();
        TopiaContext tmpCtxt = tmpService.getCtxt();
        try {
            List programmes;
            if (removedList != null) {
                programmes = ObserveDAOHelper.getProgrammeDAO((TopiaContext)sourceCtxt).findAll();
                String[] obsoleteEntities = removedList.toArray(new String[removedList.size()]);
                this.obsoleteRefs = TopiaEntityHelper.detectReferences((TopiaEntityEnum[])ObserveDAOHelper.getContracts(), (String[])obsoleteEntities, (Collection)programmes);
            }
            if (this.isCancelled()) {
                programmes = this.onCancel(model, (Exception)null);
                return programmes;
            }
            if (this.obsoleteRefs != null && !this.obsoleteRefs.isEmpty()) {
                ArrayList<TopiaEntity> obsoleteEntities = new ArrayList<TopiaEntity>(this.obsoleteRefs.keySet());
                for (ObserveDAOHelper.ObserveEntityEnum constant : DBHelper.REFERENTIEL_ENTITIES) {
                    Class contractClass = constant.getContract();
                    ArrayList<TopiaEntity> toReplicate = new ArrayList<TopiaEntity>();
                    Iterator itr = obsoleteEntities.iterator();
                    while (itr.hasNext()) {
                        TopiaEntity e = (TopiaEntity)itr.next();
                        if (!contractClass.isAssignableFrom(e.getClass())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("obsolete to inject : " + e.getTopiaId()));
                        }
                        itr.remove();
                        if (constant == ObserveDAOHelper.ObserveEntityEnum.Programme) {
                            Programme p = (Programme)e;
                            if (p.sizeMaree() == 0) {
                                log.debug((Object)("remove ref to " + p.getTopiaId()));
                                this.obsoleteRefs.remove(e);
                                continue;
                            }
                            ((Programme)e).setMaree(null);
                        }
                        toReplicate.add(e);
                    }
                    if (toReplicate.isEmpty()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("no obsolete entity " + constant));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("inject obsolete entity " + constant + " (" + toReplicate.size() + ")"));
                    }
                    sourceCtxt.replicateEntities(tmpCtxt, toReplicate);
                    tmpCtxt.commitTransaction();
                }
                tmpCtxt.commitTransaction();
                if (!obsoleteEntities.isEmpty()) {
                    throw new IllegalStateException("there is still obsolete entities to inject in synchro db : " + obsoleteEntities);
                }
                if (this.isCancelled()) {
                    WizardOperationState arr$ = this.onCancel(model, (Exception)null);
                    return arr$;
                }
                Iterator<Map.Entry<TopiaEntity, List<TopiaEntityRef>>> itr = this.obsoleteRefs.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<TopiaEntity, List<TopiaEntityRef>> entry = itr.next();
                    Iterator<TopiaEntityRef> itrRef = entry.getValue().iterator();
                    while (itrRef.hasNext()) {
                        TopiaEntityRef ref = itrRef.next();
                        TopiaEntity refInvoker = ref.getInvoker();
                        if (refInvoker == null) {
                            itrRef.remove();
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)("remove ref " + ref));
                            continue;
                        }
                        ObserveDAOHelper.ObserveEntityEnum refConstant = ObserveDAOHelper.ObserveEntityEnum.valueOf((TopiaEntity)refInvoker);
                        if (DBHelper.DATA_ENTITIES_LIST.contains(refConstant)) continue;
                        itrRef.remove();
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("remove ref " + ref));
                    }
                    if (!entry.getValue().isEmpty()) continue;
                    itr.remove();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("remove obsolete entity (not direct referentiel) : " + entry.getKey().getTopiaId()));
                }
            }
        }
        finally {
            sourceCtxt.rollbackTransaction();
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        log.debug((Object)"replicate user data to synchro");
        sourceService.replicateAllData(tmpService);
        if (this.obsoleteRefs == null || this.obsoleteRefs.isEmpty()) {
            boolean needSave = false;
            if (!this.isEmpty((Collection)this.diff.get(DiffState.REMOVED))) {
                needSave = true;
                this.sendMessage(I18n._((String)"observe.message.synchro.referentiel.was.removed"));
            }
            if (!this.isEmpty((Collection)this.diff.get(DiffState.NEW))) {
                needSave = true;
                this.sendMessage(I18n._((String)"observe.message.synchro.referentiel.was.added"));
            }
            if (!this.isEmpty((Collection)this.diff.get(DiffState.MODIFIED))) {
                needSave = true;
                this.sendMessage(I18n._((String)"observe.message.synchro.referentiel.was.modified"));
            }
            if (needSave) {
                SaveLocalAction saveAction = (SaveLocalAction)model.getOperationAction(SynchroStep.SAVE_LOCAL);
                saveAction.addStepForSave(model, SynchroStep.SYNCHRONIZE_REFERENTIEL);
                this.sendMessage(I18n._((String)"observe.message.synchro.local.modification"));
                this.sendMessage(I18n._((String)"observe.message.synchro.no.referentiel.conflict"));
            } else {
                this.sendMessage(I18n._((String)"observe.message.synchro.ref.is.updtodate"));
            }
            this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
            return WizardOperationState.SUCCESSED;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        SaveLocalAction saveAction = (SaveLocalAction)model.getOperationAction(SynchroStep.SAVE_LOCAL);
        saveAction.addStepForSave(model, SynchroStep.SYNCHRONIZE_REFERENTIEL);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.needFix"));
        return WizardOperationState.NEED_FIX;
    }

    public <E extends TopiaEntity> List<E> getEntityListFromSynchroDB(Class<E> entityClass, boolean removeObsoletes) {
        ArrayList list;
        try {
            list = this.getModel().getSynchroService().getList(entityClass);
        }
        catch (StorageServiceException ex) {
            log.error((Object)ex);
            list = new ArrayList();
        }
        if (removeObsoletes) {
            List<String> removedList = this.diff.get(DiffState.REMOVED);
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                TopiaEntity e = (TopiaEntity)itr.next();
                if (!removedList.contains(e.getTopiaId())) continue;
                itr.remove();
            }
        }
        return list;
    }

    public void resolvObsoleteReferences(TopiaEntity obsoleteRef, List<TopiaEntityRef> refs, TopiaEntity safeRef) {
        try {
            if (obsoleteRef instanceof Programme) {
                throw new IllegalArgumentException("can not resolve obsolete programme " + obsoleteRef.getTopiaId());
            }
            List globalRefs = (List)this.obsoleteRefs.get(obsoleteRef);
            TopiaContext ctxt = this.getModel().getSynchroService().getCtxt();
            obsoleteRef = ctxt.findByTopiaId(obsoleteRef.getTopiaId());
            log.debug((Object)("resolve obsolete property " + obsoleteRef.getTopiaId()));
            safeRef = ctxt.findByTopiaId(safeRef.getTopiaId());
            for (TopiaEntityRef ref : refs) {
                TopiaEntity invoker = ref.getInvoker();
                if (invoker == null) {
                    throw new NullPointerException("can not have a null invoker in " + ref);
                }
                invoker = ctxt.findByTopiaId(invoker.getTopiaId());
                JXPathContext jxcontext = JXPathContext.newContext((Object)invoker);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property to switch " + ref.getInvokerProperty() + " old        : " + jxcontext.getValue(ref.getInvokerProperty())));
                }
                jxcontext.setValue(ref.getInvokerProperty(), (Object)safeRef);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property to switch " + ref.getInvokerProperty() + " new        : " + safeRef));
                    log.debug((Object)("property to switch " + ref.getInvokerProperty() + " new Check  : " + jxcontext.getValue(ref.getInvokerProperty())));
                }
                invoker.update();
                ctxt.commitTransaction();
                globalRefs.remove(ref);
                this.firePropertyChange("refsResolved", null, obsoleteRef);
            }
            if (globalRefs.isEmpty()) {
                this.obsoleteRefs.remove(obsoleteRef);
                log.debug((Object)("remove resolved obsolete property from temp db : " + obsoleteRef.getTopiaId()));
                obsoleteRef.delete();
                ctxt.commitTransaction();
                this.firePropertyChange("obsoleteResolved", null, obsoleteRef);
            }
            if (this.obsoleteRefs.isEmpty()) {
                this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
                this.getModel().setOperationState(WizardOperationState.SUCCESSED);
            }
        }
        catch (Exception e) {
            this.getModel().setOperationState(this.onError(this.getModel(), e));
        }
    }

    protected boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }
}

