/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.ProgrammeDAO;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.admin.actions.SynchronizeReferentielAction;
import fr.ird.observe.ui.admin.actions.ValidateDataAction;
import java.io.File;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.DiffState;

public class SaveLocalAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(SaveLocalAction.class);
    protected Set<SynchroStep> stepsForSave = new HashSet<SynchroStep>();

    public SaveLocalAction() {
        super(SynchroStep.SAVE_LOCAL);
    }

    public void addStepForSave(SynchroUIModel model, SynchroStep step) {
        this.stepsForSave.add(step);
        model.setLocalServiceNeedSave(true);
    }

    public boolean containsStepForsave(SynchroStep step) {
        return this.stepsForSave.contains((Object)step);
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (!model.isLocalServiceNeedSave()) {
            this.sendMessage("Aucune modification sur la base locale, op\u00e9ration non requise.");
            return WizardOperationState.SUCCESSED;
        }
        if (!model.getLocalService().containsStorageServiceListener(this.serviceLogger)) {
            model.getLocalService().addStorageServiceListener(this.serviceLogger);
        }
        if (!model.getSynchroService().containsStorageServiceListener(this.serviceLogger)) {
            model.getSynchroService().addStorageServiceListener(this.serviceLogger);
        }
        try {
            SynchroOperationAction action;
            if (model.isDoBackup()) {
                this.sendMessage("Sauvegarde de la base locale vers " + model.getBackupFile());
                File backupFile = model.getBackupFile();
                model.getLocalService().storeDB(backupFile);
            }
            this.deleteData(model.getLocalService());
            if (this.containsStepForsave(SynchroStep.SYNCHRONIZE_REFERENTIEL)) {
                this.sendMessage("Sauvegarde du r\u00e9f\u00e9rentiel.");
                action = (SynchronizeReferentielAction)model.getOperationAction(SynchroStep.SYNCHRONIZE_REFERENTIEL);
                this.saveReferentiel((SynchronizeReferentielAction)action, model);
            }
            if (this.containsStepForsave(SynchroStep.VALIDATE_DATA)) {
                this.sendMessage("Mise \u00e0 jour du niveau de v\u00e9rification des donn\u00e9es observateurs.");
                action = (ValidateDataAction)model.getOperationAction(SynchroStep.VALIDATE_DATA);
                this.updateNiveauVerification((ValidateDataAction)action, model);
            }
            this.sendMessage("Sauvegarde des donn\u00e9es observateurs.");
            model.getSynchroService().replicateAllData(model.getLocalService());
        }
        finally {
            model.getSynchroService().removeStorageServiceListener(this.serviceLogger);
            model.getLocalService().removeStorageServiceListener(this.serviceLogger);
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardOperationState.SUCCESSED;
    }

    protected void saveReferentiel(SynchronizeReferentielAction action, SynchroUIModel model) throws Exception {
        EnumMap<DiffState, List<String>> diff = action.diff;
        TopiaContext sourceCtxt = model.getLocalService().getCtxt().beginTransaction();
        TopiaContext tmpCtxt = model.getSynchroService().getCtxt().beginTransaction();
        try {
            TopiaEntity entity;
            List<String> ids = diff.get(DiffState.REMOVED);
            if (ids != null) {
                for (String id : ids) {
                    this.sendMessage("suppression de l'objet " + id + " de la base locale");
                    entity = sourceCtxt.findByTopiaId(id);
                    entity.delete();
                }
            }
            if ((ids = diff.get(DiffState.NEW)) != null) {
                for (String id : ids) {
                    entity = tmpCtxt.findByTopiaId(id);
                    this.sendMessage("ajout de l'objet " + id + " dans la base locale");
                    tmpCtxt.replicateEntity(sourceCtxt, entity);
                }
            }
            if ((ids = diff.get(DiffState.MODIFIED)) != null) {
                for (String id : ids) {
                    entity = tmpCtxt.findByTopiaId(id);
                    this.sendMessage("mise \u00e0 jour de l'objet " + id + " dans la base locale");
                    if (entity instanceof Programme) {
                        Programme p0 = (Programme)entity;
                        Programme p = (Programme)ObserveDAOHelper.getProgrammeDAO((TopiaContext)sourceCtxt).findByTopiaId(id);
                        p.setCode(p0.getCode());
                        p.setTopiaVersion(p0.getTopiaVersion() - 1L);
                        p.setTopiaCreateDate(p0.getTopiaCreateDate());
                        p.setLibelle1(p0.getLibelle1());
                        p.setLibelle2(p0.getLibelle2());
                        p.setLibelle3(p0.getLibelle3());
                        p.setLibelle4(p0.getLibelle4());
                        p.setLibelle5(p0.getLibelle5());
                        p.setLibelle6(p0.getLibelle6());
                        p.setLibelle7(p0.getLibelle7());
                        p.setLibelle8(p0.getLibelle8());
                        p.update();
                        continue;
                    }
                    ObserveDAOHelper.getDAO((TopiaContext)sourceCtxt, (TopiaEntity)entity).update(entity);
                }
            }
            sourceCtxt.commitTransaction();
        }
        catch (Exception e) {
            sourceCtxt.rollbackTransaction();
            throw e;
        }
        finally {
            sourceCtxt.closeContext();
            tmpCtxt.rollbackTransaction();
            tmpCtxt.closeContext();
        }
    }

    protected void deleteData(StorageService<?> service) throws TopiaException {
        TopiaContext sourceCtxt = service.getCtxt().beginTransaction();
        try {
            List programmesToDelete = ObserveDAOHelper.getProgrammeDAO((TopiaContext)sourceCtxt).findAll();
            if (programmesToDelete != null && !programmesToDelete.isEmpty()) {
                for (Programme p : programmesToDelete) {
                    List marees = p.getMaree();
                    if (marees == null || marees.isEmpty()) continue;
                    this.sendMessage("Suppresion des donn\u00e9es observateurs de la base locale pour le programme " + p.getLibelle2());
                    p.clearMaree();
                    p.update();
                }
            }
            sourceCtxt.commitTransaction();
        }
        catch (TopiaException e) {
            sourceCtxt.rollbackTransaction();
            throw e;
        }
        finally {
            sourceCtxt.closeContext();
        }
    }

    protected void updateNiveauVerification(ValidateDataAction action, SynchroUIModel model) throws TopiaException {
        List<String> programmeIds = action.programmeIds;
        TopiaContext ctxt = model.getSynchroService().getCtxt();
        ProgrammeDAO dao = ObserveDAOHelper.getProgrammeDAO((TopiaContext)ctxt);
        for (String id : programmeIds) {
            Programme p = (Programme)dao.findByTopiaId(id);
            for (Maree m : p.getMaree()) {
                m.setNiveauVerification(2);
                for (Route r : m.getRoute()) {
                    r.setNiveauVerification(2);
                }
            }
            p.update();
        }
        ctxt.commitTransaction();
    }
}

